/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.analyzer.html;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.TreeMap;
import jp.oarts.pirka.core.analyzer.html.HtmlTools;
import jp.oarts.pirka.core.general.HtmlParts;
import jp.oarts.pirka.core.general.HtmlPartsType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlSplitAnalyzer
implements Serializable {
    private static final long serialVersionUID = 6298559473325517048L;

    public static List<HtmlParts> getHtmlParts(String html) {
        StringReader r = null;
        try {
            r = new StringReader(html);
            ArrayList<HtmlParts> arrayList = HtmlSplitAnalyzer.getHtmlParts(r);
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException("IO\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
        }
        finally {
            if (r != null) {
                try {
                    ((Reader)r).close();
                }
                catch (IOException e) {
                    throw new RuntimeException("IO\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
                }
            }
        }
    }

    public static ArrayList<HtmlParts> getHtmlParts(Reader r) throws IOException {
        Stack<String> deepStack = new Stack<String>();
        int deep = 0;
        String[] parts = HtmlSplitAnalyzer.split(r);
        HtmlParts[] htmlPatrs = new HtmlParts[parts.length];
        int i = parts.length - 1;
        while (i >= 0) {
            htmlPatrs[i] = new HtmlParts();
            HtmlPartsType type = HtmlSplitAnalyzer.getType(parts[i]);
            htmlPatrs[i].setType(type);
            htmlPatrs[i].setOrgString(parts[i]);
            String tagName = "";
            if (type == HtmlPartsType.TAG || type == HtmlPartsType.TAG_END) {
                tagName = HtmlSplitAnalyzer.getTagName(parts[i]);
                TreeMap<String, String> optionMap = HtmlTools.getOptionMap(parts[i]);
                htmlPatrs[i].setOption(optionMap);
                String name = optionMap.get("name");
                if (name != null && name.length() > 0) {
                    htmlPatrs[i].setName(name);
                }
            }
            htmlPatrs[i].setTagName(tagName);
            if (htmlPatrs[i].getType() == HtmlPartsType.TAG_END) {
                deepStack.push(tagName);
                htmlPatrs[i].setDeep(deep);
                ++deep;
            } else if (htmlPatrs[i].getType() == HtmlPartsType.TAG) {
                if (deepStack.size() > 0 && ((String)deepStack.peek()).equals(tagName)) {
                    htmlPatrs[i].setDeep(--deep);
                    deepStack.pop();
                } else {
                    htmlPatrs[i].setDeep(deep);
                }
            } else {
                htmlPatrs[i].setDeep(deep);
            }
            --i;
        }
        if (htmlPatrs.length > 0 && htmlPatrs[0].getDeep() != 0) {
            throw new RuntimeException("HTML\u306e\u89e3\u6790\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u30bf\u30b0\u306e\u968e\u5c64\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
        }
        ArrayList<HtmlParts> list = new ArrayList<HtmlParts>();
        HtmlSplitAnalyzer.gatherHtmlParts(list, 0, 0, htmlPatrs);
        return list;
    }

    private static int gatherHtmlParts(ArrayList<HtmlParts> list, int deep, int offset, HtmlParts[] baseList) {
        int i = offset;
        while (i < baseList.length) {
            if (baseList[i].getDeep() < deep) {
                return i;
            }
            if (baseList[i].getType() == HtmlPartsType.TAG) {
                if (i < baseList.length - 1) {
                    ArrayList<HtmlParts> childList;
                    if (baseList[i + 1].getDeep() > deep) {
                        childList = new ArrayList<HtmlParts>();
                        list.add(baseList[i]);
                        baseList[i].setChild(childList);
                        int nextOffset = HtmlSplitAnalyzer.gatherHtmlParts(childList, baseList[i + 1].getDeep(), i + 1, baseList);
                        if (nextOffset < 0) {
                            return -1;
                        }
                        baseList[i].setEndTag(baseList[nextOffset].getOrgString());
                        i = nextOffset;
                    } else if (baseList[i + 1].getDeep() == deep && baseList[i + 1].getType() == HtmlPartsType.TAG_END) {
                        childList = new ArrayList();
                        list.add(baseList[i]);
                        baseList[i].setChild(childList);
                        baseList[i].setEndTag(baseList[i + 1].getOrgString());
                        ++i;
                    } else {
                        list.add(baseList[i]);
                    }
                }
            } else {
                list.add(baseList[i]);
            }
            ++i;
        }
        return -1;
    }

    private static HtmlPartsType getType(String str) {
        if (str.length() >= 7 && str.substring(0, 4).equals("<!--") && str.substring(str.length() - 3).equals("-->")) {
            return HtmlPartsType.COMMENT;
        }
        if (str.length() >= 4 && str.substring(0, 2).equals("</") && HtmlTools.isTagChar(str.charAt(2)) && str.charAt(str.length() - 1) == '>') {
            return HtmlPartsType.TAG_END;
        }
        if (str.length() >= 3 && str.charAt(0) == '<' && HtmlTools.isTagChar(str.charAt(1)) && str.charAt(str.length() - 1) == '>') {
            return HtmlPartsType.TAG;
        }
        return HtmlPartsType.STRING;
    }

    private static String getTagName(String str) {
        int offset = 0;
        offset = str.charAt(1) == '/' ? 2 : 1;
        StringBuilder sb = new StringBuilder();
        int i = offset;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (HtmlTools.isTagInSeparator(c) || c == '>') break;
            sb.append(c);
            ++i;
        }
        return sb.toString().toLowerCase();
    }

    private static String[] split(Reader r) throws IOException {
        int cint;
        boolean startFlag = false;
        StringBuilder sb = new StringBuilder();
        ArrayList<String> parts = new ArrayList<String>();
        while ((cint = r.read()) >= 0) {
            char c = (char)cint;
            if (!startFlag) {
                if (c == '<') {
                    if (sb.length() > 0) {
                        parts.add(sb.toString());
                        sb.setLength(0);
                    }
                    startFlag = true;
                }
                sb.append(c);
                continue;
            }
            sb.append(c);
            if (c == '!') {
                HtmlSplitAnalyzer.commentStart(sb, r, parts);
            } else if (HtmlTools.isTagChar(c)) {
                HtmlSplitAnalyzer.tagStart(sb, r, parts);
            } else if (c == '/') {
                HtmlSplitAnalyzer.endTagStart(sb, r, parts);
            }
            startFlag = false;
        }
        if (sb.length() > 0) {
            parts.add(sb.toString());
            sb.setLength(0);
        }
        return parts.toArray(new String[0]);
    }

    private static void commentStart(StringBuilder sb, Reader r, ArrayList<String> parts) throws IOException {
        int cint;
        while ((cint = r.read()) >= 0) {
            char c = (char)cint;
            sb.append(c);
            if (sb.length() <= 4) {
                if (c == '-') continue;
                return;
            }
            if (c != '>' || sb.length() < 7 || sb.charAt(sb.length() - 2) != '-' || sb.charAt(sb.length() - 3) != '-') continue;
            parts.add(sb.toString());
            sb.setLength(0);
            return;
        }
    }

    static void tagStart(StringBuilder sb, Reader r, ArrayList<String> parts) throws IOException {
        int cint;
        while ((cint = r.read()) >= 0) {
            char c = (char)cint;
            sb.append(c);
            if (c == '>') {
                parts.add(sb.toString());
                sb.setLength(0);
                return;
            }
            if (c != '\"' && c != '\'') continue;
            HtmlTools.stringStart(sb, r, c);
        }
    }

    static void endTagStart(StringBuilder sb, Reader r, ArrayList<String> parts) throws IOException {
        int cint;
        while ((cint = r.read()) >= 0) {
            char c = (char)cint;
            sb.append(c);
            if (sb.length() == 3 && !HtmlTools.isTagChar(c)) {
                return;
            }
            if (c == '>') {
                parts.add(sb.toString());
                sb.setLength(0);
                return;
            }
            if (c != '\"' && c != '\'') continue;
            HtmlTools.stringStart(sb, r, c);
        }
    }

    public static void main(String[] args) {
        block13: {
            BufferedReader br = null;
            int no = 0;
            try {
                try {
                    URL url = HtmlSplitAnalyzer.class.getResource("/jp/oarts/hbj/control/view/FatalErrorDefaultWindow.html");
                    System.out.println("URL=" + url.toString());
                    br = new BufferedReader(new InputStreamReader(url.openStream(), "JISAutoDetect"));
                    ArrayList<HtmlParts> htmlParts = HtmlSplitAnalyzer.getHtmlParts(br);
                    for (HtmlParts part : htmlParts) {
                        System.out.println(String.valueOf(++no) + ":" + part.toString());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (br == null) break block13;
                    try {
                        br.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

