/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.analyzer.html;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import jp.oarts.pirka.core.analyzer.html.HtmlIncludeAnalyzer;
import jp.oarts.pirka.core.analyzer.html.HtmlSplitAnalyzer;
import jp.oarts.pirka.core.analyzer.html.HtmlTools;
import jp.oarts.pirka.core.general.HtmlParts;
import jp.oarts.pirka.core.general.HtmlPartsType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlMockupAnalyzer
implements Serializable {
    private static final long serialVersionUID = 8675705373946109821L;
    public static final String PIRKA_MOCK_TAG_NAME = "pirka_mockup";
    public static final String PIRKA_MOCK_CHANGE_OPTION_PREFIX_NAME = "pirka_change_";
    public static final String PIRKA_MOCK_DELETE_OPTION_PREFIX_NAME = "pirka_delete_";

    public static List<HtmlParts> cutMockup(List<HtmlParts> orgHtmlPartsList) throws IOException {
        List<HtmlParts> list = HtmlMockupAnalyzer.cutMockupTag(orgHtmlPartsList);
        HtmlMockupAnalyzer.changeMockupOption(list);
        return list;
    }

    private static List<HtmlParts> cutMockupTag(List<HtmlParts> orgHtmlPartsList) throws IOException {
        List<HtmlParts> inputList = HtmlTools.cloneHtmlPartsList(orgHtmlPartsList);
        ArrayList<HtmlParts> rtnList = new ArrayList<HtmlParts>();
        for (HtmlParts parts : inputList) {
            if (parts.getType() != HtmlPartsType.TAG) {
                rtnList.add(parts);
                continue;
            }
            if (PIRKA_MOCK_TAG_NAME.equalsIgnoreCase(parts.getTagName())) {
                if (parts.getChild() == null) continue;
                for (HtmlParts subParts : parts.getChild()) {
                    if (subParts.getType() != HtmlPartsType.COMMENT) continue;
                    String comment = subParts.getOrgString();
                    List<HtmlParts> subList = HtmlSplitAnalyzer.getHtmlParts(comment.substring(4, comment.length() - 3));
                    for (HtmlParts splitSubParts : subList) {
                        rtnList.add(splitSubParts);
                    }
                }
                continue;
            }
            rtnList.add(parts);
            if (parts.getChild() == null) continue;
            parts.setChild(HtmlMockupAnalyzer.cutMockupTag(parts.getChild()));
        }
        return rtnList;
    }

    private static void changeMockupOption(List<HtmlParts> list) {
        for (HtmlParts parts : list) {
            if (parts.getType() != HtmlPartsType.TAG) continue;
            HtmlMockupAnalyzer.changeMockupOption(parts);
            if (parts.getChild() == null) continue;
            HtmlMockupAnalyzer.changeMockupOption(parts.getChild());
        }
    }

    private static void changeMockupOption(HtmlParts parts) {
        TreeMap<String, String> optionMap = parts.getOption();
        int prefixChangeLength = PIRKA_MOCK_CHANGE_OPTION_PREFIX_NAME.length();
        int prefixDeleteLength = PIRKA_MOCK_DELETE_OPTION_PREFIX_NAME.length();
        if (optionMap != null) {
            String[] keys;
            String[] stringArray = keys = optionMap.keySet().toArray(new String[0]);
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String newKey;
                String key = stringArray[n2];
                if (key.length() > prefixDeleteLength && key.substring(0, prefixDeleteLength).equalsIgnoreCase(PIRKA_MOCK_DELETE_OPTION_PREFIX_NAME)) {
                    newKey = key.substring(prefixDeleteLength);
                    if ("name".equalsIgnoreCase(newKey)) {
                        parts.setName(null);
                    }
                    optionMap.remove(newKey);
                    optionMap.remove(key);
                } else if (key.length() > prefixChangeLength && key.substring(0, prefixChangeLength).equalsIgnoreCase(PIRKA_MOCK_CHANGE_OPTION_PREFIX_NAME)) {
                    newKey = key.substring(prefixChangeLength);
                    if ("name".equalsIgnoreCase(newKey)) {
                        parts.setName((String)optionMap.get(key));
                    }
                    optionMap.put(newKey, (String)optionMap.get(key));
                    optionMap.remove(key);
                }
                ++n2;
            }
        }
    }

    public static void main(String[] args) {
        try {
            List<HtmlParts> list = HtmlMockupAnalyzer.cutMockup(HtmlSplitAnalyzer.getHtmlParts(HtmlIncludeAnalyzer.include("/jp/oarts/pirka/core/win/Test.html")));
            System.out.println(HtmlTools.toSimpleString(list));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

