package jp.oarts.pirka.sample.instruction.is103200;

import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.util.check.PirkaChecker;
import jp.oarts.pirka.core.util.format.DateFieldFormat;
import jp.oarts.pirka.core.util.format.NumericFieldFormat;
import jp.oarts.pirka.core.win.PirkaWindow;

/**
 * pirkatTv tH[}bg̎gp@
 */
public class FormatSample extends PirkaWindow {

	/**
	 * RXgN^
	 */
	public FormatSample() {

		FieldMap field = getFieldMap();

		field.setOfficialFieldName("num", "l");
		field.setOfficialFieldName("date", "t");
		addCheck("num", PirkaChecker.intValue);
		addCheck("date", PirkaChecker.date);
		addErrorCheckReturner();

		// tH[}bgw
		field.setFormat("num", new NumericFieldFormat("#,##0"));
		field.setFormat("num01", new NumericFieldFormat("\\#,##0"));
		field.setFormat("num02", new NumericFieldFormat("00000000"));

		field.setFormat("date", new DateFieldFormat("yyyyNMd"));
		field.setFormat("date01", new DateFieldFormat("yyyyMMdd"));
		field.setFormat("date02", new DateFieldFormat("yyyy/MM/dd"));
	}

	/**
	 * s{^
	 */
	public void execButton() {
		FieldMap field = getFieldMap();
		field.setValue("num01", field.getValueInt("num"));
		field.setValue("num02", field.getValueInt("num"));
		field.setValue("date01", field.getValueDate("date"));
		field.setValue("date02", field.getValueDate("date"));
	}

	/**
	 * ߂郊N
	 * 
	 * @return
	 */
	public PirkaWindow returnWindow() {
		return null;
	}

}
