package jp.oarts.pirka.core.util.check;

import java.math.BigDecimal;

import jp.oarts.pirka.core.util.format.PirkaFormatUtil;

/**
 * l͈̓`FbJ[
 * 
 * @author ito
 * 
 */
public class PirkaCheckerNumericRange implements Checker {

	/**
	 * 
	 */
	private static final long serialVersionUID = -1879615178277880975L;

	/** ͈͎ */
	private MODE mode;

	/** ŏ */
	private long minLong;

	/** ő吮 */
	private long maxLong;

	/** ŏ */
	private BigDecimal minBigDecimal;

	/** ő */
	private BigDecimal maxBigDecimal;

	/**
	 * RXgN^<BR>
	 * l͂Ă鎞̂݃`FbNsȂ܂
	 * 
	 * @param minInt
	 *            ŏl
	 * @param maxInt
	 *            ől
	 */
	public PirkaCheckerNumericRange(int minInt, int maxInt) {
		this.mode = MODE.longVal;
		this.minLong = minInt;
		this.maxLong = maxInt;
	}

	/**
	 * RXgN^<BR>
	 * l͂Ă鎞̂݃`FbNsȂ܂
	 * 
	 * @param minLong
	 *            ŏl
	 * @param maxLong
	 *            ől
	 */
	public PirkaCheckerNumericRange(long minLong, long maxLong) {
		this.mode = MODE.longVal;
		this.minLong = minLong;
		this.maxLong = maxLong;
	}

	/**
	 * RXgN^<BR>
	 * l͂Ă鎞̂݃`FbNsȂ܂
	 * 
	 * @param minBigDecimal
	 *            ŏl
	 * @param maxBigDecimal
	 *            ől
	 */
	public PirkaCheckerNumericRange(BigDecimal minBigDecimal, BigDecimal maxBigDecimal) {
		this.mode = MODE.realVal;
		this.minBigDecimal = minBigDecimal;
		this.maxBigDecimal = maxBigDecimal;
	}

	/**
	 * `FbNsȂ܂B
	 * 
	 * @param value
	 *            `FbNsȂ
	 * @throws PirkaCheckException
	 *             G[
	 */
	public void check(String value) throws PirkaCheckException {
		if (value.length() <= 0) {
			return;
		}

		if (mode == MODE.longVal) {
			Long num = PirkaFormatUtil.parseLong(value);
			if (num == null) {
				throw new PirkaCheckException("lȊO͂܂");
			}

			if (num < minLong || maxLong < num) {
				throw new PirkaCheckException("͈͊O̐l͂܂ " + minLong + "`" + maxLong + "͈̔͂œ͉\ł");
			}
		} else {
			BigDecimal num = PirkaFormatUtil.parseBigDecimal(value);
			if (num == null) {
				throw new PirkaCheckException("lȊO͂܂");
			}

			if (minBigDecimal.compareTo(num) > 0 || maxBigDecimal.compareTo(num) < 0) {
				throw new PirkaCheckException("͈͊O̐l͂܂ " + minBigDecimal.toString() + "`" + maxBigDecimal.toString() + "͈̔͂œ͉\ł");
			}
		}
	}

	private enum MODE {
		longVal, realVal;
	}
}
