package jp.oarts.pirka.core.analyzer.html;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import jp.oarts.pirka.core.ctrl.proc.CtrlProcesser;
import jp.oarts.pirka.core.ctrl.proc.CtrlProcesserManager;
import jp.oarts.pirka.core.general.HtmlCtrlParts;
import jp.oarts.pirka.core.general.HtmlParts;
import jp.oarts.pirka.core.general.HtmlPartsType;
import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.util.field.FieldItem;

public class HtmlFieldMapAnalyzer  implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -6342236803595233193L;

	/**
	 * w肳ꂽHTMLp[cXgRg[[}bv𒊏oB
	 * 
	 * @param fieldMap
	 *            Rg[[}bv
	 * @param fieldRootMap
	 *            ƎRg[[}bv
	 * @param list
	 *            HTMLp[cXg
	 * @param ctrlProcesserMap
	 *            ƎRg[vZbT
	 */
	public static FieldMap getFieldMap(List<HtmlParts> list, Map<String, CtrlProcesser> ctrlProcesserMap) {
		if (list == null) {
			return null;
		}

		FieldMap fieldMap = new FieldMap();

		getFieldMain(fieldMap, list, ctrlProcesserMap, 0);
		// fieldMap.fix();

		return fieldMap;
	}

	/**
	 * w肳ꂽHTMLp[cXgRg[[o}bvɃZbgB
	 * 
	 * @param fieldMap
	 *            }bv
	 * @param list
	 *            HTMLp[cXg
	 * @param ctrlProcesserMap
	 *            ƎRg[vZbT
	 */
	private static void getFieldMain(FieldMap fieldMap, List<HtmlParts> list, Map<String, CtrlProcesser> ctrlProcesserMap, int loopDeepLevel) {
		for (HtmlParts parts : list) {
			if (parts.getType() == HtmlPartsType.TAG) {
				String name = parts.getOption().get("name");

				if (name != null && name.length() > 0) {
					if (fieldMap.containsKey(name)) {
						throw new RuntimeException("O^O݂܂ " + name);
					}
					HtmlCtrlParts ctrl = new HtmlCtrlParts(parts.getTagName(), parts.getOption(), parts.getChild() != null);
					CtrlProcesser ctrlProcesser = CtrlProcesserManager.getCtrlProseccer(ctrl.getProcesserNmae(), ctrlProcesserMap);
					ctrl.setCtrlProcesser(ctrlProcesser);
					ctrlProcesser.analyzeInitValue(ctrl, parts.getChild());

					if (ctrlProcesser.isLoop()) {
						FieldMap childMap = new FieldMap();
						List<FieldMap> childList = new ArrayList<FieldMap>();
						childList.add(childMap);

						FieldItem fieldItem = new FieldItem(childList, false, 0L, ctrl, null, loopDeepLevel);
						fieldMap.setFieldItem(name, fieldItem);

						if (parts.getChild() != null) {
							getFieldMain(childMap, parts.getChild(), ctrlProcesserMap, loopDeepLevel + 1);
						}
					} else {
						FieldItem fieldItem = new FieldItem(ctrl.getDefaultValue(), false, 0L, ctrl, null, loopDeepLevel);
						if (ctrlProcesser.isCheckCtrl()) {
							if (ctrl.getOptionMap().containsKey("checked")) {
								fieldItem.setChecked(true);
							} else {
								fieldItem.setChecked(false);
							}
						}
						fieldMap.setFieldItem(name, fieldItem);

						if (parts.getChild() != null) {
							getFieldMain(fieldMap, parts.getChild(), ctrlProcesserMap, loopDeepLevel);
						}
					}
				} else {
					if (parts.getChild() != null) {
						getFieldMain(fieldMap, parts.getChild(), ctrlProcesserMap, loopDeepLevel);
					}
				}
			}
		}
	}

}
