/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.util.check;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import jp.oarts.pirka.core.util.check.PirkaCheckerStringCharsIF;

public class PirkaCheckerStringChars
implements PirkaCheckerStringCharsIF,
Serializable {
    public static final PirkaCheckerStringChars NUM = new PirkaCheckerStringChars("0123456789");
    public static final PirkaCheckerStringChars LOW_ALPHABET = new PirkaCheckerStringChars("abcdefghijklmnopqrstuvwxyz");
    public static final PirkaCheckerStringChars HIGHT_ALPHABET = new PirkaCheckerStringChars("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
    public static final PirkaCheckerStringChars HALF = new PirkaCheckerStringChars(){

        public boolean check(char c) {
            String s = "" + c;
            try {
                return s.getBytes("MS932").length == 1;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("\u6587\u5b57\u30b3\u30fc\u30c9\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            }
        }
    };
    public static final PirkaCheckerStringChars WIDE = new PirkaCheckerStringChars(){

        public boolean check(char c) {
            String s = "" + c;
            try {
                return s.getBytes("MS932").length == 2;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("\u6587\u5b57\u30b3\u30fc\u30c9\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            }
        }
    };
    public static final PirkaCheckerStringChars HALF_KANA = new PirkaCheckerStringChars("\uff71\uff72\uff73\uff74\uff75\uff76\uff77\uff78\uff79\uff7a\uff7b\uff7c\uff7d\uff7e\uff7f\uff80\uff81\uff82\uff83\uff84\uff85\uff86\uff87\uff88\uff89\uff8a\uff8b\uff8c\uff8d\uff8e\uff8f\uff90\uff91\uff92\uff93\uff94\uff95\uff96\uff97\uff98\uff99\uff9a\uff9b\uff9c\uff66\uff9d\uff67\uff68\uff69\uff6a\uff6b\uff6f\uff6c\uff6d\uff6e\uff70\uff9e\uff9f\uff64\uff61\uff65\uff62\uff63");
    public static final PirkaCheckerStringChars WIDE_HIRAGANA = new PirkaCheckerStringChars("\u3042\u3044\u3046\u3048\u304a\u304b\u304d\u304f\u3051\u3053\u3055\u3057\u3059\u305b\u305d\u305f\u3061\u3064\u3066\u3068\u306a\u306b\u306c\u306d\u306e\u306f\u3072\u3075\u3078\u307b\u307e\u307f\u3080\u3081\u3082\u3084\u3086\u3088\u3089\u308a\u308b\u308c\u308d\u308f\u3092\u3093\u3041\u3043\u3045\u3047\u3049\u3063\u3083\u3085\u3087\u30fc\u309b\u309c\u304c\u304e\u3050\u3052\u3054\u3056\u3058\u305a\u305c\u305e\u3060\u3062\u3065\u3067\u3069\u3070\u3073\u3076\u3079\u307c\u3071\u3074\u3077\u307a\u307d");
    public static final PirkaCheckerStringChars WIDE_KATAKANA = new PirkaCheckerStringChars("\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f2\u30f3\u30a1\u30a3\u30a5\u30a7\u30a9\u30c3\u30e3\u30e5\u30e7\u30fc\u309b\u309c\u30ac\u30ae\u30b0\u30b2\u30b4\u30b6\u30b8\u30ba\u30bc\u30be\u30c0\u30c2\u30c5\u30c7\u30c9\u30d0\u30d3\u30d6\u30d9\u30dc\u30d1\u30d4\u30d4\u30da\u30dd");
    public static final PirkaCheckerStringChars SPACE = new PirkaCheckerStringChars(" ");
    public static final PirkaCheckerStringChars WIDE_SPAC = new PirkaCheckerStringChars("\u3000");
    public static final PirkaCheckerStringChars MAIL = new PirkaCheckerStringChars("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ@.!#$%&'*+-/=?^_`{|}~()<>[]:;@,\\\" ");
    public static final PirkaCheckerStringChars PATH_WIN = new PirkaCheckerStringChars(){

        public boolean check(char c) {
            return "/;*?\"<>?".indexOf(c) < 0;
        }
    };
    private String checkString;

    public PirkaCheckerStringChars() {
        this.checkString = null;
    }

    public PirkaCheckerStringChars(String checkString) {
        this.checkString = checkString;
    }

    public boolean check(char c) {
        return this.checkString.indexOf(c) >= 0;
    }
}

