package jp.oarts.pirka.core.util.converter;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.oarts.pirka.core.ctrl.proc.CtrlProcesser;
import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.util.field.FieldItem;
import jp.oarts.pirka.core.util.format.PirkaFormatUtil;
import jp.oarts.pirka.core.win.PirkaWindow;

/**
 * BeanRo[^[
 * 
 * @author ito
 * 
 */
public class BeanConverter implements Serializable {

	/**
	 * FieldMapIuWFNgɊi[Ăf[^BeanIuWFNg֊i[B<BR>
	 * FieldMapIuWFNgɊi[Ă郋[v͑ΏۊOƂB<BR>
	 * ̓Rg[ȊÕRg[̒lΏۂƂȂB
	 * tB[h̕ύX⑼̃NXIuWFNgɕύXBeanIuWFNgɐݒ肳Ƃ<BR>
	 * Ro[^[w肷邱Ƃɂ\ƂȂB
	 * 
	 * @param beanObject
	 *            BeanIuWFNg
	 * @param fieldMap
	 *            tB[h}bvIuWFNg
	 * @param converters
	 *            Ro[^[
	 */
	public static void getBean(Object beanObject, FieldMap fieldMap, Converter... converters) {
		getBean(beanObject, fieldMap, false, converters);
	}

	/**
	 * FieldMapIuWFNgɊi[Ăf[^BeanIuWFNg֊i[B<BR>
	 * FieldMapIuWFNgɊi[Ă郋[v͑ΏۊOƂB<BR>
	 * tB[h̕ύX⑼̃NXIuWFNgɕύXBeanIuWFNgɐݒ肳Ƃ<BR>
	 * Ro[^[w肷邱Ƃɂ\ƂȂB
	 * 
	 * @param beanObject
	 *            BeanIuWFNg
	 * @param fieldMap
	 *            tB[h}bvIuWFNg
	 * @param inputCtrlOnly
	 *            true=̓Rg[̂
	 * @param converters
	 *            Ro[^[
	 */
	public static void getBean(Object beanObject, FieldMap fieldMap, boolean inputCtrlOnly, Converter... converters) {

		Map<String, List<Method>> methodMap = createMethodMap(beanObject.getClass());
		Map<String, Converter> converterMap = createConverterMap(converters);

		getBeanMain(beanObject, methodMap, fieldMap, converterMap, inputCtrlOnly);
	}

	/**
	 * FieldMapIuWFNg̎w肳ꂽ[vtB[hɊi[Ăf[^ListIuWFNg쐬B<BR>
	 * ̓Rg[ȊÕRg[̒lΏۂƂȂB
	 * tB[h̕ύX⑼̃NXIuWFNgɕύXBeanIuWFNgɐݒ肳Ƃ<BR>
	 * Ro[^[w肷邱Ƃɂ\ƂȂB
	 * 
	 * @param beanClass
	 *            쐬BeañNX ̃NX̓p[^̃pubNȃRXgN^gp\Ȃ
	 * @param fieldMap
	 *            tB[h}bvIuWFNg
	 * @param loopFieldName
	 *            [ṽtB[h
	 * @param converters
	 *            Ro[^[
	 * @return Beani[ĂListIuWFNg
	 */
	public static List getBeanList(Class beanClass, FieldMap fieldMap, String loopFieldName, Converter... converters) {
		return getBeanList(beanClass, fieldMap, loopFieldName, false, converters);
	}

	/**
	 * FieldMapIuWFNg̎w肳ꂽ[vtB[hɊi[Ăf[^ListIuWFNg쐬B<BR>
	 * tB[h̕ύX⑼̃NXIuWFNgɕύXBeanIuWFNgɐݒ肳Ƃ<BR>
	 * Ro[^[w肷邱Ƃɂ\ƂȂB
	 * 
	 * @param beanClass
	 *            쐬BeañNX ̃NX̓p[^̃pubNȃRXgN^gp\Ȃ
	 * @param fieldMap
	 *            tB[h}bvIuWFNg
	 * @param loopFieldName
	 *            [ṽtB[h
	 * @param converters
	 *            Ro[^[
	 * @param inputCtrlOnly
	 *            true=̓Rg[̂
	 * @return Beani[ĂListIuWFNg
	 */
	public static List getBeanList(Class beanClass, FieldMap fieldMap, String loopFieldName, boolean inputCtrlOnly, Converter... converters) {

		Map<String, Converter> converterMap = createConverterMap(converters);
		Map<String, List<Method>> methodMap = createMethodMap(beanClass);
		List list = new ArrayList();

		for (int i = 0; i < fieldMap.getFieldMapSize(loopFieldName); i++) {
			Object bean = null;
			try {
				bean = beanClass.newInstance();
				list.add(bean);
				getBeanMain(bean, methodMap, fieldMap.getFieldMap(loopFieldName, i), converterMap, inputCtrlOnly);
			} catch (InstantiationException e) {
				// Ȃ
			} catch (IllegalAccessException e) {
				// Ȃ
			}
		}

		return list;
	}

	/**
	 * FieldMapIuWFNg̎w肳ꂽ[vtB[hɊi[Ăf[^listɊi[ĂBeanIuWFNgXV<BR>
	 * listBeanIuWFNglooptB[h̃[vقȂ鎞͏l̗vfXVsȂB<BR>
	 * listBeanIuWFNg͑SēNX̃IuWFNgŖΓۏ؂ȂB<BR>
	 * ̓Rg[ȊÕRg[̒lΏۂƂȂB
	 * tB[h̕ύX⑼̃NXIuWFNgɕύXBeanIuWFNgɐݒ肳Ƃ<BR>
	 * Ro[^[w肷邱Ƃɂ\ƂȂB
	 * 
	 * @param list
	 *            쐬BeañNX̃IuWFNgi[Ă郊Xg
	 * @param fieldMap
	 *            tB[h}bvIuWFNg
	 * @param loopFieldName
	 *            [ṽtB[h
	 * @param converters
	 *            Ro[^[
	 * @return Beani[ĂListIuWFNg
	 */
	public static void getBeanList(List list, FieldMap fieldMap, String loopFieldName, Converter... converters) {
		getBeanList(list, fieldMap, loopFieldName, false, converters);
	}

	/**
	 * FieldMapIuWFNg̎w肳ꂽ[vtB[hɊi[Ăf[^listɊi[ĂBeanIuWFNgXV<BR>
	 * listBeanIuWFNglooptB[h̃[vقȂ鎞͏l̗vfXVsȂB<BR>
	 * listBeanIuWFNg͑SēNX̃IuWFNgŖΓۏ؂ȂB<BR>
	 * tB[h̕ύX⑼̃NXIuWFNgɕύXBeanIuWFNgɐݒ肳Ƃ<BR>
	 * Ro[^[w肷邱Ƃɂ\ƂȂB
	 * 
	 * @param list
	 *            쐬BeañNX̃IuWFNgi[Ă郊Xg
	 * @param fieldMap
	 *            tB[h}bvIuWFNg
	 * @param loopFieldName
	 *            [ṽtB[h
	 * @param converters
	 *            Ro[^[
	 * @param inputCtrlOnly
	 *            true=̓Rg[̂
	 * @return Beani[ĂListIuWFNg
	 */
	public static void getBeanList(List list, FieldMap fieldMap, String loopFieldName, boolean inputCtrlOnly, Converter... converters) {

		if (list == null || list.size() <= 0) {
			return;
		}

		int loopCount = list.size();
		int loopMapSize = fieldMap.getFieldMapSize(loopFieldName);
		if (loopMapSize < loopCount) {
			loopCount = loopMapSize;
		}

		Map<String, Converter> converterMap = createConverterMap(converters);
		Map<String, List<Method>> methodMap = createMethodMap(list.get(0).getClass());

		for (int i = 0; i < loopCount; i++) {
			Object bean = list.get(i);
			getBeanMain(bean, methodMap, fieldMap.getFieldMap(loopFieldName, i), converterMap, inputCtrlOnly);
		}

	}

	/**
	 * 
	 * @param bean
	 * @param methodMap
	 * @param fieldMap
	 * @param converterMap
	 * @param inputCtrlOnly
	 *            true=̓Rg[̂
	 */
	private static void getBeanMain(Object bean, Map<String, List<Method>> methodMap, FieldMap fieldMap, Map<String, Converter> converterMap, boolean inputCtrlOnly) {

		Map<String, String> groupMap = createGroupMap(fieldMap);

		String[] fieldNames = fieldMap.getFieldNames();
		for (String fieldName : fieldNames) {
			getBeanMain(bean, methodMap, fieldMap, fieldName, false, converterMap, inputCtrlOnly);
		}

		for (String fieldName : groupMap.keySet()) {
			getBeanMain(bean, methodMap, fieldMap, fieldName, true, converterMap, inputCtrlOnly);
		}
	}

	/**
	 * 
	 * @param bean
	 * @param methodMap
	 * @param fieldMap
	 * @param fieldName
	 * @param groupe
	 * @param converterMap
	 * @param inputCtrlOnly
	 */
	private static void getBeanMain(Object bean, Map<String, List<Method>> methodMap, FieldMap fieldMap, String fieldName,//
			boolean groupe, Map<String, Converter> converterMap, boolean inputCtrlOnly) {

		Object value = null;
		if (!groupe) {
			FieldItem fieldItem = fieldMap.getFieldItem(fieldName);
			CtrlProcesser cp = fieldItem.getCtrl().getCtrlProcesser();
			if (cp.isLoop() || cp.isGroupItem() || (inputCtrlOnly && !cp.isInputCtrl())) {
				return;
			}
			value = fieldItem.getValue();
		} else {
			value = fieldMap.getGroupValue(fieldName);
		}

		Converter converter = converterMap.get(fieldName);
		String membertName = fieldName;

		if (converter != null) {
			membertName = converter.getTargetFieldName();
			if (converter.getDataConverter() != null) {
				value = converter.getDataConverter().win2Target(value);
			}
		}

		List<Method> list = methodMap.get(createSetterName(membertName));
		if (list == null) {
			return;
		}

		boolean ok = false;
		for (Method method : list) {
			try {
				Class[] params = method.getParameterTypes();
				if (params.length == 1) {
					if (value == null) {
						if (!params[0].isPrimitive()) {
							method.invoke(bean, value);
							ok = true;
						}
					} else if (params[0].isInstance(value)) { // \Ȃ
						method.invoke(bean, value);
						ok = true;
					} else if (params[0] == boolean.class && Boolean.class.isInstance(value)) {
						method.invoke(bean, value);
						ok = true;
					} else if (params[0] == Date.class && String.class.isInstance(value)) {
						method.invoke(bean, PirkaFormatUtil.parseDate((String) value));
						ok = true;
					} else if (params[0] == java.util.Date.class && String.class.isInstance(value)) {
						method.invoke(bean, PirkaFormatUtil.parseDate((String) value));
						ok = true;
					} else if (params[0] == Time.class && String.class.isInstance(value)) {
						method.invoke(bean, PirkaFormatUtil.parseTime((String) value));
						ok = true;
					} else if (params[0] == Timestamp.class && String.class.isInstance(value)) {
						method.invoke(bean, PirkaFormatUtil.parseTimestamp((String) value));
						ok = true;
					} else if (params[0] == Integer.class && String.class.isInstance(value)) {
						method.invoke(bean, PirkaFormatUtil.parseInteger((String) value));
						ok = true;
					} else if (params[0] == int.class && String.class.isInstance(value)) {
						Integer intValue = PirkaFormatUtil.parseInteger((String) value);
						if (intValue == null) {
							method.invoke(bean, 0);
						} else {
							method.invoke(bean, intValue);
						}
						ok = true;
					} else if (params[0] == Long.class && String.class.isInstance(value)) {
						method.invoke(bean, PirkaFormatUtil.parseLong((String) value));
						ok = true;
					} else if (params[0] == long.class && String.class.isInstance(value)) {
						Long longValue = PirkaFormatUtil.parseLong((String) value);
						if (longValue == null) {
							method.invoke(bean, 0L);
						} else {
							method.invoke(bean, longValue);
						}
						ok = true;
					} else if (params[0] == BigDecimal.class && String.class.isInstance(value)) {
						method.invoke(bean, PirkaFormatUtil.parseBigDecimal((String) value));
						ok = true;
					}
				}
			} catch (IllegalArgumentException e) {
			} catch (IllegalAccessException e) {
			} catch (InvocationTargetException e) {
			}
			if (ok) {
				break;
			}
		}

	}

	/**
	 * BeanIuWFNg̓eFieldMapIuWFNg֊i[B<BR>
	 * [v͑ΏۊOƂ<BR>
	 * Beanɍڂ݂ȂꍇtB[h}bv̒l̒u͍sȂȂB<BR>
	 * ̓Rg[ȊÕRg[̒lΏۂƂȂB
	 * Select^Oł̕ITABŋ؂ꂽStringƂB<BR>
	 * tB[h̕ύX⑼̃NXIuWFNgɕύXMapIuWFNg쐬Ƃ<BR>
	 * Ro[^[ݒ肷邱Ƃɂ\ƂȂB
	 * 
	 * @param window
	 *            EBhE
	 * @param beanObject
	 *            BeanIuWFNg
	 * @param fieldMap
	 *            tB[h}bvIuWFNg
	 * @param converters
	 *            Ro[^[
	 */
	public static void setBean(PirkaWindow window, Object beanObject, FieldMap fieldMap, Converter... converters) {

		Map<String, Converter> converterMap = createConverterMap(converters);
		Map<String, List<Method>> methodMap = createMethodMap(beanObject.getClass());

		setBeanMain(beanObject, methodMap, fieldMap, converterMap, false);
	}

	/**
	 * BeanIuWFNg̓eFieldMapIuWFNg֊i[B<BR>
	 * [v͑ΏۊOƂ<BR>
	 * Beanɍڂ݂ȂꍇtB[h}bv̒l̒u͍sȂȂB<BR>
	 * Select^Oł̕ITABŋ؂ꂽStringƂB<BR>
	 * tB[h̕ύX⑼̃NXIuWFNgɕύXMapIuWFNg쐬Ƃ<BR>
	 * Ro[^[ݒ肷邱Ƃɂ\ƂȂB
	 * 
	 * @param window
	 *            EBhE
	 * @param beanObject
	 *            BeanIuWFNg
	 * @param fieldMap
	 *            tB[h}bvIuWFNg
	 * @param inputCtrlOnly
	 *            true=̓Rg[̂
	 * @param converters
	 *            Ro[^[
	 */
	public static void setBean(PirkaWindow window, Object beanObject, FieldMap fieldMap, boolean inputCtrlOnly, Converter... converters) {

		Map<String, Converter> converterMap = createConverterMap(converters);
		Map<String, List<Method>> methodMap = createMethodMap(beanObject.getClass());

		setBeanMain(beanObject, methodMap, fieldMap, converterMap, inputCtrlOnly);

	}

	/**
	 * ListɊi[ĂBeanIuWFNg̓ew肳ꂽ[vtB[hFieldMapIuWFNg֊i[B<BR>
	 * Beanɍڂ݂ȂꍇtB[h}bv̒l̒u͍sȂȂB<BR>
	 * listBeanIuWFNg͑SēNX̃IuWFNgŖΓۏ؂ȂB<BR>
	 * ̓Rg[ȊÕRg[̒lΏۂƂȂB
	 * Select^Oł̕ITABŋ؂ꂽStringƂB<BR>
	 * tB[h̕ύX⑼̃NXIuWFNgɕύXMapIuWFNg쐬Ƃ<BR>
	 * Ro[^[ݒ肷邱Ƃɂ\ƂȂB
	 * 
	 * @param window
	 *            EBhE
	 * @param list
	 *            BeanIuWFNgi[Ă郊Xg
	 * @param fieldMap
	 *            tB[h}bvIuWFNg
	 * @param loopFieldName
	 *            [ṽtB[h
	 * @param inputCtrlOnly
	 *            true=̓Rg[̂
	 * @param converters
	 *            Ro[^[
	 */
	public static void setBeanList(PirkaWindow window, List list, FieldMap fieldMap, String loopFieldName, Converter... converters) {
		setBeanList(window, list, fieldMap, loopFieldName, false, converters);
	}

	/**
	 * ListɊi[ĂBeanIuWFNg̓ew肳ꂽ[vtB[hFieldMapIuWFNg֊i[B<BR>
	 * Beanɍڂ݂ȂꍇtB[h}bv̒l̒u͍sȂȂB<BR>
	 * listBeanIuWFNg͑SēNX̃IuWFNgŖΓۏ؂ȂB<BR>
	 * Select^Oł̕ITABŋ؂ꂽStringƂB<BR>
	 * tB[h̕ύX⑼̃NXIuWFNgɕύXMapIuWFNg쐬Ƃ<BR>
	 * Ro[^[ݒ肷邱Ƃɂ\ƂȂB
	 * 
	 * @param window
	 *            EBhE
	 * @param list
	 *            BeanIuWFNgi[Ă郊Xg
	 * @param fieldMap
	 *            tB[h}bvIuWFNg
	 * @param loopFieldName
	 *            [ṽtB[h
	 * @param inputCtrlOnly
	 *            true=̓Rg[̂
	 * @param converters
	 *            Ro[^[
	 */
	public static void setBeanList(PirkaWindow window, List list, FieldMap fieldMap, String loopFieldName, boolean inputCtrlOnly, Converter... converters) {

		fieldMap.clearFieldMap(loopFieldName);
		if (list.size() <= 0) {
			return;
		}

		Map<String, Converter> converterMap = createConverterMap(converters);
		Map<String, List<Method>> methodMap = createMethodMap(list.get(0).getClass());

		for (Object bean : list) {
			FieldMap loopFieldMap = window.createLoopFieldMap(loopFieldName);
			setBeanMain(bean, methodMap, loopFieldMap, converterMap, inputCtrlOnly);
			fieldMap.addFieldMap(loopFieldName, loopFieldMap);
		}

	}

	/**
	 * 
	 * @param bean
	 * @param methodMap
	 * @param fieldMap
	 * @param converterMap
	 * @param inputCtrlOnly
	 */
	private static void setBeanMain(Object beanObject, Map<String, List<Method>> methodMap, FieldMap fieldMap, Map<String, Converter> converterMap, boolean inputCtrlOnly) {

		Map<String, String> groupMap = createGroupMap(fieldMap);

		String[] fieldNames = fieldMap.getFieldNames();
		for (String fieldName : fieldNames) {
			setBeanMain(beanObject, methodMap, fieldMap, fieldName, false, converterMap, inputCtrlOnly);
		}

		for (String fieldName : groupMap.keySet()) {
			setBeanMain(beanObject, methodMap, fieldMap, fieldName, true, converterMap, inputCtrlOnly);
		}
	}

	/**
	 * 
	 * @param bean
	 * @param methodMap
	 * @param fieldMap
	 * @param fieldName
	 * @param groupe
	 * @param converterMap
	 * @param inputCtrlOnly
	 */
	private static void setBeanMain(Object bean, Map<String, List<Method>> methodMap, FieldMap fieldMap, String fieldName,//
			boolean groupe, Map<String, Converter> converterMap, boolean inputCtrlOnly) {

		CtrlProcesser cp = null;
		if (!groupe) {
			FieldItem fieldItem = fieldMap.getFieldItem(fieldName);
			cp = fieldItem.getCtrl().getCtrlProcesser();
			if (cp.isLoop() || cp.isGroupItem() || (inputCtrlOnly && !cp.isInputCtrl())) {
				return;
			}
		}

		Converter converter = converterMap.get(fieldName);
		String membertName = fieldName;
		if (converter != null) {
			membertName = converter.getTargetFieldName();
		}

		List<Method> list = new ArrayList<Method>();
		List<Method> listSet = methodMap.get(createGetterName(membertName));
		if (listSet != null) {
			list.addAll(listSet);
		}
		List<Method> listIs = methodMap.get(createIsName(membertName));
		if (listIs != null) {
			list.addAll(listIs);
		}

		Object value = null;
		boolean ok = false;
		for (Method method : list) {
			try {
				Class[] params = method.getParameterTypes();
				if (params.length == 0) {
					value = method.invoke(bean);
					ok = true;
					break;
				}
			} catch (IllegalArgumentException e) {
			} catch (IllegalAccessException e) {
			} catch (InvocationTargetException e) {
			}
		}
		if (!ok) {
			return;
		}

		if (converter != null && converter.getDataConverter() != null) {
			value = converter.getDataConverter().target2Win(value);
		}

		if (groupe) {
			if (value == null) {
				fieldMap.setGroupValue(fieldName, "");
			} else {
				if (String.class.isInstance(value)) {
					fieldMap.setGroupValue(fieldName, (String) value);
				} else if (Date.class.isInstance(value)) {
					fieldMap.setGroupValue(fieldName, (Date) value);
				} else if (java.util.Date.class.isInstance(value)) {
					fieldMap.setGroupValue(fieldName, new Date(((java.util.Date) value).getTime()));
				} else if (Time.class.isInstance(value)) {
					fieldMap.setGroupValue(fieldName, (Time) value);
				} else if (Timestamp.class.isInstance(value)) {
					fieldMap.setGroupValue(fieldName, (Timestamp) value);
				} else if (Integer.class.isInstance(value)) {
					fieldMap.setGroupValue(fieldName, (Integer) value);
				} else if (Long.class.isInstance(value)) {
					fieldMap.setGroupValue(fieldName, (Long) value);
				} else if (BigDecimal.class.isInstance(value)) {
					fieldMap.setGroupValue(fieldName, (BigDecimal) value);
				}
			}
		} else if (cp.isCheckCtrl()) {
			if (value == null) {
				fieldMap.setValue(fieldName, false);
			} else {
				if (Boolean.class.isInstance(value)) {
					fieldMap.setValue(fieldName, (Boolean) value);
				} else {
					fieldMap.setValue(fieldName, false);
				}
			}
		} else {
			if (value == null) {
				fieldMap.setValue(fieldName, "");
			} else {
				if (String.class.isInstance(value)) {
					fieldMap.setValue(fieldName, (String) value);
				} else if (Date.class.isInstance(value)) {
					fieldMap.setValue(fieldName, (Date) value);
				} else if (java.util.Date.class.isInstance(value)) {
					fieldMap.setValue(fieldName, new Date(((java.util.Date) value).getTime()));
				} else if (Time.class.isInstance(value)) {
					fieldMap.setValue(fieldName, (Time) value);
				} else if (Timestamp.class.isInstance(value)) {
					fieldMap.setValue(fieldName, (Timestamp) value);
				} else if (Integer.class.isInstance(value)) {
					fieldMap.setValue(fieldName, (Integer) value);
				} else if (Long.class.isInstance(value)) {
					fieldMap.setValue(fieldName, (Long) value);
				} else if (BigDecimal.class.isInstance(value)) {
					fieldMap.setValue(fieldName, (BigDecimal) value);
				}
			}
		}

	}

	private static Map<String, List<Method>> createMethodMap(Class beanClass) {

		Map<String, List<Method>> map = new HashMap<String, List<Method>>();
		Method[] methods = beanClass.getMethods();
		for (Method method : methods) {
			List<Method> list = null;
			if (!map.containsKey(method.getName())) {
				list = new ArrayList<Method>();
				map.put(method.getName(), list);
			} else {
				list = map.get(method.getName());
			}
			list.add(method);
		}
		return map;
	}

	private static String createGetterName(String name) {
		if (name == null || name.length() <= 0) {
			return "get";
		}
		StringBuilder sb = new StringBuilder();
		sb.append("get");
		sb.append(name.substring(0, 1).toUpperCase());
		if (name.length() > 1) {
			sb.append(name.substring(1));
		}
		return sb.toString();
	}

	private static String createIsName(String name) {
		if (name == null || name.length() <= 0) {
			return "is";
		}
		StringBuilder sb = new StringBuilder();
		sb.append("is");
		sb.append(name.substring(0, 1).toUpperCase());
		if (name.length() > 1) {
			sb.append(name.substring(1));
		}
		return sb.toString();
	}

	private static String createSetterName(String name) {
		if (name == null || name.length() <= 0) {
			return "set";
		}
		StringBuilder sb = new StringBuilder();
		sb.append("set");
		sb.append(name.substring(0, 1).toUpperCase());
		if (name.length() > 1) {
			sb.append(name.substring(1));
		}
		return sb.toString();
	}

	/**
	 * Ro[^[̃}bv쐬
	 * 
	 * @param converters
	 *            Ro[^
	 * @return Ro[^}bv
	 */
	private static Map<String, Converter> createConverterMap(Converter... converters) {
		Map<String, Converter> map = new HashMap<String, Converter>();

		for (Converter converter : converters) {
			map.put(converter.getWindowFieldName(), converter);
		}

		return map;

	}

	/**
	 * tB[h}bvO[v}bv쐬
	 * 
	 * @param fieldMap
	 *            tB[h}bv
	 * @return O[v}bv
	 */
	private static Map<String, String> createGroupMap(FieldMap fieldMap) {
		Map<String, String> groupMap = new HashMap<String, String>();
		createGroupMapMain(groupMap, fieldMap, 0);

		return groupMap;

	}

	/**
	 * O[v}bvC
	 * 
	 * @param groupMap
	 *            O[v}bv
	 * @param fieldMap
	 *            tB[h}bv
	 * @param groupLevel
	 *            O[vx
	 */
	private static void createGroupMapMain(Map<String, String> groupMap, FieldMap fieldMap, int groupLevel) {

		String[] fieldNames = fieldMap.getFieldNames();
		for (String fieldName : fieldNames) {
			FieldItem fieldItem = fieldMap.getFieldItem(fieldName);
			CtrlProcesser cp = fieldItem.getCtrl().getCtrlProcesser();
			if (cp.isGroupItem() && fieldItem.getCtrl().getGroupLevel() == groupLevel) {
				groupMap.put(fieldItem.getCtrl().getBaseName(), fieldItem.getCtrl().getBaseName());
			}

			if (cp.isLoop()) {
				List<FieldMap> list = (List<FieldMap>) fieldItem.getValue();
				for (FieldMap childFieldMap : list) {
					createGroupMapMain(groupMap, childFieldMap, groupLevel + 1);
				}

			}
		}

	}
}
