package jp.oarts.pirka.core.app;

import java.io.UnsupportedEncodingException;

import jp.oarts.pirka.core.util.converter.ReqCharacterConverter;

/**
 * pirkaW̃NGXgLN^̕ϊC^[tF[X
 * 
 * @author ito
 * 
 */
public class DefaultReqCharacterConverter implements ReqCharacterConverter {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/** IuWFNg */
	private static final DefaultReqCharacterConverter object = new DefaultReqCharacterConverter();

	/**
	 * CX^X̎擾
	 * 
	 * @return CX^X
	 */
	public static ReqCharacterConverter getInstance() {
		return object;
	}

	/**
	 * VOp[gp̕ϊ<BR>
	 * HttpServletRequest#getParameterValues(String)œǂݍ܂ꂽ񂩂當쐬<BR>
	 * ̎łHttpServletRequest#getParameterValues(String)擾镶8859_1<BR>
	 * GR[hĂƉ肷邽߁A8859_1ŃfR[hēꂽoCggł<BR>
	 * JISAutoDetectŕϊA߂lƂB
	 * 
	 * @param value
	 *            
	 * @return ϊꂽ
	 */
	public String convertKanji(String value) {
		try {
			return MSKanjiConv(value.getBytes("8859_1"));
		} catch (UnsupportedEncodingException e) {
			return value;
		}
	}

	/**
	 * }`p[gp̕ϊ<BR>
	 * HttpServletRequest#getInputStream()œǂݍ܂ꂽoCg񂩂當쐬<BR>
	 * HttpServletRequest#getInputStream()œǂݍ܂ꂽoCggłJISAutoDetect<BR>
	 * ϊA߂lƂB
	 * 
	 * @param value
	 *            oCg
	 * @return ϊꂽ
	 */
	public String convertKanji(byte[] value) {
		try {
			return MSKanjiConv(value);
		} catch (UnsupportedEncodingException e) {
			try {
				return new String(value, "8859_1");
			} catch (UnsupportedEncodingException e2) {
				return new String(value);
			}
		}
	}

	/**
	 * gJISAutoDetect<BR>
	 * {܂ޕStringIuWFNgɕϊ AShift-jiŝƂMS932D悷
	 * 
	 * @param bytes
	 *            oCgz
	 * @return ϊꂽ
	 * @throws Exception
	 */
	public String MSKanjiConv(byte[] bytes) throws UnsupportedEncodingException {

		boolean jisFlg = false; // jisR[htO

		// JISR[h
		for (int i = 0; i < bytes.length; i++) {
			if ((i + 2) < bytes.length && bytes[i] == 0x1b && bytes[i + 1] == 0x24) {
				jisFlg = true;
				break;
			}
		}

		// JISR[h̎ɂJISoCgSHIFT-JISoCgɕϊMS932ŕϊ
		if (jisFlg) {
			return new String(jis2SJis(bytes), "MS932");
		}

		// EUC-JPŕϊ쐬
		String euc = "";
		try {
			euc = new String(bytes, "EUC_JP");
		} catch (UnsupportedEncodingException e) {
		}

		// JISAUTODETECTŕϊ쐬
		String JISAutoDetect = "";
		try {
			JISAutoDetect = new String(bytes, "JISAutoDetect");
		} catch (UnsupportedEncodingException e) {
		}

		// MS932ŕϊ쐬
		String ms932 = "";
		try {
			ms932 = new String(jis2SJis(bytes), "MS932");
		} catch (UnsupportedEncodingException e) {
		}

		// EUCŕϊ̂JISAUTODETECTŕϊ̂ႤȂMS932Ƃ
		if (!euc.equals(JISAutoDetect)) {
			return ms932;
		}

		// ϊłȂeucMS932̂قȂMS932Ƃ
		if (charCount(ms932, '?') <= charCount(euc, '?')) {
			return ms932;
		}

		// eucƂ
		return euc;
	}

	/**
	 * Ɋ܂܂p[^Ŏw肳ꂽ̕߂
	 * 
	 * @param str
	 *            
	 * @param chr
	 *            
	 * @return 
	 */
	private int charCount(String str, char chr) {
		int count = 0;
		if (str != null) {
			int length = str.length();
			for (int i = 0; i < length; i++) {
				if (str.charAt(i) == chr) {
					count++;
				}
			}
		}
		return count;
	}

	/**
	 * JISoCgS-JISoCgɕϊ
	 * 
	 * @param buff
	 *            JISoCg
	 * @return S-JISoCg
	 */
	private byte[] jis2SJis(byte[] buff) {
		int op = 0;
		int mode = 1;
		int c1, c2;

		for (int i = 0; i < buff.length; i++) {
			if (buff[i] == 0x1b) {
				if ((i + 2) < buff.length) {
					if (buff[i + 1] == 0x28) { // ASCII ܂ JIS X 0201-1976 Roman Set̂͂Ȃ̂1ByteƂ܂B
						mode = 1;
					} else if (buff[i + 1] == 0x24) { // JIS X 0208-1978(ʏ́FJIS) ܂ JIS X 0208-1983(ʏ́FVJIS)̂͂Ȃ̂2ByteƂ܂B
						mode = 2;
					}
				}
				i = i + 2;
			} else {
				if (mode == 1) {
					buff[op++] = buff[i];
				} else {
					if ((i + 1) < buff.length) {
						if (buff[i] >= 0) {
							c1 = buff[i];
						} else {
							c1 = 256 + buff[i];

						}
						if (buff[i + 1] >= 0) {
							c2 = buff[i + 1];
						} else {
							c2 = 256 + buff[i + 1];
						}

						if ((c1 % 2) != 0) {
							c1 = ((c1 + 1) / 2) + 0x70;
							c2 = c2 + 0x1f;
						} else {
							c1 = (c1 / 2) + 0x70;
							c2 = c2 + 0x7d;
						}
						if (c1 >= 0xa0) {
							c1 = c1 + 0x40;
						}
						if (c2 >= 0x7f) {
							c2 = c2 + 1;
						}
						if (c1 > 127) {
							buff[op++] = (byte) (c1 - 256);
						} else {
							buff[op++] = (byte) c1;
						}
						if (c2 > 127) {
							buff[op++] = (byte) (c2 - 256);
						} else {
							buff[op++] = (byte) c2;
						}
					}
					i = i + 1;
				}
			}
		}
		byte[] rtn = new byte[op];
		System.arraycopy(buff, 0, rtn, 0, op);
		return rtn;
	}
}
