package jp.oarts.pirka.core.util.field;

import java.io.Serializable;

import jp.oarts.pirka.core.general.HtmlCtrlParts;
import jp.oarts.pirka.core.util.format.FieldFormat;

public class FieldItem  implements Serializable{

	// /** PƃtO */
	// private boolean soleFlag;

	/** l */
	private Object value;

	/** `FbNliWI{^j */
	private boolean checked;

	/** Abv[ht@Cԍ */
	private long fileNo;

	/** Rg[[ */
	private HtmlCtrlParts ctrl;

	/** tH[}bg */
	private FieldFormat format;

	/** [vKwi[g=0j */
	private int loopDeepLevel;

	/** G[tO */
	private boolean errorFlag;

	/**
	 * RXgN^
	 * 
	 * @param value
	 *            l
	 * @param checked
	 *            WI{^̃`FbNl
	 * @param fileNo
	 *            Abv[h̃t@Cԍ
	 * @param ctrl
	 *            Rg[[
	 * @param format
	 *            tH[}bg
	 * @param loopDeepLevel
	 *            [vKwi[g=0j
	 */
	public FieldItem(Object value, boolean checked, long fileNo, HtmlCtrlParts ctrl, FieldFormat format, int loopDeepLevel) {
		this(value, checked, fileNo, ctrl, format, loopDeepLevel, false);
	}

	/**
	 * RXgN^
	 * 
	 * @param value
	 *            l
	 * @param checked
	 *            WI{^̃`FbNl
	 * @param fileNo
	 *            Abv[h̃t@Cԍ
	 * @param ctrl
	 *            Rg[[
	 * @param format
	 *            tH[}bg
	 * @param loopDeepLevel
	 *            [vKwi[g=0j
	 * @param errorFlag
	 *            G[tO
	 */
	public FieldItem(Object value, boolean checked, long fileNo, HtmlCtrlParts ctrl, FieldFormat format, int loopDeepLevel, boolean errorFlag) {
		this.value = value;
		this.checked = checked;
		this.fileNo = fileNo;
		this.ctrl = ctrl;
		this.format = format;
		this.loopDeepLevel = loopDeepLevel;
		this.errorFlag = errorFlag;
	}

	/**
	 * N[
	 */
	public Object clone() {
		return (Object) new FieldItem(value, checked, fileNo, (HtmlCtrlParts) ctrl.clone(), format, loopDeepLevel, errorFlag);

	}

	/**
	 * @return ctrl ߂܂B
	 */
	public HtmlCtrlParts getCtrl() {
		return ctrl;
	}

	/**
	 * @param ctrl
	 *            ݒ肷 ctrlB
	 */
	public void setCtrl(HtmlCtrlParts ctrl) {
		this.ctrl = ctrl;
	}

	/**
	 * @return format ߂܂B
	 */
	public FieldFormat getFormat() {
		return format;
	}

	/**
	 * @param format
	 *            ݒ肷 formatB
	 */
	public void setFormat(FieldFormat format) {
		this.format = format;
	}

	/**
	 * @return value ߂܂B
	 */
	public Object getValue() {
		return value;
	}

	/**
	 * @param value
	 *            ݒ肷 valueB
	 */
	public void setValue(Object value) {
		this.value = value;
	}

	/**
	 * @return loopDeepLevel ߂܂B
	 */
	public int getLoopDeepLevel() {
		return loopDeepLevel;
	}

	/**
	 * @param loopDeepLevel
	 *            ݒ肷 loopDeepLevelB
	 */
	public void setLoopDeepLevel(int loopDeepLevel) {
		this.loopDeepLevel = loopDeepLevel;
	}

	/**
	 * @return checked ߂܂B
	 */
	public boolean isChecked() {
		return checked;
	}

	/**
	 * @param checked
	 *            ݒ肷 checkedB
	 */
	public void setChecked(boolean checked) {
		this.checked = checked;
	}

	/**
	 * @return errorFlag ߂܂B
	 */
	public boolean isErrorFlag() {
		return errorFlag;
	}

	/**
	 * @param errorFlag
	 *            ݒ肷 errorFlagB
	 */
	public void setErrorFlag(boolean errorFlag) {
		this.errorFlag = errorFlag;
	}

	/**
	 * @return fileNo ߂܂B
	 */
	public long getFileNo() {
		return fileNo;
	}

	/**
	 * @param fileNo
	 *            ݒ肷 fileNoB
	 */
	public void setFileNo(long fileNo) {
		this.fileNo = fileNo;
	}

}
