package jp.oarts.pirka.core.util.check;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;

/**
 * `FbJ[p̃LN^<BR>
 * ̃NXɒ`ĂLN^𕶎`FbJ[̃RXgN^ɐݒ肷B
 * 
 * @author ito
 * 
 */
public class PirkaCheckerStringChars implements PirkaCheckerStringCharsIF, Serializable {

	/** p(0`9) */
	public static final PirkaCheckerStringChars NUM = new PirkaCheckerStringChars("0123456789");

	/** pia`zj */
	public static final PirkaCheckerStringChars LOW_ALPHABET = new PirkaCheckerStringChars("abcdefghijklmnopqrstuvwxyz");

	/** p啶iA`Zj */
	public static final PirkaCheckerStringChars HIGHT_ALPHABET = new PirkaCheckerStringChars("ABCDEFGHIJKLMNOPQRSTUVWXYZ");

	/** SĂ̔p */
	public static final PirkaCheckerStringChars HALF = new PirkaCheckerStringChars() {
		public boolean check(char c) {
			String s = "" + c;
			try {
				return s.getBytes("MS932").length == 1;
			} catch (UnsupportedEncodingException e) {
				throw new RuntimeException("R[hϊɎs܂");
			}
		}
	};

	/** SĂ̑Sp */
	public static final PirkaCheckerStringChars WIDE = new PirkaCheckerStringChars() {
		public boolean check(char c) {
			String s = "" + c;
			try {
				return s.getBytes("MS932").length == 2;
			} catch (UnsupportedEncodingException e) {
				throw new RuntimeException("R[hϊɎs܂");
			}
		}
	};

	/** p */
	public static final PirkaCheckerStringChars HALF_KANA = new PirkaCheckerStringChars("ܦݧߤ");

	/** SpЂ炪 */
	public static final PirkaCheckerStringChars WIDE_HIRAGANA = new PirkaCheckerStringChars("ĂƂȂɂʂ˂̂͂Ђӂւق܂݂ނ߂񂟂[JKÂłǂ΂тԂׂڂς҂Ղ؂");

	/** SpJ^Ji */
	public static final PirkaCheckerStringChars WIDE_KATAKANA = new PirkaCheckerStringChars("ACEGIJLNPRTVXZ\^`cegijklmnqtwz}~@BDFHb[JKKMOQSUWY[]_adfhorux{pssy|");

	/** pXy[X */
	public static final PirkaCheckerStringChars SPACE = new PirkaCheckerStringChars(" ");

	/** SpXy[X */
	public static final PirkaCheckerStringChars WIDE_SPAC = new PirkaCheckerStringChars("@");

	/** [AhX */
	public static final PirkaCheckerStringChars MAIL = new PirkaCheckerStringChars("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ@.!#$%&'*+-/=?^_`{|}~()<>[]:;@,\\\" ");

	/** pXiMS-Windowsj */
	public static final PirkaCheckerStringChars PATH_WIN = new PirkaCheckerStringChars() {
		public boolean check(char c) {
			return "/;*?\"<>?".indexOf(c) < 0;
		}
	};

	/** `FbNOKƂLN^̕ */
	private String checkString;

	/**
	 * RXgN^
	 */
	public PirkaCheckerStringChars() {
		this.checkString = null;
	}

	/**
	 * RXgN^
	 * 
	 * @param checkString
	 *            `FbNOKƂLN^̕
	 */
	public PirkaCheckerStringChars(String checkString) {
		this.checkString = checkString;
	}

	/**
	 * `FbNsȂ
	 * 
	 * @param c
	 *            `FbNsȂ
	 * @return true=OK
	 */
	public boolean check(char c) {
		return checkString.indexOf(c) >= 0;
	}

}
