package jp.oarts.pirka.core.app;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.oarts.pirka.core.ctrl.proc.CtrlProcesser;
import jp.oarts.pirka.core.general.HtmlCtrlParts;
import jp.oarts.pirka.core.general.WindowBaseData;
import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.kernel.PirkaInfoPool;
import jp.oarts.pirka.core.kernel.TempFileManager;
import jp.oarts.pirka.core.res.PirkaFileDownloader;
import jp.oarts.pirka.core.res.PirkaRespons;
import jp.oarts.pirka.core.util.check.AutoCheckRuntimeException;
import jp.oarts.pirka.core.util.converter.ReqCharacterConverter;
import jp.oarts.pirka.core.util.converter.StringConverter;
import jp.oarts.pirka.core.util.field.FieldItem;
import jp.oarts.pirka.core.win.PirkaWindow;

/**
 * ItCiWEBT[o[gpJUnitjpirkảʂeXgyѕ\ƂɎgp Gg[|CgłB
 * 
 * @author ito
 * 
 */
public class OfflineEntryPoint implements EntryPointIF, Serializable {

	/** ftHg̃fobOpuEUNR}h */
	private static final String DEBUG_BROWSER_COMMAND = "C:\\Program Files\\Internet Explorer\\iexplore.exe";

	/** VOgECX^X */
	private static OfflineEntryPoint instance = null;

	/** I[hT[ubg[h */
	private boolean oldServletMode;

	/** Rg[[vZbT[}bv */
	private Map<String, CtrlProcesser> ctrlProcesserMap;

	/** bZ[WEnum */
	private Class pirkaMessageEnumClass;

	/** fobO\puEUNR}h */
	private String debugBrowserCommand;

	/** fobOpe|HTMLt@C */
	private File tempHtmlFile;

	/** ZbV}bv */
	private Map<String, Object> sessionMap;

	/** \[XHTMLt@C̃LN^Zbg */
	private String resourceHtmlFileCharset;

	/** uEUpHTMLt@C̃LN^Zbg */
	private String outHtmlFileCharset;

	/**
	 * new֎~̃RXgN^
	 */
	private OfflineEntryPoint() {
		oldServletMode = false;
		ctrlProcesserMap = null;
		pirkaMessageEnumClass = null;
		debugBrowserCommand = DEBUG_BROWSER_COMMAND;
		String tempDirName = System.getProperty("java.io.tmpdir");
		tempHtmlFile = new File(tempDirName, "$$pirka.html");
		sessionMap = new HashMap<String, Object>();
		resourceHtmlFileCharset = "MS932";
		outHtmlFileCharset = "MS932";
	}

	/**
	 * CX^X擾܂B
	 * 
	 * @return BOfflineEntryPointIuWFNg̃CX^X
	 */
	public static OfflineEntryPoint getInstance() {
		if (instance == null) {
			synchronized (OfflineEntryPoint.class) {
				if (instance == null) {
					instance = new OfflineEntryPoint();
				}
			}
		}
		return instance;
	}

	/**
	 * VKZbV<BR>
	 * eXgɐVKɃZbVJnƂɍŏɕKĂяoĂB
	 * 
	 */
	public void startSession() {
		sessionMap.clear();
	}

	/**
	 * fobN\p̃uEUNR}hݒ肵܂B<BR>
	 * ݒ莞́wC:\Program Files\Internet Explorer\iexplore.exexƂȂ܂B
	 * 
	 * @param debugBrowserCommand
	 *            fobN\p̃uEUNR}h
	 */
	public void setDebugBrowserCommand(String debugBrowserCommand) {
		this.debugBrowserCommand = debugBrowserCommand;
	}

	/**
	 * fobOpe|HTMLt@Cݒ肵܂B<BR>
	 * ݒ莞OS̃e|fBNgɁw$$pirka.htmlx쐬܂B
	 * 
	 * @param tempHtmlFile
	 *            fobOpe|HTMLt@C
	 */
	public void setTempHtmlFile(File tempHtmlFile) {
		this.tempHtmlFile = tempHtmlFile;
	}

	/**
	 * T[ubg[hݒ肵܂B<BR>
	 * ̒l͏펞lƂrŕύXĂ͂܂B
	 * 
	 * param oldServletMode true=T[ubg[h
	 */
	public void setOldServletMode(boolean oldServletMode) {
		this.oldServletMode = oldServletMode;
	}

	/**
	 * Gg[|Cg̓Ǝ̃Rg[vZbT[}bvݒ肵܂B<BR>
	 * ̒l͏펞lƂrŕύXĂ͂܂B
	 * 
	 * @param ctrlProcesserMap
	 *            Ǝ̃Rg[vZbT[}bv
	 */
	public void getCtrlProcesserMap(Map<String, CtrlProcesser> ctrlProcesserMap) {
		this.ctrlProcesserMap = ctrlProcesserMap;
	}

	/**
	 * PirkaMessageCvgEnumNXݒ肵܂B<BR>
	 * nullԂƃG[bZ[WƂStringp邱Ƃł܂B<BR>
	 * PirkaMessageCvgEnumNXԂƃG[bZ[WƂĂEnumNX̂ݎgp\ƂȂA<BR>
	 * String̃G[bZ[W̓^CG[ƂȂ܂B<BR>
	 * 
	 * @param pirkaMessageEnumClass
	 *            PirkaMessageCvgEnumNX
	 */
	public void getPirkaMessageEnumClass(Class pirkaMessageEnumClass) {
		this.pirkaMessageEnumClass = pirkaMessageEnumClass;
	}

	/**
	 * ݒ肵EChEuEUɕ\܂B
	 * 
	 * @param window
	 *            EChEIuWFNg
	 * @param displaySec
	 *            \bi0̓uEUI܂ŕ\܂j
	 */
	public void display(PirkaRespons window, int displaySec) {
		if (window == null || !(window instanceof PirkaWindow)) {
			return;
		}
		WindowBaseData windowBaseData = new WindowBaseData();
		windowBaseData.setInstanceNo("1");
		windowBaseData.setSerialNo("");
		((PirkaWindow) window).setWindowBaseData(windowBaseData);

		try {
			FileOutputStream fos = null;

			try {
				fos = new FileOutputStream(getInstance().tempHtmlFile);
				window.writeRespons(fos);
			} finally {
				if (fos != null) {
					fos.close();
				}
			}

			InputStream stream = null;
			try {
				ProcessBuilder builder = new ProcessBuilder(getInstance().debugBrowserCommand, getInstance().tempHtmlFile.getCanonicalPath());
				Process process = builder.start();

				if (displaySec > 0) {
					Object waitObject = new Object();
					synchronized (waitObject) {
						try {
							waitObject.wait(displaySec * 1000L);
						} catch (InterruptedException e) {
							// Ȃ
						}
					}
					process.destroy();
				} else {
					stream = process.getErrorStream();
					while (true) {
						int c = stream.read();
						if (c < 0) {
							break;
						}
					}
				}
			} finally {
				if (stream != null) {
					stream.close();
				}
			}
		} catch (IOException e) {
			throw new RuntimeException("\ʃG[܂", e);
		}

	}

	/**
	 * ANV𔭍s܂B
	 * 
	 * @param window
	 *            ANV𔭍sEChE
	 * @param actionName
	 *            ANV
	 * @param index
	 *            [ṽANVCfbNX
	 * @return EChE
	 */
	public PirkaRespons action(PirkaRespons window, String actionName, int... index) {

		try {
			if (window == null || !(window instanceof PirkaWindow)) {
				throw new RuntimeException("windowPirkaWindow̃IuWFNgł͗L܂");
			}
			if (isOldServletMode()) {
				return serviceMainOldServletProc(window, actionName, index);
			} else {
				return serviceMainProc(window, actionName, index);
			}
		} catch (Throwable e) {
			throw new RuntimeException("\ȂG[܂", e);
		}
	}

	private PirkaRespons serviceMainProc(PirkaRespons nextWindow, String actionName, int[] actionLoopIndex) throws IOException {

		boolean actionMethodNoCallFlag = false;

		do {

			clearErrorFlag(((PirkaWindow) nextWindow).getRootFieldMap()); // G[
			((PirkaWindow) nextWindow).getErrorMessageStocker().clear();

			FieldItem actionFieldItem = null;
			if (actionName != null) {
				actionFieldItem = ((PirkaWindow) nextWindow).getRootFieldItem(actionName);
			}
			if (actionFieldItem != null) {
				((PirkaWindow) nextWindow).setActionLoopIndex(actionLoopIndex);
			} else {
				((PirkaWindow) nextWindow).setActionLoopIndex(new int[0]);
			}

			PirkaWindow oldWindow = (PirkaWindow) nextWindow;

			if (actionFieldItem != null && (!actionFieldItem.getCtrl().getTagName().equalsIgnoreCase("a") || actionFieldItem.getCtrl().isSubmitFlag())) { // FORM^OsubmitiA^Oł͂ȂjH

				// vsȂ
				nextWindow = callAction((PirkaWindow) nextWindow, PRE_ACTION_METHOD_NAME);

				if (actionFieldItem != null && actionFieldItem.getCtrl().isAutoCheck()) {
					// `FbN
					try {
						((PirkaWindow) nextWindow).check();
					} catch (AutoCheckRuntimeException e) {
						actionMethodNoCallFlag = true;
					}
				}
			} else {
				// vsȂ
				nextWindow = callAction((PirkaWindow) nextWindow, PRE_ACTION_METHOD_NAME);
			}

			// ANVĂяo
			if (!actionMethodNoCallFlag && nextWindow == oldWindow) {
				try {
					if (actionFieldItem != null) {
						nextWindow = callEventAction((PirkaWindow) nextWindow, actionName);
					} else {
						// elseĂяo
						nextWindow = callAction((PirkaWindow) nextWindow, ELSE_ACTION_METHOD_NAME);
					}
				} catch (AutoCheckRuntimeException e) {
					// `FbNŃG[EȂɂȂ
				}
			}

			// t@C_E[h
			if (nextWindow == null) {
				// Ỏ
				PirkaWindow returnWindow = oldWindow.getReturnWindow();
				if (returnWindow != null) {
					nextWindow = returnWindow;
				} else {
					nextWindow = oldWindow;
				}
			} else if (nextWindow instanceof PirkaFileDownloader) {
				// t@C_E[h
				// Ȃ
			} else {
				if (nextWindow != oldWindow) { // IuWFNgm̔riʂςȂj
					// JڃNɓNX邩H
					boolean hitFlag = false;
					Class nextWindowClass = nextWindow.getClass();
					PirkaWindow tempWindow = (PirkaWindow) oldWindow;
					while (true) {
						Class tempWindowClass = tempWindow.getClass();
						if (tempWindowClass == nextWindowClass) {// NXIuWFNgm̔r
							((PirkaWindow) nextWindow).setReturnWindow(tempWindow.getReturnWindow());
							hitFlag = true;
							break;
						}
						tempWindow = tempWindow.getReturnWindow();
						if (tempWindow == null) {
							break;
						}
					}
					if (!hitFlag) {
						((PirkaWindow) nextWindow).setReturnWindow(oldWindow); // ߂Zbg
					}
				}
			}

		} while (false);

		if (nextWindow instanceof PirkaWindow) {
			// `OsȂ
			callAction((PirkaWindow) nextWindow, PRE_DRAW_METHOD_NAME);
			changeLabelErrorFlag(((PirkaWindow) nextWindow).getFieldMap()); // x̃G[tO

			((PirkaWindow) nextWindow).fixField();

			// VAԍ쐬ݒiʁAZbVj
			String newSerialNo = "";

			WindowBaseData windowBaseData = new WindowBaseData();
			windowBaseData.setSerialNo(newSerialNo);
			windowBaseData.setInstanceNo("1");
			((PirkaWindow) nextWindow).setWindowBaseData(windowBaseData);

		}

		return nextWindow;
	}

	private PirkaRespons serviceMainOldServletProc(PirkaRespons nextWindow, String actionName, int[] actionLoopIndex) throws IOException {

		boolean actionMethodNoCallFlag = false;

		do {

			clearErrorFlag(((PirkaWindow) nextWindow).getRootFieldMap()); // G[
			((PirkaWindow) nextWindow).getErrorMessageStocker().clear();

			FieldItem actionFieldItem = null;
			if (actionName != null) {
				actionFieldItem = ((PirkaWindow) nextWindow).getRootFieldItem(actionName);
			}
			if (actionFieldItem != null) {
				((PirkaWindow) nextWindow).setActionLoopIndex(actionLoopIndex);
			} else {
				((PirkaWindow) nextWindow).setActionLoopIndex(new int[0]);
			}

			PirkaWindow oldWindow = (PirkaWindow) nextWindow;

			if (actionFieldItem != null && !actionFieldItem.getCtrl().getTagName().equalsIgnoreCase("a")) { // FORM^OsubmitiA^Oł͂ȂjH

				// vsȂ
				nextWindow = callAction((PirkaWindow) nextWindow, PRE_ACTION_METHOD_NAME);

				if (actionFieldItem != null && actionFieldItem.getCtrl().isAutoCheck()) {
					// `FbN
					try {
						((PirkaWindow) nextWindow).check();
					} catch (AutoCheckRuntimeException e) {
						actionMethodNoCallFlag = true;
					}
				}
			} else {
				// vsȂ
				nextWindow = callAction((PirkaWindow) nextWindow, PRE_ACTION_METHOD_NAME);
			}

			// ANVĂяo
			if (!actionMethodNoCallFlag && nextWindow == oldWindow) {
				try {
					if (actionFieldItem != null) {
						nextWindow = callEventAction((PirkaWindow) nextWindow, actionName);
					} else {
						// elseĂяo
						nextWindow = callAction((PirkaWindow) nextWindow, ELSE_ACTION_METHOD_NAME);
					}
				} catch (AutoCheckRuntimeException e) {
					// System.out.println("error!!");
				}
			}

			// t@C_E[h
			if (nextWindow == oldWindow) {
				// ȂɂȂ
			} else if (nextWindow == null) {
				nextWindow = oldWindow;
			} else if (nextWindow instanceof PirkaFileDownloader) {
				// t@C_E[h
				// Ȃ
			} else {
				try {
					nextWindow = (PirkaWindow) nextWindow.getClass().newInstance();
				} catch (InstantiationException e) {
				} catch (IllegalAccessException e) {
				}
			}

		} while (false);

		if (nextWindow instanceof PirkaWindow) {
			// `OsȂ
			callAction((PirkaWindow) nextWindow, PRE_DRAW_METHOD_NAME);
			changeLabelErrorFlag(((PirkaWindow) nextWindow).getFieldMap()); // x̃G[tO

			((PirkaWindow) nextWindow).fixField();

			// VAԍ쐬ݒiʁAZbVj
			String newSerialNo = "";

			WindowBaseData windowBaseData = new WindowBaseData();
			windowBaseData.setSerialNo(newSerialNo);
			windowBaseData.setInstanceNo("1");
			((PirkaWindow) nextWindow).setWindowBaseData(windowBaseData);

		}

		return nextWindow;
	}

	/**
	 * SẴtB[h̃G[
	 * 
	 * @param rootFieldMap
	 *            [gtB[h}bv
	 */
	private void clearErrorFlag(Map<String, FieldItem> rootFieldMap) {
		for (String fieldName : rootFieldMap.keySet()) {
			rootFieldMap.get(fieldName).setErrorFlag(false);
		}
	}

	/**
	 * ANV\bȟĂяo
	 * 
	 * @param window
	 *            EBhE
	 * @param name
	 *            ANVtB[h
	 * @return ɃuEU֑M郌X|XIuWFNg
	 */
	private PirkaRespons callEventAction(PirkaWindow window, String name) {

		FieldItem fieldItem = window.getRootFieldItem(name);
		if (fieldItem != null) {
			HtmlCtrlParts ctrlParts = fieldItem.getCtrl();

			if (ctrlParts != null) {
				CtrlProcesser ctrlProcesser = ctrlParts.getCtrlProcesser();
				if (ctrlProcesser != null && ctrlProcesser.isActionCtrl()) {
					Method method = PirkaInfoPool.getMethod(window, ctrlParts.getBaseName());
					if (method == null) {
						return window;
					}
					try {
						if (method.getReturnType() == null || method.getReturnType() == void.class) {
							method.invoke(window);
							return window;
						}
						return (PirkaRespons) method.invoke(window);
					} catch (IllegalArgumentException e) {
						throw new RuntimeException("ANV\bȟĂяoɎs܂ " + name, e);
					} catch (IllegalAccessException e) {
						throw new RuntimeException("ANV\bȟĂяoɎs܂ " + name, e);
					} catch (InvocationTargetException e) {
						if (e.getCause() instanceof AutoCheckRuntimeException) {
							throw (AutoCheckRuntimeException) e.getCause();
						} else {
							throw new RuntimeException("ANV\bȟĂяoɎs܂ " + name, e);
						}
					}
				}
			}
		}
		return window;
	}

	/**
	 * ̑̃ANV\bȟĂяo
	 * 
	 * @param window
	 *            EBhE
	 * @param name
	 *            ANVtB[h
	 * @return ɃuEU֑M郌X|XIuWFNg
	 */
	private PirkaRespons callAction(PirkaWindow window, String name) {

		Method method = PirkaInfoPool.getMethod(window, name);
		if (method == null) {
			return window;
		}
		try {
			if (method.getReturnType() == null || method.getReturnType() == void.class) {
				method.invoke(window);
				return window;
			}
			return (PirkaRespons) method.invoke(window);
		} catch (IllegalArgumentException e) {
			throw new RuntimeException("ANV\bȟĂяoɎs܂ " + name, e);
		} catch (IllegalAccessException e) {
			throw new RuntimeException("ANV\bȟĂяoɎs܂ " + name, e);
		} catch (InvocationTargetException e) {
			if (e.getCause() instanceof AutoCheckRuntimeException) {
				throw (AutoCheckRuntimeException) e.getCause();
			} else {
				throw new RuntimeException("ANV\bȟĂяoɎs܂ " + name, e);
			}
		}
	}

	/**
	 * x̃G[tOXV
	 * 
	 * @param fieldMap
	 *            tB[h}bv
	 */
	private void changeLabelErrorFlag(FieldMap fieldMap) {
		changeLabelErrorFlagMain(fieldMap, fieldMap, "");
	}

	/**
	 * x̃G[tOXVC
	 * 
	 * @param baseFieldMap
	 *            x[X̃tB[h}bv
	 * @param fieldMap
	 *            tB[h}bv
	 * @param suffix
	 *            TbtBNX
	 */
	private void changeLabelErrorFlagMain(FieldMap baseFieldMap, FieldMap fieldMap, String suffix) {

		String[] fieldNames = fieldMap.getFieldNames();
		for (String fieldName : fieldNames) {
			FieldItem fieldItem = fieldMap.getFieldItem(fieldName);
			String forId = fieldItem.getCtrl().getOptionMap().get("for");
			if (forId != null) {
				if (fieldItem.getCtrl().isSuffix()) {
					forId = forId + suffix;
				}
				boolean errorFlag = isErrorId(baseFieldMap, forId);
				fieldItem.setErrorFlag(errorFlag);
			}
			if (fieldItem.getCtrl().getCtrlProcesser().isLoop() && fieldItem.getValue() != null && fieldItem.getValue() instanceof List) {
				List<FieldMap> list = (List<FieldMap>) fieldItem.getValue();
				int index = 0;
				for (FieldMap childMap : list) {
					changeLabelErrorFlagMain(baseFieldMap, childMap, suffix + '$' + index);
					index++;
				}

			}
		}

	}

	/**
	 * G[IDmF
	 * 
	 * @param baseFieldMap
	 *            x[XtB[h}bv
	 * @param id
	 *            ID
	 * @return true=G[
	 */
	private boolean isErrorId(FieldMap baseFieldMap, String id) {

		return isErrorIdMain(baseFieldMap, id, "");

	}

	/**
	 * G[IDmFC
	 * 
	 * @param baseFieldMap
	 *            x[XtB[h}bv
	 * @param id
	 *            ID
	 * @param suffix
	 *            TtBbNX
	 * @return true=G[
	 */
	private boolean isErrorIdMain(FieldMap baseFieldMap, String id, String suffix) {

		String[] fieldNames = baseFieldMap.getFieldNames();
		for (String fieldName : fieldNames) {
			FieldItem fieldItem = baseFieldMap.getFieldItem(fieldName);
			String targetId = fieldItem.getCtrl().getOptionMap().get("id");
			if (targetId != null) {
				if (fieldItem.getCtrl().isSuffix()) {
					targetId = targetId + suffix;
				}
				if (id.equals(targetId)) {
					if (fieldItem.isErrorFlag()) {
						return true;
					}
				}
			}
			if (fieldItem.getCtrl().getCtrlProcesser().isLoop() && fieldItem.getValue() != null && fieldItem.getValue() instanceof List) {
				List<FieldMap> list = (List<FieldMap>) fieldItem.getValue();
				int index = 0;
				for (FieldMap childMap : list) {
					if (isErrorIdMain(childMap, id, suffix + '$' + index)) {
						return true;
					}
					index++;
				}

			}
		}
		return false;
	}

	// ////////////////////////////////////////////////////////////////////////////////

	/**
	 * Gg[|Cg̓Ǝ̃Rg[vZbT[}bv߂܂B<BR>
	 * ̒l͏펞lƂrŕύXĂ͂܂B
	 * 
	 * @return Ǝ̃Rg[vZbT[}bv
	 */
	public Map<String, CtrlProcesser> getCtrlProcesserMap() {
		return ctrlProcesserMap;
	}

	/**
	 * URL̕ʖ擾܂B <BR>
	 * ̕ʖURL2ڈȍ~̉ʕ\̃uEU[URL\Ɏgp܂B <BR>
	 * ftHg̓pbP[W{NX ̒l͏펞lƂrŕύXĂ͂܂B
	 * 
	 * @return ʖURL
	 */
	public String getUrlAlias() {
		return "offline";
	}

	/**
	 * PirkaMessageCvgEnumNXԂ܂B<BR>
	 * nullԂƃG[bZ[WƂStringp邱Ƃł܂B<BR>
	 * PirkaMessageCvgEnumNXԂƃG[bZ[WƂĂEnumNX̂ݎgp\ƂȂA<BR>
	 * String̃G[bZ[W̓^CG[ƂȂ܂B<BR>
	 * 
	 * @return PirkaMessageCvgEnumNX
	 */
	public Class getPirkaMessageEnumClass() {
		return pirkaMessageEnumClass;
	}

	/**
	 * T[ubg[hmF܂B<BR>
	 * ̒l͏펞lƂrŕύXĂ͂܂B
	 * 
	 * @return true=T[ubg[h
	 */
	public boolean isOldServletMode() {
		return oldServletMode;
	}

	/**
	 * ZVɕۑ
	 * 
	 * @param keyName
	 *            L[
	 * @param object
	 *            ۑIWFNg
	 */
	public void putSession(String keyName, Object object) {
		sessionMap.put(keyName, object);
	}

	/**
	 * ZVo
	 * 
	 * @param keyName
	 *            L[
	 * @return ۑĂIWFNg
	 */
	public Object getSession(String keyName) {
		return sessionMap.get(keyName);
	}

	/**
	 * \[XHTMLt@C̃LN^[Zbgݒ肵܂B<BR>
	 * ftHgłMS932ݒ肳Ă܂B
	 * 
	 * @param resourceHtmlFileCharset
	 *            LN^[Zbg
	 */
	public void setResourceHtmlFileCharset(String resourceHtmlFileCharset) {
		this.resourceHtmlFileCharset = resourceHtmlFileCharset;
	}

	/**
	 * uEU[ɑMie|fBNgɏo͂jHTMLC[W̃LN^[Zbgݒ肵܂B<BR>
	 * ftHgłMS932ݒ肳Ă܂B
	 * 
	 * @param outHtmlFileCharset
	 *            LN^[Zbg
	 */
	public void setHtmlStringCharset(String outHtmlFileCharset) {
		this.outHtmlFileCharset = outHtmlFileCharset;
	}

	/**
	 * \[XHTMLt@C̃LN^[Zbg擾܂B<BR>
	 * ʏ͎gp܂B
	 * 
	 * @return LN^[Zbg
	 */
	@Deprecated
	public String getResourceHtmlFileCharset() {
		return resourceHtmlFileCharset;
	}

	/**
	 * uEU[ɑMHTMLC[W̃LN^[Zbg擾܂B<BR>
	 * ʏ͎gp܂B
	 * 
	 * @return LN^[Zbg
	 */
	@Deprecated
	public String getHtmlStringCharset() {
		return outHtmlFileCharset;
	}

	/**
	 * uEU[ɑM郌X|Xwb_̃LN^Zbg擾܂B<BR>
	 * ʏ͎gp܂B
	 * 
	 * @return LN^[Zbg
	 */
	@Deprecated
	public String getResponsHeaderCharset() {
		return "Shift-jis";
	}

	/**
	 * uEU[͕Ro[^[擾<BR>
	 * uEU[œ͂ꂽɑSʋʂȕϊKvȎɃI[o[Ch<BR>
	 * Ǝ̕Ro[^[߂ĂB<BR>
	 * ftHgł͖ϊłB
	 * 
	 * @return Ro[^
	 */
	public StringConverter getInputStringConverter() {
		return DefaultStringConverter.getInstance();
	}

	/**
	 * uEU[o͕Ro[^[擾<BR>
	 * uEU[֏o͂镶ɑSʋʂȕϊKvȎɃI[o[Ch<BR>
	 * Ǝ̕Ro[^[߂ĂB<BR>
	 * ftHgł͖ϊłB
	 * 
	 * @return Ro[^
	 */
	public StringConverter getOutputStringConverter() {
		return DefaultStringConverter.getInstance();
	}

	/**
	 * ʕ\̂Ƃ̓ZbVNA邩̊mF<br>
	 * 
	 * @return true=NAAfalse=NAȂ
	 */
	public boolean isClearSessionAtInitScreen(){
		return true;
	}

	/**
	 * NGXgLN^̕ϊIuWFNg擾<BR>
	 * webT[o[擾郊NGXg̕ϊW<BR>
	 * ύXƂ͂̃\bhI[o[ChēƎ̃NGXg<BR>
	 * LN^̕ϊIuWFNg߂ĂB
	 * 
	 * @return NGXgLN^̕ϊIuWFNg
	 */
	public ReqCharacterConverter getReqCharacterConverter() {
		return DefaultReqCharacterConverter.getInstance();
	}


	/**
	 * e|t@C}l[W[̎擾
	 * 
	 * @return
	 */
	public TempFileManager getTempFileManager() {
		return DefaultTempFileManager.getInstance();
	}

}
