package jp.oarts.pirka.core.kernel;

import java.io.Serializable;
import java.util.HashMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.oarts.pirka.core.app.EntryPointIF;
import jp.oarts.pirka.core.app.OfflineEntryPoint;

/**
 * PirkaJ[l
 * 
 * @author ito
 * 
 */
public class PirkaThreadMap implements Serializable {

	/** Gg[|CgIuWFNg}bv */
	private static final HashMap<Long, EntryPointIF> entryPointObjectMap = new HashMap<Long, EntryPointIF>();

	/** T[ubgp[^}bvIuWFNg}bv */
	private static final HashMap<Long, ServletParam> servletParamMap = new HashMap<Long, ServletParam>();

	/**
	 * Gg[|CgIuWFNg}bv֌݂̃XbhɃGg[|CgIuWFNgݒ肷
	 * 
	 * @param entryPoint
	 *            Gg[|CgIuWFNg
	 */
	public static synchronized void setEntryPointObject(EntryPointIF entryPoint) {
		entryPointObjectMap.put(Thread.currentThread().getId(), entryPoint);
	}

	/**
	 * ݂̃XbhɑΉGg[|CgIuWFNgGg[|CgIuWFNg}bv폜
	 */
	public static synchronized void removeEntryPointObject() {
		entryPointObjectMap.remove(Thread.currentThread().getId());
	}

	/**
	 * ݂̃XbhɑΉGg[|CgIuWFNgGg[|CgIuWFNg}bv擾
	 * 
	 * @param Gg[|CgIuWFN
	 *            ̓ItCGg[|CgIuWFNg
	 */
	public static synchronized EntryPointIF getEntryPointObjct() {
		EntryPointIF entryPoint = entryPointObjectMap.get(Thread.currentThread().getId());
		if (entryPoint == null) {
			return OfflineEntryPoint.getInstance();
		}
		return entryPoint;
	}

	// /////////////////////////////////////////////////////////////////////////////////////////////

	/**
	 * T[ubgp[^}bv֌݂̃T[ubgp[^ݒ肷
	 * 
	 * @param req
	 *            T[ubgNGXg
	 * @param res
	 *            T[ubgX|X
	 * @param session
	 *            ZbV
	 */
	public static synchronized void setServletPartam(HttpServletRequest req, HttpServletResponse res, HttpSession session) {
		servletParamMap.put(Thread.currentThread().getId(), new ServletParam(req, res, session));
	}

	/**
	 * T[ubgp[^}bvփZbVݒ肷
	 * 
	 * @param session
	 *            ZbV
	 */
	public static synchronized void setSession(HttpSession session) {
		ServletParam servletParam = servletParamMap.get(Thread.currentThread().getId());
		if (servletParam == null) {
			return;
		}
		servletParam.setSession(session);
	}

	/**
	 * ݂̃XbhɑΉT[ubgp[^T[ubgp[^}bv폜
	 */
	public static synchronized void removeServletParam() {
		servletParamMap.remove(Thread.currentThread().getId());
	}

	/**
	 * ݂̃XbhɑΉT[ubgp[^̃NGXgT[ubgp[^}bv擾
	 * 
	 * @param NGXg
	 * 
	 */
	public static synchronized HttpServletRequest getServletReq() {
		ServletParam servletParam = servletParamMap.get(Thread.currentThread().getId());
		if (servletParam == null) {
			return null;
		}
		return servletParam.getReq();
	}

	/**
	 * ݂̃XbhɑΉT[ubgp[^̃X|XT[ubgp[^}bv擾
	 * 
	 * @param X|
	 * 
	 */
	public static synchronized HttpServletResponse getServletRes() {
		ServletParam servletParam = servletParamMap.get(Thread.currentThread().getId());
		if (servletParam == null) {
			return null;
		}
		return servletParam.getRes();
	}

	/**
	 * ݂̃XbhɑΉZVT[ubgp[^}bv擾
	 * 
	 * @param ZV
	 * 
	 */
	public static synchronized HttpSession getSession() {
		ServletParam servletParam = servletParamMap.get(Thread.currentThread().getId());
		if (servletParam == null) {
			return null;
		}
		return servletParam.getSession();
	}

}
