package jp.oarts.pirka.core.ctrl.proc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.oarts.pirka.core.analyzer.html.HtmlTools;
import jp.oarts.pirka.core.err.ErrorMessageManagerIF;
import jp.oarts.pirka.core.err.ErrorMessageStocker;
import jp.oarts.pirka.core.general.HtmlCtrlParts;
import jp.oarts.pirka.core.general.HtmlParts;
import jp.oarts.pirka.core.general.WindowBaseData;
import jp.oarts.pirka.core.util.field.FieldItem;

/**
 * Rg[[ۃNX
 * 
 * @author ito
 * 
 */
public abstract class CtrlProcesser implements Serializable {

	/**
	 * HTMLp[cXg̎^O̎qp[c̃^O鎞trueԂ܂B
	 * 
	 * @return true=qp[c̃^O
	 */
	public abstract boolean isUseChild();

	/**
	 * [v^O̎tureԂ܂B
	 * 
	 * @return true=[v^O
	 */
	public abstract boolean isLoop();

	/**
	 * XCb`^O̎tureԂ܂B
	 * 
	 * @return true=XCb`^O
	 */
	public abstract boolean isSwitch();

	/**
	 * uEUœ͂sȂ^ÔƂrtueԂ܂B
	 * 
	 * @return true=uEUœ
	 */
	public abstract boolean isInputCtrl();

	/**
	 * uEU[̃ANVƂtureԂ܂B
	 * 
	 * @return true=ANV
	 */
	public abstract boolean isActionCtrl();

	/**
	 * O[sOsȂ^OiWI{^Ȃǁj̊evf̎tureԂ܂B
	 * 
	 * @return true=O[sOvf
	 */
	public abstract boolean isGroupItem();

	/**
	 * `FbNsȂRg[̎tureԂ܂B
	 * 
	 * @return true=`FbNsȂRg[
	 */
	public abstract boolean isCheckCtrl();

	/**
	 * tH[}bg\ȃRg[̎tureԂ܂B
	 * 
	 * @return true=tH[}bg\ȃRg[
	 */
	public abstract boolean isFormatCtrl();

	/**
	 * f[^̃ZbgsȂ܂B
	 * 
	 * @param data
	 *            f[^
	 * @param fieldItem
	 *            tB[hACe
	 */
	public abstract void setValue(Object data, FieldItem fieldItem);

	/**
	 * l͂܂B
	 * 
	 * @param ctrl
	 *            Rg[
	 * @param list
	 *            ̃^OHTMLp[c̃Xg
	 */
	public abstract void analyzeInitValue(HtmlCtrlParts ctrl, List<HtmlParts> list);

	/**
	 * ^O쐬܂B
	 * 
	 * @param ctrl
	 *            Rg[p[c
	 * @param loopSuffix
	 *            [vTtBbNX
	 * @param value
	 *            l
	 * @param checked
	 *            `FbNl
	 * @param windowBaseData
	 *            ʃf[^
	 * @param errorMessageManager
	 *            G[bZ[W}l[W[
	 * @param errorMessageStocker
	 *            G[bZ[WXgbJ[
	 * @param errorFlag
	 *            G[tO true=G[
	 * @param workMap
	 *            Ɨp}bv
	 * 
	 * @return 쐬ꂽ^O
	 */
	public abstract String makeStartTag(HtmlCtrlParts ctrl, String loopSuffix, String value, boolean checked, WindowBaseData windowBaseData,//
			ErrorMessageManagerIF errorMessageManager, ErrorMessageStocker errorMessageStocker, boolean errorFlag, Map<String, Object> workMap);

	/**
	 * I^O쐬܂B
	 * 
	 * @param ctrl
	 *            Rg[
	 * @return 쐬ꂽ^O
	 */
	public String makeEndTag(HtmlCtrlParts ctrl) {
		if (!ctrl.isTagEffective() || !ctrl.isEndTagFlag()) {
			return "";
		}
		StringBuilder sb = new StringBuilder();
		sb.append("</");
		sb.append(ctrl.getTagName());
		// sb.append(createOptionString(null, null, null, null, parts.getEndTagOption()));
		sb.append('>');

		return sb.toString();
	}

	/**
	 * NGXgi͌ʁjtB[hɃZbg܂B
	 * 
	 * @param reqMap
	 *            NGXg}bv
	 * @param fieldName
	 *            TtBbNXttB[h
	 * @param fieldItem
	 *            tB[h
	 * @param values
	 *            l
	 */
	public void setReq(Map<String, String[]> reqMap, String fieldName, FieldItem fieldItem, String[] values) {
		if (values != null && values.length > 0) {
			fieldItem.setValue(values[0]);
		}
	}

	/**
	 * }bv𕶎ɕϊ܂B
	 * 
	 * @param type
	 *            ^Cv
	 * @param name
	 *            ^O
	 * @param loopSuffix
	 *            [vTtBbNX
	 * @param value
	 *            livaluej
	 * @param isSuffix
	 *            TbtBbNXtO
	 * @param optionMap
	 *            }bv
	 * @return ϊꂽ
	 */
	protected String createOptionString(String type, String name, String loopSuffix, String value, boolean isSuffix, Map<String, String> optionMap) {
		StringBuilder sb = new StringBuilder();

		if (type != null && type.length() > 0) {
			sb.append(" type=\"");
			sb.append(type);
			sb.append("\"");
		}

		if (name != null && name.length() > 0) {
			sb.append(" name=\"");
			sb.append(name);
			sb.append("\"");
		}

		if (value != null) {
			sb.append(" value=\"");
			sb.append(HtmlTools.webString(value));
			sb.append("\"");
		}

		for (String key : optionMap.keySet()) {
			if (!key.equalsIgnoreCase("type") && !key.equalsIgnoreCase("name") && !key.equalsIgnoreCase("value")) {
				addOption(sb, optionMap, key, isSuffix, loopSuffix);
			}
		}

		return sb.toString();
	}

	/**
	 * }bv𕶎ɕϊ܂B
	 * 
	 * @param type
	 *            ^Cv
	 * @param name
	 *            ^O
	 * @param loopSuffix
	 *            [vTtBbNX
	 * @param value
	 *            livaluej
	 * @param isSuffix
	 *            TbtBbNXtO
	 * @param optionMap
	 *            }bv
	 * @param checked
	 *            `FbNtO
	 * @return ϊꂽ
	 */
	protected String createOptionStringChecked(String type, String name, String loopSuffix, String value, boolean isSuffix, Map<String, String> optionMap, boolean checked) {
		StringBuilder sb = new StringBuilder();

		if (type != null && type.length() > 0) {
			sb.append(" type=\"");
			sb.append(type);
			sb.append("\"");
		}

		if (name != null && name.length() > 0) {
			sb.append(" name=\"");
			sb.append(name);
			sb.append("\"");
		}

		if (value != null) {
			sb.append(" value=\"");
			sb.append(HtmlTools.webString(value));
			sb.append("\"");
		}

		if (checked) {
			sb.append(" checked");
		}

		for (String key : optionMap.keySet()) {
			if (!key.equalsIgnoreCase("type") && !key.equalsIgnoreCase("name") && !key.equalsIgnoreCase("value") && !key.equalsIgnoreCase("checked")) {
				addOption(sb, optionMap, key, isSuffix, loopSuffix);
			}
		}

		return sb.toString();
	}

	/**
	 * w肳ꂽStringBuilderɎw肳ꂽǉ܂B
	 * 
	 * @param sb
	 *            StringBuilderIuWFNg
	 * @param optionMap
	 *            }bv
	 * @param optionName
	 *            
	 * @param isSuffix
	 *            TbtBbNXtO
	 * @param loopSuffix
	 *            [vTtBbNX
	 */
	protected void addOption(StringBuilder sb, Map<String, String> optionMap, String optionName, boolean isSuffix, String loopSuffix) {
		if (optionMap.containsKey(optionName)) {
			sb.append(' ');
			sb.append(optionName);
			String value = optionMap.get(optionName);
			if (value != null) {
				sb.append('=');
				sb.append('\"');
				sb.append(value);
				if (("id".equalsIgnoreCase(optionName) || "for".equalsIgnoreCase(optionName)) && isSuffix) {
					sb.append(loopSuffix);
				}
				sb.append('\"');
			}
		}
	}

	/**
	 * IvV}bvstyleNGX^CɕύX܂B
	 * 
	 * @param ngStyle
	 *            NGX^CiG[̃X^Cj
	 * @param optinMap
	 *            IvV}bv
	 * @return styleύXꂽIvV}bv
	 */
	protected Map<String, String> changeStyle(String ngStyle, Map<String, String> optinMap) {
		Map<String, String> newOptionMap = new HashMap<String, String>();

		newOptionMap.putAll(optinMap);
		String style = newOptionMap.get("style");
		if (style == null) {
			style = "";
		}

		HashMap<String, String> styleKeyMap = analyzeAllStyle(ngStyle);
		style = removeStyleItem(style, styleKeyMap);
		style = addStyle(style, ngStyle);
		newOptionMap.put("style", style);

		return newOptionMap;
	}

	/**
	 * G[̃X^C͂L[􂢏onbV}bvɊi[܂B
	 * 
	 * @param ngStyle
	 *            G[̃X^C
	 * @return X^CL[i[ꂽnbV}bv
	 */
	private HashMap<String, String> analyzeAllStyle(String ngStyle) {

		HashMap<String, String> map = new HashMap<String, String>();
		analyzeAllStyle(map, ngStyle);

		return map;
	}

	/**
	 * X^C͂L[􂢏onbV}bvɊi[܂B
	 * 
	 * @param map
	 *            X^CL[i[ꂽnbV}bv
	 * @param style
	 *            X^C
	 * @return X^CL[i[ꂽnbV}bv
	 */
	private void analyzeAllStyle(HashMap<String, String> map, String style) {
		if (style == null || style.length() <= 0) {
			return;
		}

		String[] styleItems = style.split(";");
		for (String styleItem : styleItems) {

			String[] items = styleItem.split(":");
			if (items != null && items.length > 0) {

				String styleKey = items[0].trim();
				if (styleKey.length() > 0) {
					map.put(styleKey.toLowerCase(), styleKey);
				}
			}
		}

	}

	/**
	 * X^CɃX^Cǉ܂B
	 * 
	 * @param style
	 *            X^C
	 * @param addStyle
	 *            ǉX^C
	 * @return ǉꂽX^C
	 */
	public String addStyle(String style, String addStyle) {

		if (style == null) {
			style = addStyle;
		}

		StringBuffer sb = new StringBuffer();
		style = style.trim();
		if (style.trim().length() > 0) {
			sb.append(style);
			sb.append(';');
		}
		sb.append(addStyle);
		return sb.toString();
	}

	/**
	 * X^Cp[^Ŏw肳ꂽڂ폜܂B
	 * 
	 * @param style
	 *            X^C
	 * @param removeStyleMap
	 *            폜X^C̃}bv
	 * @return 폜ꂽX^C
	 */
	private String removeStyleItem(String style, HashMap<String, String> removeStyleMap) {

		if (style == null || style.trim().length() <= 0) {
			return "";
		}

		String[] items = style.split(";");
		if (items == null || items.length <= 0) {
			return "";
		}

		ArrayList<String> list = new ArrayList<String>();
		for (String item : items) {
			boolean removeFlag = false;
			String[] wk = item.split(":");
			if (wk == null || wk.length <= 0) {
				removeFlag = true;
			} else {
				if (removeStyleMap.get(wk[0].trim().toLowerCase()) != null) {
					removeFlag = true;
				}
			}

			if (!removeFlag) {
				list.add(item);
			}
		}

		if (list.size() <= 0) {
			return "";
		}

		StringBuilder sb = new StringBuilder();
		for (String item : list) {
			if (sb.length() > 0) {
				sb.append(";");
			}
			sb.append(item);
		}
		list = null;
		return sb.toString();
	}

}
