/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.ctrl.proc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.oarts.pirka.core.analyzer.html.HtmlTools;
import jp.oarts.pirka.core.err.ErrorMessageManagerIF;
import jp.oarts.pirka.core.err.ErrorMessageStocker;
import jp.oarts.pirka.core.general.HtmlCtrlParts;
import jp.oarts.pirka.core.general.HtmlParts;
import jp.oarts.pirka.core.general.WindowBaseData;
import jp.oarts.pirka.core.util.field.FieldItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CtrlProcesser
implements Serializable {
    public abstract boolean isUseChild();

    public abstract boolean isLoop();

    public abstract boolean isSwitch();

    public abstract boolean isInputCtrl();

    public abstract boolean isActionCtrl();

    public abstract boolean isGroupItem();

    public abstract boolean isCheckCtrl();

    public abstract boolean isFormatCtrl();

    public abstract void setValue(Object var1, FieldItem var2);

    public abstract void analyzeInitValue(HtmlCtrlParts var1, List<HtmlParts> var2);

    public abstract String makeStartTag(HtmlCtrlParts var1, String var2, String var3, boolean var4, WindowBaseData var5, ErrorMessageManagerIF var6, ErrorMessageStocker var7, boolean var8, Map<String, Object> var9);

    public String makeEndTag(HtmlCtrlParts ctrl) {
        if (!ctrl.isTagEffective() || !ctrl.isEndTagFlag()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("</");
        sb.append(ctrl.getTagName());
        sb.append('>');
        return sb.toString();
    }

    public void setReq(Map<String, String[]> reqMap, String fieldName, FieldItem fieldItem, String[] values) {
        if (values != null && values.length > 0) {
            fieldItem.setValue(values[0]);
        }
    }

    protected String createOptionString(String type, String name, String loopSuffix, String value, boolean isSuffix, Map<String, String> optionMap) {
        StringBuilder sb = new StringBuilder();
        if (type != null && type.length() > 0) {
            sb.append(" type=\"");
            sb.append(type);
            sb.append("\"");
        }
        if (name != null && name.length() > 0) {
            sb.append(" name=\"");
            sb.append(name);
            sb.append("\"");
        }
        if (value != null) {
            sb.append(" value=\"");
            sb.append(HtmlTools.webString(value));
            sb.append("\"");
        }
        for (String key : optionMap.keySet()) {
            if (key.equalsIgnoreCase("type") || key.equalsIgnoreCase("name") || key.equalsIgnoreCase("value")) continue;
            this.addOption(sb, optionMap, key, isSuffix, loopSuffix);
        }
        return sb.toString();
    }

    protected String createOptionStringChecked(String type, String name, String loopSuffix, String value, boolean isSuffix, Map<String, String> optionMap, boolean checked) {
        StringBuilder sb = new StringBuilder();
        if (type != null && type.length() > 0) {
            sb.append(" type=\"");
            sb.append(type);
            sb.append("\"");
        }
        if (name != null && name.length() > 0) {
            sb.append(" name=\"");
            sb.append(name);
            sb.append("\"");
        }
        if (value != null) {
            sb.append(" value=\"");
            sb.append(HtmlTools.webString(value));
            sb.append("\"");
        }
        if (checked) {
            sb.append(" checked");
        }
        for (String key : optionMap.keySet()) {
            if (key.equalsIgnoreCase("type") || key.equalsIgnoreCase("name") || key.equalsIgnoreCase("value") || key.equalsIgnoreCase("checked")) continue;
            this.addOption(sb, optionMap, key, isSuffix, loopSuffix);
        }
        return sb.toString();
    }

    protected void addOption(StringBuilder sb, Map<String, String> optionMap, String optionName, boolean isSuffix, String loopSuffix) {
        if (optionMap.containsKey(optionName)) {
            sb.append(' ');
            sb.append(optionName);
            String value = optionMap.get(optionName);
            if (value != null) {
                sb.append('=');
                sb.append('\"');
                sb.append(value);
                if (("id".equalsIgnoreCase(optionName) || "for".equalsIgnoreCase(optionName)) && isSuffix) {
                    sb.append(loopSuffix);
                }
                sb.append('\"');
            }
        }
    }

    protected Map<String, String> changeStyle(String ngStyle, Map<String, String> optinMap) {
        HashMap<String, String> newOptionMap = new HashMap<String, String>();
        newOptionMap.putAll(optinMap);
        String style = (String)newOptionMap.get("style");
        if (style == null) {
            style = "";
        }
        HashMap<String, String> styleKeyMap = this.analyzeAllStyle(ngStyle);
        style = this.removeStyleItem(style, styleKeyMap);
        style = this.addStyle(style, ngStyle);
        newOptionMap.put("style", style);
        return newOptionMap;
    }

    private HashMap<String, String> analyzeAllStyle(String ngStyle) {
        HashMap<String, String> map = new HashMap<String, String>();
        this.analyzeAllStyle(map, ngStyle);
        return map;
    }

    private void analyzeAllStyle(HashMap<String, String> map, String style) {
        String[] styleItems;
        if (style == null || style.length() <= 0) {
            return;
        }
        String[] stringArray = styleItems = style.split(";");
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String styleKey;
            String styleItem = stringArray[n];
            String[] items = styleItem.split(":");
            if (items != null && items.length > 0 && (styleKey = items[0].trim()).length() > 0) {
                map.put(styleKey.toLowerCase(), styleKey);
            }
            ++n;
        }
    }

    public String addStyle(String style, String addStyle) {
        if (style == null) {
            style = addStyle;
        }
        StringBuffer sb = new StringBuffer();
        if ((style = style.trim()).trim().length() > 0) {
            sb.append(style);
            sb.append(';');
        }
        sb.append(addStyle);
        return sb.toString();
    }

    private String removeStyleItem(String style, HashMap<String, String> removeStyleMap) {
        if (style == null || style.trim().length() <= 0) {
            return "";
        }
        String[] items = style.split(";");
        if (items == null || items.length <= 0) {
            return "";
        }
        ArrayList<String> list = new ArrayList<String>();
        String[] stringArray = items;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String item = stringArray[n];
            boolean removeFlag = false;
            String[] wk = item.split(":");
            if (wk == null || wk.length <= 0) {
                removeFlag = true;
            } else if (removeStyleMap.get(wk[0].trim().toLowerCase()) != null) {
                removeFlag = true;
            }
            if (!removeFlag) {
                list.add(item);
            }
            ++n;
        }
        if (list.size() <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String item : list) {
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(item);
        }
        list = null;
        return sb.toString();
    }
}

