package jp.oarts.pirka.core.util.format;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;

/**
 * f[^̃tH[}b^[
 * 
 * @author ito
 * 
 */
public class TimeFieldFormat implements FieldFormat {

	/**  */
	private String fomatString;

	/**
	 * RXgN^
	 * 
	 * @param fomatString
	 *            ijava.text.SimpleDateFormat̏j
	 */
	public TimeFieldFormat(String fomatString) {
		this.fomatString = fomatString;
	}

	/**
	 * ꂽ\p̕ɕϊ܂B<BR>
	 * ꂽ̒l\p̕ɕϊłȂƂnull߂܂B
	 * 
	 * @param value
	 *            
	 * @return \p̕
	 */
	public String format(String value) {

		Time timeValue = PirkaFormatUtil.parseTime(value);
		if (timeValue == null) {
			return null;
		}

		SimpleDateFormat sdf = new SimpleDateFormat(fomatString);
		return sdf.format(timeValue);
	}

}
