package jp.oarts.pirka.core.kernel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PirkaUploadManager  implements Serializable{

	private static long fileNo = 0;

	private static Map<Long, File> uploadFileMap = new HashMap<Long, File>();

	private static Map<Long, InputStream> inputStreamMap = new HashMap<Long, InputStream>();

	public static synchronized long getFileNo() {
		fileNo++;
		return fileNo;
	}

	public static synchronized File getFile(long fileNo) throws IOException {
		File tempFile = File.createTempFile("Pirka" + fileNo, "tmp");
		uploadFileMap.put(fileNo, tempFile);
		return tempFile;
	}

	public static synchronized InputStream getInputStream(long fileNo) throws IOException {
		if (inputStreamMap.containsKey(fileNo)) {
			throw new IOException("Ɏ擾ς݂ł");
		}
		File file = uploadFileMap.get(fileNo);

		FileInputStream fis = null;
		fis = new FileInputStream(file);
		inputStreamMap.put(fileNo, fis);
		
		return fis;
	}

	public static synchronized void deleteFile(long fileNo) {
		File file = uploadFileMap.get(fileNo);
		uploadFileMap.remove(fileNo);
		
		InputStream is=inputStreamMap.get(fileNo);
		
		if(is!=null){
			inputStreamMap.remove(fileNo);
			try {
				is.close();	//	N[Y
			} catch (IOException e) {
			}
		}
		file.delete();
	}

	public static synchronized void deleteFile(List<Long> deleteFineNoList) {
		Long[] deleteFileNos = deleteFineNoList.toArray(new Long[0]);
		for (Long fileNo : deleteFileNos) {
			deleteFile(fileNo);
		}
	}

}
