package jp.oarts.pirka.core.util.check;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import jp.oarts.pirka.core.kernel.PirkaThreadMap;

/**
 * `FbJ[XgbJ[
 * 
 * @author ito
 * 
 */
public class CheckerStocker  implements Serializable{

	/** PirkabZ[WNXIuWFNg */
	private Class pirkaMessageClass;

	/** XgbNXg */
	private List<CheckerItem> checkerList;

	/**
	 * RXgN^
	 */
	public CheckerStocker() {
		checkerList = new ArrayList<CheckerItem>();
		pirkaMessageClass = PirkaThreadMap.getEntryPointObjct().getPirkaMessageEnumClass();
	}

	/**
	 * o^Ă`FbJ[ACe擾
	 * 
	 * @return `FbJ[ACe
	 */
	public int size() {
		return checkerList.size();
	}

	/**
	 * w肳ꂽCfbNXɑΉ`FbJ[ACẽ[h擾
	 * 
	 * @param index
	 *            CfbNXi0`size()-1j
	 * @return [h
	 */
	public int getMode(int index) {
		return checkerList.get(index).getMode();
	}

	/**
	 * w肳ꂽCfbNXɑΉ`FbJ[ACe擾
	 * 
	 * @param index
	 *            CfbNXi0`size()-1j
	 * @return `FbJ[ACe
	 */
	public CheckerItem getCheckItem(int index) {
		return checkerList.get(index);
	}

	/**
	 * `FbJ[̒ǉ
	 * 
	 * @param fieldName
	 *            tB[h
	 * @param checker
	 *            `FbJ[
	 */
	public void addCheck(String fieldName, Checker... checker) {
		if (pirkaMessageClass != null) {
			throw new RuntimeException("PirkaMessageo^Ă邽߂̃\bh͎gpł܂");
		}
		checkerList.add(new CheckerItem(fieldName, checker));
	}

	/**
	 * `FbJ[̒ǉ
	 * 
	 * @param fieldName
	 *            tB[h
	 * @param message
	 *            G[bZ[W
	 * @param checker
	 *            `FbJ[
	 */
	public void addCheck(String fieldName, String message, Checker... checker) {
		if (pirkaMessageClass != null) {
			throw new RuntimeException("PirkaMessageo^Ă邽߂̃\bh͎gpł܂");
		}
		checkerList.add(new CheckerItem(fieldName, message, checker));
	}

	/**
	 * `FbJ[̒ǉ
	 * 
	 * @param fieldName
	 *            tB[h
	 * @param message
	 *            PirkabZ[W
	 * @param checker
	 *            `FbJ[
	 */
	public void addCheck(String fieldName, PirkaMessage message, Checker... checker) {
		if (pirkaMessageClass == null) {
			throw new RuntimeException("PirkaMessageo^̂߂̃\bh͎gpł܂");
		}
		if (pirkaMessageClass != message.getClass()) { // NXIuWFNg̔r
			throw new RuntimeException("o^ꂽPirkaMessageƈႢ܂");
		}
		checkerList.add(new CheckerItem(fieldName, message, checker));
	}

	/**
	 * `FbNe[̒ǉ
	 * 
	 * @param checckAndTeller
	 *            `FbNe[
	 */
	public void addCheck(CheckAndTeller... checckAndTeller) {
		checkerList.add(new CheckerItem(checckAndTeller));
	}

	/**
	 * u[J[̒ǉ
	 */
	public void addErrorChaeckBreak() {
		checkerList.add(CheckerItem.BREAKER);
	}

	/**
	 * ^[i[̒ǉ
	 */
	public void addErrorChaeckReturner() {
		checkerList.add(CheckerItem.RETURNER);
	}

	/**
	 * o^ĂSẴ`FbJ[NA
	 */
	public void clearCheck() {
		checkerList.clear();
	}

}
