package jp.oarts.pirka.core.err;

import java.io.Serializable;

import jp.oarts.pirka.core.util.check.PirkaMessage;

/**
 * G[bZ[WACe
 * 
 * @author ito
 *
 */
public class ErrorMessageItem  implements Serializable{

	/** tB[h */
	private String fieldName;

	/** bZ[W */
	private String message;

	/** PirkabZ[W */
	private PirkaMessage pirkaMessage;

	/**
	 * RXgN^
	 * 
	 * @param message
	 *            bZ[W
	 */
	public ErrorMessageItem(String message) {
		this.fieldName = "";
		this.message = message;
		this.pirkaMessage = null;
	}

	/**
	 * RXgN^
	 * 
	 * @param pirkaMessage
	 *            PirkabZ[W
	 */
	public ErrorMessageItem(PirkaMessage pirkaMessage) {
		this.fieldName = "";
		this.message = "";
		this.pirkaMessage = pirkaMessage;
	}

	/**
	 * RXgN^
	 * 
	 * @param fieldName
	 *            tB[h
	 * @param message
	 *            bZ[W
	 */
	public ErrorMessageItem(String fieldName, String message) {
		this.fieldName = fieldName;
		this.message = message;
		this.pirkaMessage = null;
	}

	/**
	 * RXgN^
	 * 
	 * @param fieldName
	 *            tB[h
	 * @param pirkaMessage
	 *            PirkabZ[W
	 */
	public ErrorMessageItem(String fieldName, PirkaMessage pirkaMessage) {
		this.fieldName = fieldName;
		this.message = "";
		this.pirkaMessage = pirkaMessage;
	}

	/**
	 * @return fieldName ߂܂B
	 */
	public String getFieldName() {
		return fieldName;
	}

	/**
	 * @return message ߂܂B
	 */
	public String getMessage() {
		return message;
	}

	/**
	 * @return pirkaMessage ߂܂B
	 */
	public PirkaMessage getPirkaMessage() {
		return pirkaMessage;
	}

}
