package jp.oarts.pirka.sample;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

import jp.oarts.pirka.sample.instruction.is100100.Index;
import jp.oarts.pirka.sample.instruction.is100300.SpanSample;
import jp.oarts.pirka.sample.instruction.is100400.ASample;
import jp.oarts.pirka.sample.instruction.is100500.SubmitSample;
import jp.oarts.pirka.sample.instruction.is100600.TextareaSample;
import jp.oarts.pirka.sample.instruction.is100700.TextSample;
import jp.oarts.pirka.sample.instruction.is100800.PasswordSample;
import jp.oarts.pirka.sample.instruction.is100900.RadioSample;
import jp.oarts.pirka.sample.instruction.is101000.CheckboxSample;
import jp.oarts.pirka.sample.instruction.is101100.SelectSample;
import jp.oarts.pirka.sample.instruction.is101200.GetBeanSample;
import jp.oarts.pirka.sample.instruction.is101300.SetBeanSample;
import jp.oarts.pirka.sample.instruction.is101400.LoopSample;
import jp.oarts.pirka.sample.instruction.is101500.SwitchSample;
import jp.oarts.pirka.sample.instruction.is101600.ScreenTransitionSample;
import jp.oarts.pirka.sample.instruction.is101700.PreDrawSample;
import jp.oarts.pirka.sample.instruction.is101800.ScriptSample;
import jp.oarts.pirka.sample.instruction.is101900.ImageSample;
import jp.oarts.pirka.sample.instruction.is102000.FileDownloadSample;
import jp.oarts.pirka.sample.instruction.is102100.FileUploadSample;
import jp.oarts.pirka.sample.instruction.is102200.AutoCheckSample;
import jp.oarts.pirka.sample.instruction.is102300.AutoCheckSkipSample;
import jp.oarts.pirka.sample.instruction.is102400.CallCheckSample;
import jp.oarts.pirka.sample.instruction.is102500.OnPreSample;
import jp.oarts.pirka.sample.instruction.is102600.OnElseSample;
import jp.oarts.pirka.sample.instruction.is102700.LoopRadio;
import jp.oarts.pirka.sample.instruction.is102800.SubWinSample;
import jp.oarts.pirka.sample.instruction.is102900.AjaxGetMstData;
import jp.oarts.pirka.sample.instruction.is103000.AjaxTable;
import jp.oarts.pirka.sample.instruction.is103100.JUnitWindow1Sample;
import jp.oarts.pirka.sample.instruction.is103200.FormatSample;
import jp.oarts.pirka.sample.instruction.is103300.LoopDefault;
import jp.oarts.pirka.sample.instruction.is103400.ASubmit;

public class InstructionData implements Serializable {

	private static Map<Integer, InstructionData> InstructionDataMap;

	static {

		InstructionDataMap = new TreeMap<Integer, InstructionData>();

		InstructionDataMap.put(100, new InstructionData( //
				"ƂJ^ȃTv", "", "Index.txt", //
				Index.class, //
				new SourceData("Index.html", "/jp/oarts/pirka/sample/instruction/is100100/Index.html", "TvʂHTMLt@C"), //
				new SourceData("Index.java", "/jp/oarts/pirka/sample/instruction/is100100/Index.src", "TvʂJava\[Xt@C") //
				));

		InstructionDataMap.put(200, new InstructionData( //
				"URL̕ύX@", "", "MypEntryPoint.txt", //
				null, //
				new SourceData("MypEntryPoint.java", "/jp/oarts/pirka/sample/instruction/is100200/MyEntryPoint.src", "TvGg[|CgJava\[Xt@C"), //
				new SourceData("web.xml", "/jp/oarts/pirka/sample/instruction/is100200/web.xml", "TvGg[|Cgweb.xml") //
				));

		InstructionDataMap.put(300, new InstructionData( //
				"ϐ̕\", "", "SpanSample.txt", //
				SpanSample.class, //
				new SourceData("SpanSample.html", "/jp/oarts/pirka/sample/instruction/is100300/SpanSample.html", "TvʂHTMLt@C"), //
				new SourceData("SpanSample.java", "/jp/oarts/pirka/sample/instruction/is100300/SpanSample.src", "TvʂJava\[Xt@C") //
				));

		InstructionDataMap.put(400, new InstructionData( //
				"AJ[ł̃Cxg", "", "ASample.txt", //
				ASample.class, //
				new SourceData("ASample.html", "/jp/oarts/pirka/sample/instruction/is100400/ASample.html", "TvʂHTMLt@C"), //
				new SourceData("ASample.java", "/jp/oarts/pirka/sample/instruction/is100400/ASample.src", "TvʂJava\[Xt@C") //
				));

		InstructionDataMap.put(500, new InstructionData( //
				"Submit{^̃Cxg", "", "SubmitSample.txt", //
				SubmitSample.class, //
				new SourceData("SubmitSample.html", "/jp/oarts/pirka/sample/instruction/is100500/SubmitSample.html", "TvʂHTMLt@C"), //
				new SourceData("SubmitSample.java", "/jp/oarts/pirka/sample/instruction/is100500/SubmitSample.src", "TvʂJava\[Xt@C") //
				));

		InstructionDataMap.put(600, new InstructionData( //
				"eLXgGA̎g", "", "TextareaSample.txt", //
				TextareaSample.class, //
				new SourceData("TextareaSample.html", "/jp/oarts/pirka/sample/instruction/is100600/TextareaSample.html", "TvʂHTMLt@C"), //
				new SourceData("TextareaSample.java", "/jp/oarts/pirka/sample/instruction/is100600/TextareaSample.src", "TvʂJava\[Xt@C") //
				));

		InstructionDataMap.put(700, new InstructionData( //
				"eLXg͂̎g", "", "TextSample.txt", //
				TextSample.class, //
				new SourceData("TextSample.html", "/jp/oarts/pirka/sample/instruction/is100700/TextSample.html", "TvʂHTMLt@C"), //
				new SourceData("TextSample.java", "/jp/oarts/pirka/sample/instruction/is100700/TextSample.src", "TvʂJava\[Xt@C") //
				));

		InstructionDataMap.put(800, new InstructionData( //
				"pX[h̎g", "", "PasswordSample.txt", //
				PasswordSample.class, //
				new SourceData("PasswordSample.html", "/jp/oarts/pirka/sample/instruction/is100800/PasswordSample.html", "TvʂHTMLt@C"), //
				new SourceData("PasswordSample.java", "/jp/oarts/pirka/sample/instruction/is100800/PasswordSample.src", "TvʂJava\[Xt@C") //
				));

		InstructionDataMap.put(900, new InstructionData( //
				"WI{^̎g", "", "RadioSample.txt", //
				RadioSample.class, //
				new SourceData("RadioSample.html", "/jp/oarts/pirka/sample/instruction/is100900/RadioSample.html", "TvʂHTMLt@C"), //
				new SourceData("RadioSample.java", "/jp/oarts/pirka/sample/instruction/is100900/RadioSample.src", "TvʂJava\[Xt@C") //
				));

		InstructionDataMap.put(1000, new InstructionData( //
				"`FbN{bNX̎g", "", "CheckboxSample.txt", //
				CheckboxSample.class, //
				new SourceData("CheckboxSample.html", "/jp/oarts/pirka/sample/instruction/is101000/CheckboxSample.html", "TvʂHTMLt@C"), //
				new SourceData("CheckboxSample.java", "/jp/oarts/pirka/sample/instruction/is101000/CheckboxSample.src", "TvʂJava\[Xt@C") //
				));

		InstructionDataMap.put(1100, new InstructionData( //
				"ZNgj[^Xg{bNX̎g", "", "SelectSample.txt", //
				SelectSample.class, //
				new SourceData("SelectSample.html", "/jp/oarts/pirka/sample/instruction/is101100/SelectSample.html", "TvʂHTMLt@C"), //
				new SourceData("SelectSample.java", "/jp/oarts/pirka/sample/instruction/is101100/SelectSample.src", "TvʂJava\[Xt@C") //
				));

		InstructionDataMap.put(1200, new InstructionData( //
				"getBean̎g", "", "GetBeanSample.txt", //
				GetBeanSample.class, //
				new SourceData("GetBeanSample.html", "/jp/oarts/pirka/sample/instruction/is101200/GetBeanSample.html", "TvʂHTMLt@C"), //
				new SourceData("GetBeanSample.java", "/jp/oarts/pirka/sample/instruction/is101200/GetBeanSample.src", "TvʂJava\[Xt@C"), //
				new SourceData("SampleBean.java", "/jp/oarts/pirka/sample/instruction/is101200/SampleBean.src", "f[^o͗pBeanJava\[Xt@C") //
				));

		InstructionDataMap.put(1300, new InstructionData( //
				"setBean̎g", "", "SetBeanSample.txt", //
				SetBeanSample.class, //
				new SourceData("SetBeanSample.html", "/jp/oarts/pirka/sample/instruction/is101300/SetBeanSample.html", "TvʂHTMLt@C"), //
				new SourceData("SetBeanSample.java", "/jp/oarts/pirka/sample/instruction/is101300/SetBeanSample.src", "TvʂJava\[Xt@C"), //
				new SourceData("SampleBean.java", "/jp/oarts/pirka/sample/instruction/is101300/SampleBean.src", "f[^o͗pBeanJava\[Xt@C") //
				));

		InstructionDataMap.put(1400, new InstructionData( //
				"[v̎g", "", "LoopSample.txt", //
				LoopSample.class, //
				new SourceData("LoopSample.html", "/jp/oarts/pirka/sample/instruction/is101400/LoopSample.html", "TvʂHTMLt@C"), //
				new SourceData("LoopSample.java", "/jp/oarts/pirka/sample/instruction/is101400/LoopSample.src", "TvʂJava\[Xt@C") //
				));

		InstructionDataMap.put(1500, new InstructionData( //
				"\E\̎g", "", "SwitchSample.txt", //
				SwitchSample.class, //
				new SourceData("SwitchSample.html", "/jp/oarts/pirka/sample/instruction/is101500/SwitchSample.html", "TvʂHTMLt@C"), //
				new SourceData("SwitchSample.java", "/jp/oarts/pirka/sample/instruction/is101500/SwitchSample.src", "TvʂJava\[Xt@C") //
				));

		InstructionDataMap.put(1600, new InstructionData( //
				"ʑJڕ@", "", "ScreenTransitionSample.txt", //
				ScreenTransitionSample.class, //
				new SourceData("ScreenTransitionSample.html", "/jp/oarts/pirka/sample/instruction/is101600/ScreenTransitionSample.html", "TvʂHTMLt@C"), //
				new SourceData("ScreenTransitionSample.java", "/jp/oarts/pirka/sample/instruction/is101600/ScreenTransitionSample.src", "TvʂJava\[Xt@C"), //
				new SourceData("ScreenTransitionNextWindowSample.html", "/jp/oarts/pirka/sample/instruction/is101600/ScreenTransitionNextWindowSample.html", "ʂHTMLt@C"), //
				new SourceData("ScreenTransitionNextWindowSample.java", "/jp/oarts/pirka/sample/instruction/is101600/ScreenTransitionNextWindowSample.src", "ʂJava\[Xt@C") //
				));

		InstructionDataMap.put(1700, new InstructionData( //
				"preDrawɂāiHTML쐬OCxgj", "", "PreDrawSample.txt", //
				PreDrawSample.class, //
				new SourceData("PreDrawSample.html", "/jp/oarts/pirka/sample/instruction/is101700/PreDrawSample.html", "TvʂHTMLt@C"), //
				new SourceData("PreDrawSample.java", "/jp/oarts/pirka/sample/instruction/is101700/PreDrawSample.src", "TvʂJava\[Xt@C"), //
				new SourceData("PreDrawNextWindowSample.html", "/jp/oarts/pirka/sample/instruction/is101700/PreDrawNextWindowSample.html", "ʂHTMLt@C"), //
				new SourceData("PreDrawNextWindowSample.java", "/jp/oarts/pirka/sample/instruction/is101700/PreDrawNextWindowSample.src", "ʂJava\[Xt@C") //
				));

		InstructionDataMap.put(1800, new InstructionData( //
				"Javascript\[X̓Io͕@", "", "ScriptSample.txt", //
				ScriptSample.class, //
				new SourceData("ScriptSample.html", "/jp/oarts/pirka/sample/instruction/is101800/ScriptSample.html", "TvʂHTMLt@C"), //
				new SourceData("ScriptSample.java", "/jp/oarts/pirka/sample/instruction/is101800/ScriptSample.src", "TvʂJava\[Xt@C") //
				));

		InstructionDataMap.put(1900, new InstructionData( //
				"IC[W̍", "", "ImageSample.txt", //
				ImageSample.class, //
				new SourceData("ImageSample.html", "/jp/oarts/pirka/sample/instruction/is101900/ImageSample.html", "TvʂHTMLt@C"), //
				new SourceData("ImageSample.java", "/jp/oarts/pirka/sample/instruction/is101900/ImageSample.src", "TvʂJava\[Xt@C"), //
				new SourceData("ImageDrawSample.java", "/jp/oarts/pirka/sample/instruction/is101900/ImageDrawSample.src", "TvC[W`NXJava\[Xt@C") //
				));

		InstructionDataMap.put(2000, new InstructionData( //
				"t@C_E[hʂ̍", "", "FileDownloadSample.txt", //
				FileDownloadSample.class, //
				new SourceData("FileDownloadSample.html", "/jp/oarts/pirka/sample/instruction/is102000/FileDownloadSample.html", "TvʂHTMLt@C"), //
				new SourceData("FileDownloadSample.java", "/jp/oarts/pirka/sample/instruction/is102000/FileDownloadSample.src", "TvʂJava\[Xt@C") //
				));

		InstructionDataMap.put(2100, new InstructionData( //
				"t@CAbv[hʂ̍", "", "FileUploadSample.txt", //
				FileUploadSample.class, //
				new SourceData("FileUploadSample.html", "/jp/oarts/pirka/sample/instruction/is102100/FileUploadSample.html", "TvʂHTMLt@C"), //
				new SourceData("FileUploadSample.java", "/jp/oarts/pirka/sample/instruction/is102100/FileUploadSample.src", "TvʂJava\[Xt@C") //
				));

		InstructionDataMap.put(2200, new InstructionData( //
				"`FbN̎w@", "", "AutoCheckSample.txt", //
				AutoCheckSample.class, //
				new SourceData("AutoCheckSample.html", "/jp/oarts/pirka/sample/instruction/is102200/AutoCheckSample.html", "TvʂHTMLt@C"), //
				new SourceData("AutoCheckSample.java", "/jp/oarts/pirka/sample/instruction/is102200/AutoCheckSample.src", "TvʂJava\[Xt@C"), //
				new SourceData("AutoCheckOkSample.html", "/jp/oarts/pirka/sample/instruction/is102200/AutoCheckOkSample.html", "OKʂHTMLt@C"), //
				new SourceData("AutoCheckOkSample.java", "/jp/oarts/pirka/sample/instruction/is102200/AutoCheckOkSample.src", "OKʂJava\[Xt@C") //
				));

		InstructionDataMap.put(2300, new InstructionData( //
				"`FbÑXLbv@", "", "AutoCheckSkipSample.txt", //
				AutoCheckSkipSample.class, //
				new SourceData("AutoCheckSkipSample.html", "/jp/oarts/pirka/sample/instruction/is102300/AutoCheckSkipSample.html", "TvʂHTMLt@C"), //
				new SourceData("AutoCheckSkipSample.java", "/jp/oarts/pirka/sample/instruction/is102300/AutoCheckSkipSample.src", "TvʂJava\[Xt@C"), //
				new SourceData("AutoCheckSkipOkSample.html", "/jp/oarts/pirka/sample/instruction/is102300/AutoCheckSkipOkSample.html", "OKʂHTMLt@C"), //
				new SourceData("AutoCheckSkipOkSample.java", "/jp/oarts/pirka/sample/instruction/is102300/AutoCheckSkipOkSample.src", "OKʂJava\[Xt@C") //
				));

		InstructionDataMap.put(2400, new InstructionData( //
				"`FbN𐏎Ăяo@", "", "CallCheckSample.txt", //
				CallCheckSample.class, //
				new SourceData("CallCheckSample.html", "/jp/oarts/pirka/sample/instruction/is102400/CallCheckSample.html", "TvʂHTMLt@C"), //
				new SourceData("CallCheckSample.java", "/jp/oarts/pirka/sample/instruction/is102400/CallCheckSample.src", "TvʂJava\[Xt@C"), //
				new SourceData("CallCheckOkSample.html", "/jp/oarts/pirka/sample/instruction/is102400/CallCheckOkSample.html", "OKʂHTMLt@C"), //
				new SourceData("CallCheckOkSample.java", "/jp/oarts/pirka/sample/instruction/is102400/CallCheckOkSample.src", "OKʂJava\[Xt@C") //
				));

		InstructionDataMap.put(2500, new InstructionData( //
				"onPreɂāiʎOCxgj", "", "OnPreSample.txt", //
				OnPreSample.class, //
				new SourceData("OnPreSample.html", "/jp/oarts/pirka/sample/instruction/is102500/OnPreSample.html", "TvʂHTMLt@C"), //
				new SourceData("OnPreSample.java", "/jp/oarts/pirka/sample/instruction/is102500/OnPreSample.src", "TvʂJava\[Xt@C") //
				));

		InstructionDataMap.put(2600, new InstructionData( //
				"onElseɂāiJavascriptsubmit̖`Cxgj", "", "OnElseSample.txt", //
				OnElseSample.class, //
				new SourceData("OnElseSample.html", "/jp/oarts/pirka/sample/instruction/is102600/OnElseSample.html", "TvʂHTMLt@C"), //
				new SourceData("OnElseSample.java", "/jp/oarts/pirka/sample/instruction/is102600/OnElseSample.src", "TvʂJava\[Xt@C") //
				));

		InstructionDataMap.put(2700, new InstructionData( //
				"d[ṽWI{^̎g", "", "LoopRadio.txt", //
				LoopRadio.class, //
				new SourceData("LoopRadio.html", "/jp/oarts/pirka/sample/instruction/is102700/LoopRadio.html", "TvʂHTMLt@C"), //
				new SourceData("LoopRadio.java", "/jp/oarts/pirka/sample/instruction/is102700/LoopRadio.src", "TvʂJava\[Xt@C") //
				));

		InstructionDataMap.put(2800, new InstructionData( //
				"EChE̕\@", "", "SubWinSample.txt", //
				SubWinSample.class, //
				new SourceData("ReverseLookupEntryPoint.java", "/jp/oarts/pirka/sample/ReverseLookupEntryPoint.src", "Gg[|CgJava\[Xt@C"), //
				new SourceData("SubWinSample.html", "/jp/oarts/pirka/sample/instruction/is102800/SubWinSample.html", "TvʂHTMLt@C"), //
				new SourceData("SubWinSample.java", "/jp/oarts/pirka/sample/instruction/is102800/SubWinSample.src", "TvʂJava\[Xt@C"), //
				new SourceData("SubWinSubA1.html", "/jp/oarts/pirka/sample/instruction/is102800/SubWinSubA1.html", "Tu A-1HTMLt@C"), //
				new SourceData("SubWinSubA1.java", "/jp/oarts/pirka/sample/instruction/is102800/SubWinSubA1.src", "Tu A-1Java\[Xt@C"), //
				new SourceData("SubWinSubA2.html", "/jp/oarts/pirka/sample/instruction/is102800/SubWinSubA2.html", "Tu A-2HTMLt@C"), //
				new SourceData("SubWinSubA2.java", "/jp/oarts/pirka/sample/instruction/is102800/SubWinSubA2.src", "Tu A-2Java\[Xt@C"), //
				new SourceData("SubWinSubB.html", "/jp/oarts/pirka/sample/instruction/is102800/SubWinSubB.html", "Tu BHTMLt@C"), //
				new SourceData("SubWinSubB.java", "/jp/oarts/pirka/sample/instruction/is102800/SubWinSubB.src", "Tu BJava\[Xt@C") //
				));

		InstructionDataMap.put(2900, new InstructionData( //
				"Ajaxg}X^f[^擾@", "", "AjaxGetMstData.txt", //
				AjaxGetMstData.class, //
				new SourceData("AjaxGetMstData.html", "/jp/oarts/pirka/sample/instruction/is102900/AjaxGetMstData.html", "TvʂHTMLt@C"), //
				new SourceData("AjaxGetMstData.java", "/jp/oarts/pirka/sample/instruction/is102900/AjaxGetMstData.src", "TvʂJava\[Xt@C"), //
				new SourceData("ZipDB.java", "/jp/oarts/pirka/sample/instruction/is102900/ZipDB.src", "TvpX֔ԍf[^x[XJava\[Xt@C") //
				));

		InstructionDataMap.put(3000, new InstructionData( //
				"Ajaxge[u̕XV@", "", "AjaxTable.txt", //
				AjaxTable.class, //
				new SourceData("AjaxTable.html", "/jp/oarts/pirka/sample/instruction/is103000/AjaxTable.html", "TvʂHTMLt@C"), //
				new SourceData("AjaxTable.java", "/jp/oarts/pirka/sample/instruction/is103000/AjaxTable.src", "TvʂJava\[Xt@C"), //
				new SourceData("ZipDB.java", "/jp/oarts/pirka/sample/instruction/is102900/ZipDB.src", "TvpX֔ԍf[^x[XJava\[Xt@C") //
				));

		InstructionDataMap.put(3100, new InstructionData( //
				"JUnitł̎eXg@", "", "JUnitSample.txt", //
				JUnitWindow1Sample.class, //
				new SourceData("JUnitSample.java", "/jp/oarts/pirka/sample/instruction/is103100/JUnitSample.src", "JUnitJava\[Xt@C"), //
				new SourceData("JUnitWindow1Sample.html", "/jp/oarts/pirka/sample/instruction/is103100/JUnitWindow1Sample.html", "eXgΏۉʁivZ͉ʁjHTMLt@C"), //
				new SourceData("JUnitWindow1Sample.java", "/jp/oarts/pirka/sample/instruction/is103100/JUnitWindow1Sample.src", "eXgΏۉʁivZ͉ʁjJava\[Xt@C"), //
				new SourceData("JUnitWindow2Sample.html", "/jp/oarts/pirka/sample/instruction/is103100/JUnitWindow2Sample.html", "eXgΏۉʁivZʕ\ʁjHTMLt@C"), //
				new SourceData("JUnitWindow2Sample.java", "/jp/oarts/pirka/sample/instruction/is103100/JUnitWindow2Sample.src", "eXgΏۉʁivZʕ\Java\[Xt@C") //
				));

		InstructionDataMap.put(3200, new InstructionData( //
				"tH[}bg̎gp@", "", "FormatSample.txt", //
				FormatSample.class, //
				new SourceData("FormatSample.html", "/jp/oarts/pirka/sample/instruction/is103200/FormatSample.html", "TvʂHTMLt@C"), //
				new SourceData("FormatSample.java", "/jp/oarts/pirka/sample/instruction/is103200/FormatSample.src", "TvʂJava\[Xt@C") //
				));

		InstructionDataMap.put(3300, new InstructionData( //
				"[ṽtB[h̏l̐ݒ@", "", "LoopDefault.txt", //
				LoopDefault.class, //
				new SourceData("LoopDefault.html", "/jp/oarts/pirka/sample/instruction/is103300/LoopDefault.html", "TvʂHTMLt@C"), //
				new SourceData("LoopDefault.java", "/jp/oarts/pirka/sample/instruction/is103300/LoopDefault.src", "TvʂJava\[Xt@C") //
				));

		InstructionDataMap.put(3300, new InstructionData( //
				"NŃTu~bgs@", "", "ASubmit.txt", //
				ASubmit.class, //
				new SourceData("ASubmit.html", "/jp/oarts/pirka/sample/instruction/is103400/ASubmit.html", "TvʂHTMLt@C"), //
				new SourceData("ASubmit.java", "/jp/oarts/pirka/sample/instruction/is103400/ASubmit.src", "TvʂJava\[Xt@C") //
				));
	}

	/**
	 * f[^̎擾
	 * @param no	ԍ
	 * @return	f[^		
	 */
	public static InstructionData getInstructionData(int no) {
		return InstructionDataMap.get(no);
	}

	/**
	 * f[^̃L[Zbg擾<BR>
	 * ̃Zbg͏Ƀ\[gĂ
	 * 
	 * @return		L[Zbg
	 */
	public static Set<Integer> getInstructionDataKeySet() {
		return InstructionDataMap.keySet();
	}

	/**	Tv	*/
	private String sampleName;

	/**	Tv	*/
	private String gaiyou;

	/**	|Cgt@C	*/
	private String pointFileName;

	/**	TvNXispj	*/
	private Class sampleClass;

	/**	\[XXg	*/
	private List<SourceData> sourceList;

	/**
	 * RXgN^
	 * 
	 * @param sampleName		Tv
	 * @param gaiyou			Tv
	 * @param pointFileName	|Cgt@C
	 * @param sampleClass		TvNXispj
	 * @param sourceData		\[XXg
	 */
	private InstructionData(String sampleName, String gaiyou, String pointFileName, Class sampleClass, SourceData... sourceData) {
		//		this.no = no;
		this.sampleName = sampleName;
		this.gaiyou = gaiyou;
		this.pointFileName = pointFileName;
		this.sampleClass = sampleClass;

		sourceList = new ArrayList<SourceData>();
		for (SourceData source : sourceData) {
			sourceList.add(source);
		}
	}

	/**
	 * @return gaiyou ߂܂B
	 */
	public String getGaiyou() {
		return gaiyou;
	}

	/**
	 * @param gaiyou ݒ肷 gaiyouB
	 */
	public void setGaiyou(String gaiyou) {
		this.gaiyou = gaiyou;
	}

	/**
	 * @return pointFileName ߂܂B
	 */
	public String getPointFileName() {
		return pointFileName;
	}

	/**
	 * @param pointFileName ݒ肷 pointFileNameB
	 */
	public void setPointFileName(String pointFileName) {
		this.pointFileName = pointFileName;
	}

	/**
	 * @return sampleClass ߂܂B
	 */
	public Class getSampleClass() {
		return sampleClass;
	}

	/**
	 * @param sampleClass ݒ肷 sampleClassB
	 */
	public void setSampleClass(Class sampleClass) {
		this.sampleClass = sampleClass;
	}

	/**
	 * @return sampleName ߂܂B
	 */
	public String getSampleName() {
		return sampleName;
	}

	/**
	 * @param sampleName ݒ肷 sampleNameB
	 */
	public void setSampleName(String sampleName) {
		this.sampleName = sampleName;
	}

	/**
	 * @return sourceList ߂܂B
	 */
	public List<SourceData> getSourceList() {
		return sourceList;
	}

	/**
	 * @param sourceList ݒ肷 sourceListB
	 */
	public void setSourceList(List<SourceData> sourceList) {
		this.sourceList = sourceList;
	}

}
