package jp.oarts.pirka.test.view;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

import jp.oarts.pirka.core.ctrl.SelectList;
import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.util.converter.Converter;
import jp.oarts.pirka.core.util.format.DateFieldFormat;
import jp.oarts.pirka.core.win.PirkaWindow;

public class CtrlTest12 extends PirkaWindow {

	private static final Converter[] getConverter = new Converter[] { new Converter("item11", "item99") };

	private static final Converter[] setConverter = new Converter[] { new Converter("item11", "item99") };
	
	List<CtrlTest12Bean2> list;
	
	public void execButton() {
		FieldMap field = getFieldMap();

		CtrlTest12Bean1 bean = new CtrlTest12Bean1();
		getBean(bean, field.getValueBoolean("inputOnly"));

		setBean(new CtrlTest12Bean3(bean.toString()));
	}

	public void exec2Button() {

		FieldMap field = getFieldMap();
		//List list = getBeanList(CtrlTest12Bean2.class, field, "loop", field.getValueBoolean("inputOnly"),  getConverter);
		
		if(list ==null || list.size()<=0){
			return ;
		}
		list.get(0).setDummy("_~[");
		getBeanList(list, field, "loop", field.getValueBoolean("inputOnly"),  getConverter);

		StringBuilder sb = new StringBuilder();
		for (CtrlTest12Bean2 bean : (List<CtrlTest12Bean2>) list) {
			sb.append(bean.toString());
			sb.append("\n");
		}
		setBean(new CtrlTest12Bean3(sb.toString()));
	}

	public void exec3Button() {
		FieldMap field = getFieldMap();

		Integer loopCount = field.getValueInt("item05");
		//List<CtrlTest12Bean2> list = new ArrayList<CtrlTest12Bean2>();
		list = new ArrayList<CtrlTest12Bean2>();
		if (loopCount != null) {
			long dateMilliSec = System.currentTimeMillis();
			for (int i = 0; i < loopCount; i++) {
				CtrlTest12Bean2 bean = new CtrlTest12Bean2();

				bean.setItem99(i + 1);
				bean.setItem12(new Date(dateMilliSec));
				dateMilliSec += 24 * 3600 * 1000L;
				bean.setItem13((i % 2) == 0 ? true : false);
				bean.setItem14("14-" + ((i % 2) + 1));
				bean.setItem15("" + ((i % 2) + 1));
				bean.setLabel_text13("ׂ邤13");

				list.add(bean);
			}
		}
		setBeanList(list, field, "loop", field.getValueBoolean("inputOnly"), setConverter);

		SelectList selectList = new SelectList();
		selectList.add("", "1");
		selectList.add("グނグ", "2");

		// t̃tH[}bg&obNJ[ݒ
		for (int i = 0; i < field.getFieldMapSize("loop"); i++) {
			FieldMap loopFieldMap = field.getFieldMap("loop", i);
			loopFieldMap.setSelectList("item15", selectList);
			loopFieldMap.setFormat("item12", new DateFieldFormat("yyyyNMMdd"));
			if ((i % 2) == 0) {
				loopFieldMap.setOption("tr", "style", "background-color: #c0c0e0");
			} else {
				loopFieldMap.setOption("tr", "style", "background-color: #c0e0c0");
			}
		}
	}

	public void exec4Button() {
		FieldMap field = getFieldMap();

		CtrlTest12Bean1 bean = new CtrlTest12Bean1();
		bean.setItem01("abc");
		bean.setItem02(new java.util.Date(System.currentTimeMillis() - 24L * 3600 * 1000 * 7));
		bean.setItem03(true);
		bean.setItem04("4-1");
		bean.setItem05("2");
		bean.setReturnButton("߂{^");
		setBean(bean, field.getValueBoolean("inputOnly"));
	}

	public void exec5Button() {
		FieldMap field = getFieldMap();
		field.clearAllValue();
	}

	public void exec6Button() {
		FieldMap field = getFieldMap();
		int[] index = getActionLoopIndex();

		if (index != null && index.length > 0) {
			field.getFieldMap("loop", index[0]).clearAllValue();
		}
	}

	public PirkaWindow returnButton() {
		return null;
	}
}
