package jp.oarts.pirka.sample.s13;

import java.util.Map;
import java.util.TreeMap;

import jp.oarts.pirka.core.ajax.AjaxScript;
import jp.oarts.pirka.core.ajax.JavaScriptInnerHTML;
import jp.oarts.pirka.core.ajax.OnEventJavaScript;
import jp.oarts.pirka.core.ajax.RequestData;
import jp.oarts.pirka.core.ajax.ResponseData;
import jp.oarts.pirka.core.ajax.ResponseName;
import jp.oarts.pirka.core.analyzer.html.HtmlTools;
import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.win.PirkaWindow;

public class Ajax02 extends PirkaWindow {

	/**
	 * RXgN^
	 */
	public Ajax02() {
		FieldMap field = getFieldMap();

		//	AjaxJavaScriptIuWFNg쐬
		AjaxScript script = new AjaxScript() {

			//	JavascriptXMLHttpRequestŌĂ΂ꂽƂɓ삷郁\bh
			@Override
			public ResponseData run(Map<String, String[]> param) {

				String[] strings = param.get("openNo");
				String openNo = "";
				if (strings != null && strings.length > 0) {
					openNo = strings[0];
				}

				strings = param.get("mode");
				String mode = "";
				if (strings != null && strings.length > 0) {
					mode = strings[0];
				}

				ResponseData responseData = new ResponseData();
				if ("open".equals(mode)) {
					responseData.put("area" + openNo, createZipTable(openNo), false, false);
				} else {
					responseData.put("area" + openNo, "", false, false);
				}
				return responseData;
			}
		};

		script.addResScript(new JavaScriptInnerHTML("area330", new ResponseName("area330")));
		script.addResScript(new JavaScriptInnerHTML("area331", new ResponseName("area331")));
		script.addResScript(new JavaScriptInnerHTML("area332", new ResponseName("area332")));
		script.addResScript(new JavaScriptInnerHTML("area333", new ResponseName("area333")));
		field.setAjaxScript("ajax", script);

		field.setOption("o330", "onmouseover", OnEventJavaScript.getSource("ajax", true, new RequestData("openNo", "330"), new RequestData("mode", "open")));
		field.setOption("c330", "onmouseover", OnEventJavaScript.getSource("ajax", true, new RequestData("openNo", "330"), new RequestData("mode", "close")));
		field.setOption("o331", "onmouseover", OnEventJavaScript.getSource("ajax", true, new RequestData("openNo", "331"), new RequestData("mode", "open")));
		field.setOption("c331", "onmouseover", OnEventJavaScript.getSource("ajax", true, new RequestData("openNo", "331"), new RequestData("mode", "close")));
		field.setOption("o332", "onmouseover", OnEventJavaScript.getSource("ajax", true, new RequestData("openNo", "332"), new RequestData("mode", "open")));
		field.setOption("c332", "onmouseover", OnEventJavaScript.getSource("ajax", true, new RequestData("openNo", "332"), new RequestData("mode", "close")));
		field.setOption("o333", "onmouseover", OnEventJavaScript.getSource("ajax", true, new RequestData("openNo", "333"), new RequestData("mode", "open")));
		field.setOption("c333", "onmouseover", OnEventJavaScript.getSource("ajax", true, new RequestData("openNo", "333"), new RequestData("mode", "close")));
	}

	/**
	 * ZR[h3YꗗHTMLe[uC[W쐬
	 * @param code3	ZR[h3
	 * @return	HTML
	 */
	private String createZipTable(String code3) {

		TreeMap<String, String> map = AjaxZipDB.getCode3Map(code3);
		StringBuilder sb = new StringBuilder();

		sb.append("<table border=\"1\">");
		sb.append("<tr style=\"background-color: #e0ffe0\">");
		sb.append("<th>");
		sb.append("X֔ԍ");
		sb.append("</th>");
		sb.append("<th>");
		sb.append("Z");
		sb.append("</th>");
		sb.append("</tr>");
		if (map != null) {
			for (String zipCode : map.keySet()) {
				sb.append("<tr>");
				sb.append("<td style=\"background-color: #e0ffff\">");
				sb.append(HtmlTools.webString(zipCode.substring(0, 3)));
				sb.append("-");
				sb.append(HtmlTools.webString(zipCode.substring(3)));
				sb.append("</td>");
				sb.append("<td style=\"background-color: #ffffe0\">");
				sb.append(HtmlTools.webString(map.get(zipCode)));
				sb.append("</td>");
				sb.append("</tr>");
			}
		}
		sb.append("</table>");
		return sb.toString();
	}

	/**
	 * ߂{^ijꂽ̏<BR>
	 */
	public PirkaWindow returnButton1() {
		return null;
	}

	/**
	 * ߂{^ijꂽ̏<BR>
	 */
	public PirkaWindow returnButton2() {
		return null;
	}

}
