package jp.oarts.pirka.core.tool;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

import jp.oarts.pirka.core.analyzer.html.HtmlIncludeAnalyzer;
import jp.oarts.pirka.core.kernel.Version;

/**
 * bNAbvpCN[hc[
 * 
 * @author ito
 * 
 */
public class MockupInclude {

	/**
	 * CN[hC
	 * 
	 * @param args
	 *            p[^FHTMLt@CAp[^FoHTMLt@C
	 */
	public static void main(String[] args) {
		System.out.println();
		System.out.println("pirka mockup include tool " + Version.version);
		System.out.println();

		// p[^`FbN
		if (args.length != 2) {
			System.out.println("p[^ɂ܂肪܂B");
			System.out.println("p[^FHTMLt@C oHTMLt@C");
			System.out.println();
			return;
		}

		File file = new File(args[0]);
		if (!file.exists() || !file.isFile()) {
			System.out.println("̓t@Cǂݍ݂ł܂");
			System.out.println();
			return;
		}

		String newHtml = "";
		try {
			newHtml = HtmlIncludeAnalyzer.include(file);
		} catch (IOException e) {
			System.out.println("CN[hɎs܂");
			e.printStackTrace();
			System.out.println();
			return;
		}

		FileWriter fw = null;
		try {
			fw = new FileWriter(args[1]);
			fw.write(newHtml);
		} catch (IOException e) {
			System.out.println("t@Co͂Ɏs܂");
			e.printStackTrace();
			System.out.println();
			return;
		} finally {
			if (fw != null) {
				try {
					fw.close();
				} catch (IOException e) {
					System.out.println("o̓t@CN[Ył܂");
					e.printStackTrace();
					System.out.println();
				}
			}
		}

	}
}
