package jp.oarts.pirka.core.kernel;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;

import jp.oarts.pirka.core.err.ErrorMessageManagerIF;
import jp.oarts.pirka.core.err.ErrorMessageStocker;
import jp.oarts.pirka.core.general.HtmlCtrlParts;
import jp.oarts.pirka.core.general.HtmlParts;
import jp.oarts.pirka.core.general.HtmlPartsType;
import jp.oarts.pirka.core.general.WindowBaseData;
import jp.oarts.pirka.core.util.field.FieldItem;
import jp.oarts.pirka.core.win.PirkaWindow;

/**
 * PirkaJ[l
 * 
 * @author ito
 * 
 */
public class PirkaMakeHtml  implements Serializable{

	/**
	 * EChEIuWFNgHTMLt@CC[W̕쐬
	 * 
	 * @param window
	 *            EChE
	 * @return HTMLt@CC[W̕
	 * @throws IOException
	 */
	public static String makeHtml(PirkaWindow window, ErrorMessageManagerIF errorMessageManager, ErrorMessageStocker errorMessageStocker) throws IOException {
		List<HtmlParts> list = PirkaInfoPool.getHtmlPartsList(window.getHtmlFileName());
		if (list == null) {
			throw new RuntimeException("G[");
		}

		// EntryPointIF entryPoint = PirkaKernel.getEntryPointObjct();
		StringBuilder sb = new StringBuilder();
		// makeHtmlMain(sb, list, window.getFieldMap(), "", entryPoint, window.getWindowBaseData());
		makeHtmlMain(sb, list, window.getFieldMap(), "", window.getWindowBaseData(), errorMessageManager, errorMessageStocker);

		return sb.toString();
	}

	/**
	 * HTMLt@CC[W쐬C
	 * 
	 * @param sb
	 *            o͂StringBuilderIuWFNg
	 * @param htmlPartsLis
	 *            HTMLp[cXg
	 * @param map
	 *            ݂̃[ṽtB[h}bv
	 * @param suffix
	 *            TtBbNXi[vj
	 * @param windowBaseData
	 *            EBhE{f[^
	 * @throws IOException
	 */
	private static void makeHtmlMain(StringBuilder sb, List<HtmlParts> htmlPartsLis, FieldMap map, //
			String suffix, WindowBaseData windowBaseData, ErrorMessageManagerIF errorMessageManager, ErrorMessageStocker errorMessageStocker) throws IOException {

		for (HtmlParts parts : htmlPartsLis) {

			if (parts.getType() != HtmlPartsType.TAG) {

				// ^OȊO͂̂܂܏o
				sb.append(parts.getOrgString());

			} else {

				// ^Oo
				String name = parts.getName(); // O擾
				if (name == null || name.length() <= 0) {

					// O
					sb.append(parts.getOrgString());
					if (parts.getChild() != null) {
						// makeHtmlMain(sb, parts.getChild(), map, suffix, entryPoint, windowBaseData);
						makeHtmlMain(sb, parts.getChild(), map, suffix, windowBaseData, errorMessageManager, errorMessageStocker);
						sb.append(parts.getEndTag());
					}

				} else {

					// OƂ
					FieldItem fieldItem = map.getFieldItem(name);

					HtmlCtrlParts ctrl = fieldItem.getCtrl();
					// HtmlCtrlParts ctrl = getHtmlCtrlParts(map, name, suffix);
					if (ctrl == null) {
						throw new RuntimeException("HTMLƃRg[}bvv܂@" + name);
					}

					// CtrlProcesser ctrlProcesser = CtrlProcesserManager.getCtrlProseccer(ctrl.getProcesserNmae(), entryPoint.getCtrlProcesserMap());
					if (ctrl.getCtrlProcesser().isLoop()) {
						// [v
						makeHtmlLoop(sb, parts, fieldItem, map, suffix, windowBaseData, errorMessageManager, errorMessageStocker);
					} else if (ctrl.getCtrlProcesser().isSwitch()) {
						// XCb`
						makeHtmlSwitch(sb, parts, fieldItem, map, suffix, windowBaseData, errorMessageManager, errorMessageStocker);
					} else {
						// ʏ
						makeHtmlTag(sb, parts, fieldItem, map, suffix, windowBaseData, errorMessageManager, errorMessageStocker);
					}
				}
			}
		}
	}

	/**
	 * ʏ^OHTMLo͏
	 * 
	 * @param sb
	 *            o͂StringBuilderIuWFNg
	 * @param parts
	 *            HTMLp[c
	 * @param ctrl
	 *            THMLRg[p[c
	 * @param ctrlProcesser
	 *            Rg[vZbT
	 * @param rootMap
	 *            [g̃tB[h}bv
	 * @param map
	 *            ݂̃[ṽtB[h}bv
	 * @param suffix
	 *            TtBbNXi[vj
	 * @param entryPoint
	 *            Gg[|Cg
	 * @param windowBaseData
	 *            EBhE{f[^
	 * @throws IOException
	 */
	private static void makeHtmlTag(StringBuilder sb, HtmlParts parts, FieldItem fieldItem, //
			FieldMap map, String suffix, WindowBaseData windowBaseData, ErrorMessageManagerIF errorMessageManager, ErrorMessageStocker errorMessageStocker) throws IOException {

		HtmlCtrlParts ctrl = fieldItem.getCtrl();
		String value = null;
		Object obj = getValue(map, ctrl.getName());
		if (obj != null) {
			value = obj.toString();
		}

		// format
		if (ctrl.getCtrlProcesser().isFormatCtrl() && ctrl.getFormat() != null) {
			String formatedValue = ctrl.getFormat().format(value);
			if (formatedValue != null) {
				sb.append(ctrl.getCtrlProcesser().makeStartTag(ctrl, suffix, formatedValue, fieldItem.isChecked(), windowBaseData, errorMessageManager, errorMessageStocker, fieldItem.isErrorFlag()));
			} else {
				sb.append(ctrl.getCtrlProcesser().makeStartTag(ctrl, suffix, value, fieldItem.isChecked(), windowBaseData, errorMessageManager, errorMessageStocker, fieldItem.isErrorFlag()));
			}
		} else {
			sb.append(ctrl.getCtrlProcesser().makeStartTag(ctrl, suffix, value, fieldItem.isChecked(), windowBaseData, errorMessageManager, errorMessageStocker, fieldItem.isErrorFlag()));
		}
		if (!ctrl.getCtrlProcesser().isUseChild() && parts.getChild() != null) {
			makeHtmlMain(sb, parts.getChild(), map, suffix, windowBaseData, errorMessageManager, errorMessageStocker);
		}

		if (parts.getChild() != null) {
			sb.append(ctrl.getCtrlProcesser().makeEndTag(ctrl));
		}
	}

	/**
	 * [v^OHTMLo͏
	 * 
	 * @param sb
	 *            o͂StringBuilderIuWFNg
	 * @param parts
	 *            HTMLp[c
	 * @param ctrl
	 *            THMLRg[p[c
	 * @param ctrlProcesser
	 *            Rg[vZbT
	 * @param rootMap
	 *            [g̃tB[h}bv
	 * @param map
	 *            ݂̃[ṽtB[h}bv
	 * @param suffix
	 *            TtBbNXi[vj
	 * @param entryPoint
	 *            Gg[|Cg
	 * @param windowBaseData
	 *            EBhE{f[^
	 * @throws IOException
	 */
	private static void makeHtmlLoop(StringBuilder sb, HtmlParts parts, FieldItem fieldItem, //
			FieldMap map, String suffix, WindowBaseData windowBaseData, ErrorMessageManagerIF errorMessageManager, ErrorMessageStocker errorMessageStocker) throws IOException {

		HtmlCtrlParts ctrl = fieldItem.getCtrl();
		sb.append(ctrl.getCtrlProcesser().makeStartTag(ctrl, suffix, "", false, windowBaseData, errorMessageManager, errorMessageStocker, fieldItem.isErrorFlag()));

		if (!ctrl.getCtrlProcesser().isUseChild() && parts.getChild() != null) {
			Object loopObject = getValue(map, ctrl.getName());

			if (loopObject != null) {
				if (loopObject instanceof List) {
					List<FieldMap> valueList = (List<FieldMap>) loopObject;
					for (int i = 0; i < valueList.size(); i++) {
						makeHtmlMain(sb, parts.getChild(), valueList.get(i), suffix + '$' + i, windowBaseData, errorMessageManager, errorMessageStocker);
					}
				} else if (loopObject instanceof Integer) {
					int loopCount = (Integer) loopObject;
					for (int i = 0; i < loopCount; i++) {
						makeHtmlMain(sb, parts.getChild(), map, suffix + '$' + i, windowBaseData, errorMessageManager, errorMessageStocker);
					}
				}
			}
		}
		if (parts.getChild() != null) {
			sb.append(ctrl.getCtrlProcesser().makeEndTag(ctrl));
		}

	}

	/**
	 * XCb`^OHTMLo͏
	 * 
	 * @param sb
	 *            o͂StringBuilderIuWFNg
	 * @param parts
	 *            HTMLp[c
	 * @param ctrl
	 *            THMLRg[p[c
	 * @param ctrlProcesser
	 *            Rg[vZbT
	 * @param rootMap
	 *            [g̃tB[h}bv
	 * @param map
	 *            ݂̃[ṽtB[h}bv
	 * @param suffix
	 *            TtBbNXi[vj
	 * @param entryPoint
	 *            Gg[|Cg
	 * @param windowBaseData
	 *            EBhE{f[^
	 * @throws IOException
	 */
	private static void makeHtmlSwitch(StringBuilder sb, HtmlParts parts, FieldItem fieldItem, //
			FieldMap map, String suffix, WindowBaseData windowBaseData, ErrorMessageManagerIF errorMessageManager, ErrorMessageStocker errorMessageStocker) throws IOException {

		HtmlCtrlParts ctrl = fieldItem.getCtrl();
		sb.append(ctrl.getCtrlProcesser().makeStartTag(ctrl, suffix, "", false, windowBaseData, errorMessageManager, errorMessageStocker, fieldItem.isErrorFlag()));

		if (!ctrl.getCtrlProcesser().isUseChild() && parts.getChild() != null) {

			boolean switchFlag = false;
			Object object = getValue(map, ctrl.getName());
			if (object instanceof Boolean) {
				switchFlag = ((Boolean) object).booleanValue();
			}
			if (switchFlag) {
				makeHtmlMain(sb, parts.getChild(), map, suffix, windowBaseData, errorMessageManager, errorMessageStocker);
			}

		}
		if (parts.getChild() != null) {
			sb.append(ctrl.getCtrlProcesser().makeEndTag(ctrl));
		}
	}

	/**
	 * Rg[p[c擾
	 * 
	 * @param map
	 * @param name
	 * @return
	 */
	private static Object getValue(FieldMap map, String name) {

		FieldItem fieldItem = null;

		fieldItem = map.getFieldItem(name);
		if (fieldItem == null) {
			return null;
		}
		return fieldItem.getValue();

	}

	// /**
	// * Rg[p[c擾
	// *
	// * @param map
	// * @param name
	// * @param suffix
	// * @return
	// */
	// private static FieldItem getHtmlCtrlParts(FieldMap map, String name, String loopSuffix) {
	//
	// FieldItem fieldItem = null;
	//
	// fieldItem = map.getFieldItem(name + suffix);
	// if (fieldItem != null && fieldItem.getCtrl() != null) {
	// return fieldItem.getCtrl();
	// }
	//
	// fieldItem = map.getFieldItem(name);
	// if (fieldItem == null) {
	// return null;
	// }
	// return fieldItem.getCtrl();
	//
	// }

}
