package jp.oarts.pirka.core.kernel;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.oarts.pirka.core.ctrl.SelectList;
import jp.oarts.pirka.core.ctrl.proc.CtrlProcesser;
import jp.oarts.pirka.core.general.HtmlCtrlParts;
import jp.oarts.pirka.core.util.field.FieldItem;
import jp.oarts.pirka.core.util.format.FieldFormat;
import jp.oarts.pirka.core.util.format.PirkaFormatUtil;

/**
 * ʏ̃f[^ێ}bvNX
 * 
 * @author ito
 * 
 */
public class FieldMap implements Serializable {

	/** tB[h}bv */
	protected HashMap<String, FieldItem> fieldMap;

	/**
	 * RXgN^
	 */
	public FieldMap() {
		fieldMap = new HashMap<String, FieldItem>();
	}

	// f[^\bh ///////////////////////////////////////////////////////////////////////////////////////

	// f[^ݒ ////////////////////////////////////

	/**
	 * w肳ꂽtB[hRg[tB[hɒli[܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * 
	 * @param value
	 *            l
	 */
	public void setValue(String fieldName, String value) {
		checkFieldName(fieldName);
		FieldItem fieldItem = fieldMap.get(fieldName);
		fieldItem.getCtrl().getCtrlProcesser().setValue(value == null ? "" : value, fieldItem);
	}

	/**
	 * w肳ꂽtB[hɑΉO[vtB[hvalueƓltB[h̃`FbNONɂAȊOOFFƂ܂B<BR>
	 * WI{^Ŏgp܂B
	 * 
	 * @param fieldName
	 *            tB[hiO[ṽtB[hłTtBbNXOj
	 * 
	 * @param value
	 *            l
	 */
	public void setGroupValue(String fieldName, String value) {
		setGroupValueMain(this, fieldName, value == null ? "" : value, 0);
	}

	private void setGroupValueMain(FieldMap fieldMap, String fieldName, String value, int groupLevel) {

		String[] fieldNames = fieldMap.getFieldNames();
		for (String name : fieldNames) {
			FieldItem fieldItem = fieldMap.getFieldItem(name);
			if (fieldItem.getCtrl().getCtrlProcesser().isGroupItem()) {
				if (fieldName.equals(fieldItem.getCtrl().getBaseName()) && groupLevel == fieldItem.getCtrl().getGroupLevel()) {
					if (value.equals(fieldItem.getValue())) {
						fieldItem.setChecked(true);
					} else {
						fieldItem.setChecked(false);
					}
				}
			}
			if (fieldItem.getCtrl().getCtrlProcesser().isLoop()) {
				List<FieldMap> loopList = (List<FieldMap>) fieldItem.getValue();
				for (FieldMap childMap : loopList) {
					setGroupValueMain(childMap, fieldName, value, groupLevel + 1);
				}
			}

		}
	}

	/**
	 * w肳ꂽtB[hRg[tB[hɕli[܂B<BR>
	 * select^Õ}`IɎgp܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * 
	 * @param values
	 *            l
	 */
	public void setValue(String fieldName, String[] values) {

		StringBuilder sb = new StringBuilder();
		for (String value : values) {
			if (sb.length() > 0) {
				sb.append('\t');
			}
			sb.append(value);
		}

		setValue(fieldName, sb.toString());
	}

	/**
	 * w肳ꂽtB[hRg[tB[hɒli[܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * 
	 * @param value
	 *            l
	 */
	public void setValue(String fieldName, boolean value) {
		checkFieldName(fieldName);
		FieldItem fieldItem = fieldMap.get(fieldName);
		fieldItem.getCtrl().getCtrlProcesser().setValue(value, fieldItem);
	}

	/**
	 * w肳ꂽtB[hRg[tB[hɒli[܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * 
	 * @param value
	 *            l
	 */
	public void setValue(String fieldName, int value) {
		setValue(fieldName, "" + value);
	}

	/**
	 * w肳ꂽtB[hRg[tB[hɒli[܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * 
	 * @param value
	 *            l
	 */
	public void setValue(String fieldName, long value) {
		setValue(fieldName, "" + value);
	}

	/**
	 * w肳ꂽtB[hRg[tB[hɒli[܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * 
	 * @param value
	 *            l
	 */
	public void setValue(String fieldName, BigDecimal value) {
		if (value == null) {
			setValue(fieldName, "");
		} else {
			setValue(fieldName, value.toString());
		}
	}

	/**
	 * w肳ꂽtB[hRg[tB[hɒli[܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * 
	 * @param value
	 *            l
	 */
	public void setValue(String fieldName, Date value) {
		if (value == null) {
			setValue(fieldName, "");
		} else {
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
			setValue(fieldName, sdf.format(value));
		}
	}

	/**
	 * w肳ꂽtB[hRg[tB[hɒli[܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * 
	 * @param value
	 *            l
	 */
	public void setValue(String fieldName, Time value) {
		if (value == null) {
			setValue(fieldName, "");
		} else {
			SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
			setValue(fieldName, sdf.format(value));
		}
	}

	/**
	 * w肳ꂽtB[hRg[tB[hɒli[܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * 
	 * @param value
	 *            l
	 */
	public void setValue(String fieldName, Timestamp value) {
		if (value == null) {
			setValue(fieldName, "");
		} else {
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
			setValue(fieldName, sdf.format(value));
		}
	}

	/**
	 * w肳ꂽtB[h}bṽ[vindexŎw肳ꂽʒuɊi[܂B
	 * 
	 * @param fieldName
	 *            [vtB[h
	 * @param index
	 *            CfbNX
	 * @param fieldMapValue
	 *            tB[h}bvi[vɑΉtB[h}bvj
	 */
	public void setFieldMap(String fieldName, int index, FieldMap fieldMapValue) {
		checkFieldName(fieldName);
		if (!fieldMap.get(fieldName).getCtrl().getCtrlProcesser().isLoop()) {
			throw new RuntimeException("w肳tB[hɂ͂̃\bh͎gpł܂");
		}
		List<FieldMap> list = (List<FieldMap>) fieldMap.get(fieldName).getValue();
		list.set(index, fieldMapValue);
	}

	/**
	 * w肳ꂽtB[h}bṽ[v̍Ōɒǉ܂B
	 * 
	 * @param fieldName
	 *            [vtB[h
	 * @param fieldMapValue
	 *            tB[h}bvi[vɑΉtB[h}bvj
	 */
	public void addFieldMap(String fieldName, FieldMap fieldMapValue) {
		checkFieldName(fieldName);
		if (!fieldMap.get(fieldName).getCtrl().getCtrlProcesser().isLoop()) {
			throw new RuntimeException("w肳tB[hɂ͂̃\bh͎gpł܂");
		}
		List<FieldMap> list = (List<FieldMap>) fieldMap.get(fieldName).getValue();
		list.add(fieldMapValue);
	}

	/**
	 * w肳ꂽindexʒũtB[h}bṽ[v폜܂B
	 * 
	 * @param fieldName
	 *            [vtB[h
	 * @param index
	 *            폜sCfbNXi0N_j
	 */
	public void removeFieldMap(String fieldName, int index) {
		checkFieldName(fieldName);
		if (!fieldMap.get(fieldName).getCtrl().getCtrlProcesser().isLoop()) {
			throw new RuntimeException("w肳tB[hɂ͂̃\bh͎gpł܂");
		}
		List<FieldMap> list = (List<FieldMap>) fieldMap.get(fieldName).getValue();
		list.remove(index);
	}

	/**
	 * o^ĂStB[h}bvw肳ꂽ[vtB[h폜܂
	 * 
	 * @param fieldName
	 *            [vtB[h
	 */
	public void clearFieldMap(String fieldName) {
		checkFieldName(fieldName);
		if (!fieldMap.get(fieldName).getCtrl().getCtrlProcesser().isLoop()) {
			throw new RuntimeException("w肳tB[hɂ͂̃\bh͎gpł܂");
		}
		List<FieldMap> list = (List<FieldMap>) fieldMap.get(fieldName).getValue();
		list.clear();
	}

	/**
	 * Sf[^ɂ܂B
	 */
	public void clearAllValue() {

		Map<String, String> groupMap = createGroupMap(this);

		for (String fieldName : fieldMap.keySet()) {
			FieldItem fieldItem = fieldMap.get(fieldName);
			CtrlProcesser cp = fieldItem.getCtrl().getCtrlProcesser();
			if (cp.isInputCtrl() && !cp.isGroupItem()) {
				if (cp.isCheckCtrl()) {
					setValue(fieldName, false);
				} else {
					setValue(fieldName, "");
				}
			} else if (cp.isSwitch()) {
				setValue(fieldName, false);
			} else if (cp.isLoop()) {
				clearFieldMap(fieldName);
			}
		}

		for (String fieldName : groupMap.keySet()) {
			setGroupValue(fieldName, "");
		}
	}

	// f[^擾 ////////////////////////////

	/**
	 * w肳ꂽtB[hRg[tB[hl擾܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * 
	 * @return value l
	 */
	public String getValueString(String fieldName) {
		checkFieldName(fieldName);
		if (fieldMap.get(fieldName).getCtrl().getCtrlProcesser().isLoop()) {
			throw new RuntimeException("w肳tB[hɂ͂̃\bh͎gpł܂");
		}
		return (String) fieldMap.get(fieldName).getValue();
	}

	/**
	 * w肳ꂽtB[hɑΉO[vtB[h̒l擾܂B<BR>
	 * WI{^Ŏgp܂B
	 * 
	 * @param fieldName
	 *            tB[hiO[ṽtB[hłTtBbNXOj
	 * 
	 * @return l
	 */
	public String getGroupValue(String fieldName) {
		return getGroupValueMain(this, fieldName, 0);
	}

	/**
	 * w肳ꂽtB[hRg[tB[hl擾܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * 
	 * @return value l
	 */
	private String getGroupValueMain(FieldMap fieldMap, String fieldName, int groupLevel) {

		String[] fieldNames = fieldMap.getFieldNames();
		for (String name : fieldNames) {
			FieldItem fieldItem = fieldMap.getFieldItem(name);
			if (fieldItem.getCtrl().getCtrlProcesser().isGroupItem()) {
				if (fieldName.equals(fieldItem.getCtrl().getBaseName()) && groupLevel == fieldItem.getCtrl().getGroupLevel()) {
					if (fieldItem.isChecked()) {
						return (String) fieldItem.getValue();
					}
				}
			}
			if (fieldItem.getCtrl().getCtrlProcesser().isLoop()) {
				List<FieldMap> loopList = (List<FieldMap>) fieldItem.getValue();
				for (FieldMap childMap : loopList) {
					String ret = getGroupValueMain(childMap, fieldName, groupLevel + 1);
					if (ret.length() > 0) {
						return ret;
					}
				}
			}
		}
		return "";
	}

	/**
	 * w肳ꂽtB[hRg[tB[hl擾܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * 
	 * @return value l
	 */
	public String[] getValueStrings(String fieldName) {
		checkFieldName(fieldName);
		if (fieldMap.get(fieldName).getCtrl().getCtrlProcesser().isLoop()) {
			throw new RuntimeException("w肳tB[hɂ͂̃\bh͎gpł܂");
		}
		if (getValueString(fieldName).length() <= 0) {
			return new String[0];
		}
		return getValueString(fieldName).split("\\t");
	}

	/**
	 * w肳ꂽtB[hRg[tB[hbooleanl擾܂B<BR>
	 * i[Ălbooleanlł͖false߂܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @return value l
	 */
	public boolean getValueBoolean(String fieldName) {
		checkFieldName(fieldName);
		if (fieldMap.get(fieldName).getCtrl().getCtrlProcesser().isLoop()) {
			throw new RuntimeException("w肳tB[hɂ͂̃\bh͎gpł܂");
		}
		Object booleanValue = fieldMap.get(fieldName).getValue();
		if (!(booleanValue instanceof Boolean)) {
			return false;
		}
		return (Boolean) booleanValue;
	}

	/**
	 * w肳ꂽtB[hRg[tB[hInteger擾܂B<BR>
	 * i[Ălintlł͖null߂܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @return IntegerIuWFNg
	 */
	public Integer getValueIntObject(String fieldName) {
		String value = getValueString(fieldName);
		return PirkaFormatUtil.parseInteger(value);
	}

	/**
	 * w肳ꂽtB[hRg[tB[hintl擾܂B<BR>
	 * i[Ălintlł͖0߂܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @return intl
	 */
	public int getValueInt(String fieldName) {
		return getValueInt(fieldName, 0);
	}

	/**
	 * w肳ꂽtB[hRg[tB[hintl擾܂B<BR>
	 * i[Ălintlł͖defaultValue߂܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @param defaultValue
	 *            ftHgl
	 * @return intl
	 */
	public int getValueInt(String fieldName, int defaultValue) {

		String value = getValueString(fieldName);

		if (value == null) {
			return defaultValue;
		}

		Integer intValue = PirkaFormatUtil.parseInteger(value);
		if (intValue == null) {
			return defaultValue;
		}
		return intValue;
	}

	/**
	 * w肳ꂽtB[hRg[tB[hLongIuWFNg擾܂B<BR>
	 * i[Ăllonglł͖null߂܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @return Long
	 */
	public Long getValueLongObject(String fieldName) {
		String value = getValueString(fieldName);
		return PirkaFormatUtil.parseLong(value);
	}

	/**
	 * w肳ꂽtB[hRg[tB[hlongl擾܂B<BR>
	 * i[Ăllonglł͖0߂܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @return longl
	 */
	public long getValueLong(String fieldName) {
		return getValueLong(fieldName, 0);
	}

	/**
	 * w肳ꂽtB[hRg[tB[hlongl擾܂B<BR>
	 * i[Ăllonglł͖defaultValue߂܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @param defaultValue
	 *            ftHgl
	 * @return longl
	 */
	public long getValueLong(String fieldName, long defaultValue) {

		String value = getValueString(fieldName);

		if (value == null) {
			return defaultValue;
		}

		Long longValue = PirkaFormatUtil.parseLong(value);
		if (longValue == null) {
			return defaultValue;
		}
		return longValue;
	}

	/**
	 * w肳ꂽtB[hRg[tB[hBigDecimalIuWFNg擾܂B<BR>
	 * i[Ăllł͖null߂܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @return BigDecimaluWFNg
	 */
	public BigDecimal getValueBigDecimal(String fieldName) {
		String value = getValueString(fieldName);
		return PirkaFormatUtil.parseBigDecimal(value);
	}

	/**
	 * w肳ꂽtB[hRg[tB[hjava.sql.DateIuWFNg擾܂B<BR>
	 * i[Ăltł͖null߂܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @return java.sql.DateIuWFNg
	 */
	public Date getValueDate(String fieldName) {
		String value = getValueString(fieldName);
		return PirkaFormatUtil.parseDate(value);
	}

	/**
	 * w肳ꂽtB[hRg[tB[hjava.sql.TimeIuWFNg擾܂B<BR>
	 * i[Ălł͖null߂܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @return java.sql.TimeIuWFNg
	 */
	public Time getValueTime(String fieldName) {
		String value = getValueString(fieldName);
		return PirkaFormatUtil.parseTime(value);
	}

	/**
	 * w肳ꂽtB[hRg[tB[hjava.sql.TimestampIuWFNg擾܂B<BR>
	 * i[Ăltł͖null߂܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @return java.sql.TimeIuWFNg
	 */
	public Timestamp getValueTimestamp(String fieldName) {
		String value = getValueString(fieldName);
		return PirkaFormatUtil.parseTimestamp(value);
	}

	/**
	 * [vtB[hɊi[ĂtB[h}bv擾܂B
	 * 
	 * @param fieldName
	 *            [vtB[h
	 * @return tB[h}bv
	 */
	public int getFieldMapSize(String fieldName) {
		checkFieldName(fieldName);
		if (!fieldMap.get(fieldName).getCtrl().getCtrlProcesser().isLoop()) {
			throw new RuntimeException("w肳tB[hɂ͂̃\bh͎gpł܂");
		}
		List<FieldMap> list = (List<FieldMap>) fieldMap.get(fieldName).getValue();
		return list.size();
	}

	/**
	 * [vtB[hɊi[ĂtB[h}bv擾܂B
	 * 
	 * @param fieldName
	 *            [vtB[h
	 * @param index
	 *            CfbNX
	 * @return tB[h}bv
	 */
	public FieldMap getFieldMap(String fieldName, int index) {
		checkFieldName(fieldName);
		if (!fieldMap.get(fieldName).getCtrl().getCtrlProcesser().isLoop()) {
			throw new RuntimeException("w肳tB[hɂ͂̃\bh͎gpł܂");
		}
		List<FieldMap> list = (List<FieldMap>) fieldMap.get(fieldName).getValue();
		return list.get(index);
	}

	/**
	 * [vɊi[ĂtB[h}bv̔z擾܂B
	 * 
	 * @param fieldName
	 *            [vtB[h
	 * @return tB[h}bvz
	 */
	public FieldMap[] getFieldMaps(String fieldName) {
		checkFieldName(fieldName);
		if (!fieldMap.get(fieldName).getCtrl().getCtrlProcesser().isLoop()) {
			throw new RuntimeException("w肳tB[hɂ͂̃\bh͎gpł܂");
		}
		List<FieldMap> list = (List<FieldMap>) fieldMap.get(fieldName).getValue();
		return (FieldMap[]) list.toArray(new FieldMap[0]);
	}

	/**
	 * w肳ꂽtB[hRg[tB[hit@CAbv[hjInputStream擾܂B<BR>
	 * ͎InputStream擾łȂƂnullԂ܂B<BR>
	 * oXg[̓N[YȂ΃t[[NIɃN[Y܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * 
	 * @return InputStreamIuWFNg
	 */
	public InputStream getInputStream(String fieldName) throws IOException {
		checkFieldName(fieldName);
		long fileNo = fieldMap.get(fieldName).getFileNo();
		if (fileNo > 0) {
			return PirkaUploadManager.getInputStream(fileNo);
		}
		return null;
	}

	// Rg[\bh////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	/**
	 * PƂŎgp鑮izzz=bbbł͂Ȃ`jݒ肵܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @param optionName
	 *            
	 */
	public void setOption(String fieldName, String optionName) {
		setOption(fieldName, optionName, null);
	}

	/**
	 * ݒ肵܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @param optionName
	 *            
	 * @param optionValue
	 *            l nullw肷Ƒ݂̂̒PƑƂȂ܂
	 */
	public void setOption(String fieldName, String optionName, String optionValue) {
		checkFieldName(fieldName);

		if ("name".equalsIgnoreCase(optionName)) {
			throw new RuntimeException("name͕ύXł܂");
		}
		if ("type".equalsIgnoreCase(optionName)) {
			throw new RuntimeException("type͕ύXł܂");
		}
		if ("value".equalsIgnoreCase(optionName)) {
			throw new RuntimeException("value͕ύXł܂Bf[^\bhgpĂB");
		}

		Map<String, String> map = fieldMap.get(fieldName).getCtrl().getOptionMap();
		map.put(optionName.toLowerCase(), optionValue);
	}

	/**
	 * }bvݒ肵܂B}bṽL[͑Al͑lƂȂ܂B<BR>
	 * ɉp啶gpƋIɉpɒu܂B<BR>
	 * ܂Aname,type,value݂ĂIɍ폜܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @param optionMap
	 *            IvVl
	 */
	public void setOption(String fieldName, Map<String, String> optionMap) {
		optionMap.remove("name");
		optionMap.remove("type");
		optionMap.remove("value");

		String[] keys = optionMap.keySet().toArray(new String[0]);
		for (String key : keys) {
			String toLowKey = key.toLowerCase();
			if (!key.equals(toLowKey)) {
				String value = optionMap.get(key);
				optionMap.remove(key);
				optionMap.put(key, value);
			}
		}

		fieldMap.get(fieldName).getCtrl().setOptionMap(optionMap);
	}

	/**
	 * ݂Ă邩̊mFsȂ܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @param optionName
	 *            
	 * @return true=݂Ă
	 */
	public boolean isOptionExist(String fieldName, String optionName) {
		checkFieldName(fieldName);
		return fieldMap.get(fieldName).getCtrl().getOptionMap().containsKey(optionName.toLowerCase());
	}

	/**
	 * l擾܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @param optionName
	 *            
	 * @return l o^ĂȂ݂͑̂̒PƑnull
	 */
	public String getOption(String fieldName, String optionName) {
		checkFieldName(fieldName);
		return fieldMap.get(fieldName).getCtrl().getOptionMap().get(optionName.toLowerCase());
	}

	/**
	 * }bv擾܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @return }bv
	 */
	public Map<String, String> getOption(String fieldName) {
		checkFieldName(fieldName);
		return fieldMap.get(fieldName).getCtrl().getOptionMap();
	}

	/**
	 * 폜܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @param optionName
	 *            폜鑮
	 */
	public void clearOption(String fieldName, String optionName) {
		checkFieldName(fieldName);
		fieldMap.get(fieldName).getCtrl().getOptionMap().remove(optionName.toLowerCase());
	}

	/**
	 * ݒ肳Ă鑮Sč폜܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 */
	public void clearOption(String fieldName) {
		checkFieldName(fieldName);
		fieldMap.get(fieldName).getCtrl().getOptionMap().clear();
	}

	/**
	 * IꗗXgݒ肵܂B<BR>
	 * SELCET^OŎgp܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @param selectList
	 *            IꗗXg
	 */
	public void setSelectList(String fieldName, SelectList selectList) {
		checkFieldName(fieldName);
		fieldMap.get(fieldName).getCtrl().setSelectList(selectList);
	}

	/**
	 * IꗗXg擾܂B<BR>
	 * SELCET^OŎgp܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @return IꗗXg
	 */
	public SelectList getSelectList(String fieldName) {
		checkFieldName(fieldName);
		return fieldMap.get(fieldName).getCtrl().getSelectList();
	}

	/**
	 * IꗗXg̑Sڂ폜܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 */
	public void clearSelectList(String fieldName) {
		checkFieldName(fieldName);
		SelectList selectList = fieldMap.get(fieldName).getCtrl().getSelectList();
		if (selectList != null) {
			selectList.clear();
		}
	}

	/**
	 * G[tOݒ肵܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @param errorFlag
	 *            G[tO
	 */
	public void setError(String fieldName, boolean errorFlag) {
		checkFieldName(fieldName);
		fieldMap.get(fieldName).setErrorFlag(errorFlag);
	}

	/**
	 * G[ԂmF܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @return true=G[
	 */
	public boolean isError(String fieldName) {
		checkFieldName(fieldName);
		return fieldMap.get(fieldName).isErrorFlag();
	}

	/**
	 * \tH[}bgݒ肵܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @param fieldFormat
	 *            tH[}bg
	 */
	public void setFormat(String fieldName, FieldFormat fieldFormat) {
		checkFieldName(fieldName);
		if (!fieldMap.get(fieldName).getCtrl().getCtrlProcesser().isFormatCtrl()) {
			throw new RuntimeException("w肳tB[hɂ͂̃\bh͎gpł܂");
		}
		fieldMap.get(fieldName).getCtrl().setFormat(fieldFormat);
	}

	/**
	 * \tH[}bg擾܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @return tH[}bg
	 */
	public FieldFormat getFormat(String fieldName) {
		checkFieldName(fieldName);
		if (!fieldMap.get(fieldName).getCtrl().getCtrlProcesser().isFormatCtrl()) {
			throw new RuntimeException("w肳tB[hɂ͂̃\bh͎gpł܂");
		}
		return fieldMap.get(fieldName).getCtrl().getFormat();
	}

	/**
	 * \tH[}bg폜܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 */
	public void clearFormat(String fieldName) {
		checkFieldName(fieldName);
		if (!fieldMap.get(fieldName).getCtrl().getCtrlProcesser().isFormatCtrl()) {
			throw new RuntimeException("w肳tB[hɂ͂̃\bh͎gpł܂");
		}
		fieldMap.get(fieldName).getCtrl().setFormat(null);
	}

	/**
	 * WEBꕶϊ@\ݒ肵܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @param safeFlag
	 *            true=EBꕶϊsȂ
	 */
	public void setSafeMode(String fieldName, boolean safeFlag) {
		checkFieldName(fieldName);
		fieldMap.get(fieldName).getCtrl().setWebSafe(safeFlag);
	}

	/**
	 * WEBꕶϊ@\ݒmF܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @return true=EBꕶϊsȂ
	 */
	public boolean isSafeMode(String fieldName) {
		checkFieldName(fieldName);
		return fieldMap.get(fieldName).getCtrl().isWebSafe();
	}

	/**
	 * ^Oʂ̎ws܂B<BR>
	 * DIV,SPAN^OŎgp܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @param tagEffective
	 *            true=^O\Bfalse=^O\ȂiJn^OI^Oɋ܂ꂽHTML͕\j
	 */
	public void setTagEffective(String fieldName, boolean tagEffective) {
		checkFieldName(fieldName);
		fieldMap.get(fieldName).getCtrl().setTagEffective(tagEffective);
	}

	/**
	 * ^Oʂ̎擾s܂B<BR>
	 * DIV,SPAN^OŎgp܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @return true=^O\Bfalse=^O\ȂiJn^OI^Oɋ܂ꂽHTML͕\j
	 */
	public boolean isTagEffective(String fieldName) {
		checkFieldName(fieldName);
		return fieldMap.get(fieldName).getCtrl().isTagEffective();
	}

	/**
	 * O[vx̎ws܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @param groupLevel
	 *            O[vx
	 */
	public void setGroupLoopLevel(String fieldName, int groupLevel) {
		checkFieldName(fieldName);
		fieldMap.get(fieldName).getCtrl().setGroupLevel(groupLevel);
	}

	/**
	 * O[vx̎擾s܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @return O[vx
	 */
	public int getGroupLevel(String fieldName) {
		checkFieldName(fieldName);
		return fieldMap.get(fieldName).getCtrl().getGroupLevel();
	}

	/**
	 * TtBbNXtws܂B<BR>
	 * iID,for̃TtBbNXtw/[vLABEL^OƂɊ֘ARg[Ŏgpj
	 * 
	 * @param fieldName
	 *            tB[h
	 * @param suffixFlag
	 *            true=ID,for̒lɃ[vTtBbNXt
	 */
	public void setSuffixFlag(String fieldName, boolean suffixFlag) {
		checkFieldName(fieldName);
		fieldMap.get(fieldName).getCtrl().setSuffix(suffixFlag);
	}

	/**
	 * C[WIuWFNg̐ݒs܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @param image
	 *            C[W
	 */
	public void setImage(String fieldName, PirkaImage image) {
		checkFieldName(fieldName);
		fieldMap.get(fieldName).getCtrl().setImage(image);
	}

	/**
	 * `FbNsݒ肵܂B<BR>
	 * Tu~bg{^̃ANV\bhĂяoRg[tB[hȊOɐݒ肵ĂłB
	 * 
	 * @param fieldName
	 *            tB[h
	 * @param autoCheckFlag
	 *            true=`FbNsȂ
	 */
	public void setAutoCheck(String fieldName, boolean autoCheckFlag) {
		checkFieldName(fieldName);
		fieldMap.get(fieldName).getCtrl().setAutoCheck(autoCheckFlag);
	}

	/**
	 * ȃtB[h̐ݒs܂B<BR>
	 * ̐ݒsȂȂ΃tB[hp܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @param officialFieldName
	 *            ȃtB[h
	 */
	public void setOfficialFieldName(String fieldName, String officialFieldName) {
		checkFieldName(fieldName);
		fieldMap.get(fieldName).getCtrl().setOfficialFieldName(officialFieldName);
	}

	/**
	 * ȃtB[h̎擾s܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @return ȃtB[h
	 */
	public String getOfficialFieldName(String fieldName) {
		checkFieldName(fieldName);
		return fieldMap.get(fieldName).getCtrl().getOfficialFieldName();
	}

	// ȉgp֎~\bh ///////////////////////////////////////////////////////////////////////////////////////////////////////////

	/**
	 * tB[h}bv胋[vKwȂ[g}bv쐬܂B
	 * 
	 * @return [g}bv
	 */
	@Deprecated
	public Map<String, FieldItem> getRootMap() {
		Map<String, FieldItem> rootMap = new HashMap<String, FieldItem>();
		remakeRootMap(rootMap, fieldMap, "");
		return rootMap;
	}

	/**
	 * [g}bv쐬̎又
	 * 
	 * @param map
	 *            tB[h}bv
	 * @param loopSuffix
	 *            X[vTbNX
	 */
	@Deprecated
	protected void remakeRootMap(Map<String, FieldItem> rootMap, HashMap<String, FieldItem> map, String loopSuffix) {
		for (String fieldName : map.keySet()) {

			FieldItem fieldItem = map.get(fieldName);
			rootMap.put(fieldName + loopSuffix, fieldItem);
			if (fieldItem.getCtrl().getCtrlProcesser().isLoop()) {
				Object object = fieldItem.getValue();
				if (object != null && object instanceof List) {
					List<FieldMap> list = (List<FieldMap>) object;

					for (int index = 0; index < list.size(); index++) {
						FieldMap childMap = (FieldMap) list.get(index);
						remakeRootMap(rootMap, childMap.fieldMap, loopSuffix + '$' + index);
					}
				}

			}

		}
	}

	/**
	 * ̃IuWFNg̃N[Ԃ܂B
	 * 
	 * @return ̃IuWFNg̃N[
	 */
	@Deprecated
	public Object clone() {

		FieldMap newMap = new FieldMap();
		for (String key : fieldMap.keySet()) {
			FieldItem fieldItem = fieldMap.get(key);

			if (fieldItem.getValue() != null && fieldItem.getValue() instanceof List) {
				List<FieldMap> list = new ArrayList();
				for (FieldMap fieldMap : (List<FieldMap>) fieldItem.getValue()) {
					list.add((FieldMap) fieldMap.clone());
				}
				newMap.setFieldItem(key, new FieldItem(list, fieldItem.isChecked(), fieldItem.getFileNo(), (HtmlCtrlParts) fieldItem.getCtrl().clone(), fieldItem.getFormat(), fieldItem
						.getLoopDeepLevel()));
			} else {
				newMap.setFieldItem(key, new FieldItem(fieldItem.getValue(), fieldItem.isChecked(), fieldItem.getFileNo(), (HtmlCtrlParts) fieldItem.getCtrl().clone(), fieldItem.getFormat(),
						fieldItem.getLoopDeepLevel()));
			}
		}
		return newMap;
	}

	/**
	 * w肳ꂽtB[hɑ݂Ă邩̊mF܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @return true=݂Ă
	 */
	@Deprecated
	public boolean containsKey(String fieldName) {
		return fieldMap.containsKey(fieldName);
	}

	/**
	 * tB[ḧꗗԂ܂B
	 * 
	 * 
	 * @return tB[ḧꗗ
	 */
	@Deprecated
	public String[] getFieldNames() {
		return fieldMap.keySet().toArray(new String[0]);
	}

	/**
	 * tB[hACeݒ肵܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @param fieldItem
	 *            tB[hACe
	 */
	@Deprecated
	public void setFieldItem(String fieldName, FieldItem fieldItem) {
		fieldMap.put(fieldName, fieldItem);
	}

	/**
	 * tB[hACe擾܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @return tB[hACe
	 */
	@Deprecated
	public FieldItem getFieldItem(String fieldName) {
		return fieldMap.get(fieldName);
	}

	/**
	 * ǗĂtB[h}bṽ}bvIuWFNg擾܂B
	 * 
	 * @return tB[h}bṽ}bvIuWFNg
	 */
	@Deprecated
	Map<String, FieldItem> getMap() {
		return fieldMap;
	}

	/**
	 * tB[h}bvO[v}bv쐬܂B
	 * 
	 * @param fieldMap
	 *            tB[h}bv
	 * @return O[v}bv
	 */
	private static Map<String, String> createGroupMap(FieldMap fieldMap) {
		Map<String, String> groupMap = new HashMap<String, String>();
		createGroupMapMain(groupMap, fieldMap, 0);

		return groupMap;

	}

	/**
	 * O[v}bvC
	 * 
	 * @param groupMap
	 *            O[v}bv
	 * @param fieldMap
	 *            tB[h}bv
	 * @param groupLevel
	 *            O[vx
	 */
	private static void createGroupMapMain(Map<String, String> groupMap, FieldMap fieldMap, int groupLevel) {

		String[] fieldNames = fieldMap.getFieldNames();
		for (String fieldName : fieldNames) {
			FieldItem fieldItem = fieldMap.getFieldItem(fieldName);
			CtrlProcesser cp = fieldItem.getCtrl().getCtrlProcesser();
			if (cp.isGroupItem() && fieldItem.getCtrl().getGroupLevel() == groupLevel) {
				groupMap.put(fieldItem.getCtrl().getBaseName(), fieldItem.getCtrl().getBaseName());
			}

			if (cp.isLoop()) {
				List<FieldMap> list = (List<FieldMap>) fieldItem.getValue();
				for (FieldMap childFieldMap : list) {
					createGroupMapMain(groupMap, childFieldMap, groupLevel + 1);
				}

			}
		}

	}

	/**
	 * tB[htB[h}bvɑ݂邩`FbNsȂB<BR>
	 * ݂ȂƂ̓^CG[ƂȂB
	 * 
	 * @param tB[h
	 */
	private void checkFieldName(String fieldName) {
		if (!fieldMap.containsKey(fieldName)) {
			throw new RuntimeException("ȃtB[hw肳܂ " + fieldName);
		}
	}
}
