package jp.oarts.pirka.core.ctrl.proc.def;

import java.util.List;
import java.util.Map;

import jp.oarts.pirka.core.app.EntryPoint;
import jp.oarts.pirka.core.app.EntryPointIF;
import jp.oarts.pirka.core.ctrl.proc.CtrlProcesser;
import jp.oarts.pirka.core.err.ErrorMessageManagerIF;
import jp.oarts.pirka.core.err.ErrorMessageStocker;
import jp.oarts.pirka.core.general.HtmlCtrlParts;
import jp.oarts.pirka.core.general.HtmlParts;
import jp.oarts.pirka.core.general.WindowBaseData;
import jp.oarts.pirka.core.kernel.PirkaThreadMap;
import jp.oarts.pirka.core.util.field.FieldItem;

/**
 * A^OvZbT[
 * 
 * @author ito
 * 
 */
public class AProcesser extends CtrlProcesser {

	/**
	 * HTMLp[cXg̎^O̎qp[c̃^O鎞trueԂ
	 * 
	 * @return true=qp[c̃^O
	 */
	@Override
	public boolean isUseChild() {
		return false;
	}

	/**
	 * [v^O̎tureԂ
	 * 
	 * @return true=[v^O
	 */
	@Override
	public boolean isLoop() {
		return false;
	}

	/**
	 * XCb`^O̎tureԂ
	 * 
	 * @return true=XCb`^O
	 */
	public boolean isSwitch() {
		return false;
	}

	/**
	 * uEUœ͂sȂ^ÔƂrtueԂ
	 * 
	 * @return true=uEUœ
	 */
	@Override
	public boolean isInputCtrl() {
		return false;
	}

	/**
	 * uEU[̃ANVƂtureԂ
	 * 
	 * @return true=ANV
	 */
	@Override
	public boolean isActionCtrl() {
		return true;
	}

	/**
	 * O[sOsȂ^OiWI{^Ȃǁj̊evf̎tureԂ
	 * 
	 * @return true=O[sOvf
	 */
	public boolean isGroupItem() {
		return false;
	}

	/**
	 * `FbNsȂRg[̎tureԂ
	 * 
	 * @return true=`FbNsȂRg[
	 */
	public boolean isCheckCtrl() {
		return false;
	}

	/**
	 * tH[}bg\ȃRg[̎tureԂ
	 * 
	 * @return true=tH[}bg\ȃRg[
	 */
	public boolean isFormatCtrl() {
		return false;
	}

	/**
	 * f[^̃ZbgsȂ
	 * 
	 * @param data
	 */
	public void setValue(Object data, FieldItem fieldItem) {
		if (data == null || !(data instanceof String)) {
			throw new RuntimeException("w肳ꂽl̓Zbgł܂ StringIuWFNgZbgĂ");
		}

		fieldItem.setValue((String) data);
	}

	/**
	 * l͂
	 * 
	 * @param ctrl
	 *            Rg[
	 * @param list
	 *            ̃^OHTMLp[c̃Xg
	 */
	@Override
	public void analyzeInitValue(HtmlCtrlParts ctrl, List<HtmlParts> list) {
	}

	/**
	 * ^O쐬
	 * 
	 * @param ctrl
	 *            Rg[p[c
	 * @param loopSuffix
	 *            [vTtBbNX
	 * @param value
	 *            l
	 * @param checked
	 *            `FbNl
	 * @param windowBaseData
	 *            ʃf[^
	 * @param errorMessageManager
	 *            G[bZ[W}l[W[
	 * @param errorMessageStocker
	 *            G[bZ[WXgbJ[
	 * @param errorFlag
	 *            G[tO true=G[
	 * @return 쐬ꂽ^O
	 */
	public String makeStartTag(HtmlCtrlParts ctrl, String loopSuffix, String value, boolean checked, WindowBaseData windowBaseData, //
			ErrorMessageManagerIF errorMessageManager, ErrorMessageStocker errorMessageStocker, boolean errorFlag) {

		Map<String, String> optionMap = ctrl.getOptionMap();
		if (errorFlag) {
			optionMap = changeStyle(errorMessageManager.getNgLabelStyle(), optionMap);
		}
		StringBuilder sb = new StringBuilder();

		String href = ctrl.getOptionMap().get("href");
		if (href != null && href.length() == 0) {
			sb.append('<');
			sb.append(ctrl.getTagName());
			sb.append(createOptionString(ctrl.getTypeOption(), ctrl.getName() + loopSuffix, loopSuffix, optionMap, windowBaseData, ctrl.isSuffix()));
			sb.append(">");
		} else {
			sb.append('<');
			sb.append(ctrl.getTagName());
			sb.append(createOptionString(ctrl.getTypeOption(), ctrl.getName() + loopSuffix, loopSuffix, ctrl.getOptionMap(), ctrl.isSuffix()));
			sb.append(">");
		}

		return sb.toString();

	}

	/**
	 * }bv𕶎ɕϊ܂B
	 * 
	 * @param type
	 *            ^Cv
	 * @param name
	 *            ^O
	 * @param loopSuffix
	 *            [vTtBbNX
	 * @param optionMap
	 *            }bv
	 * @param isSuffix
	 *            TbtBbNXtO
	 * @return ϊꂽ
	 */
	protected String createOptionString(String type, String name, String loopSuffix, Map<String, String> optionMap, boolean isSuffix) {
		StringBuilder sb = new StringBuilder();

		if (type != null && type.length() > 0) {
			sb.append(" type=\"");
			sb.append(type);
			sb.append("\"");
		}

		if (name != null && name.length() > 0) {
			sb.append(" name=\"");
			sb.append(name);
			sb.append("\"");
		}

		for (String key : optionMap.keySet()) {
			if (!key.equalsIgnoreCase("type") && !key.equalsIgnoreCase("name")) {
				addOption(sb, optionMap, key, isSuffix, loopSuffix);
			}
		}

		return sb.toString();
	}

	/**
	 * }bv𕶎ɕϊ܂B
	 * 
	 * @param type
	 *            ^Cv
	 * @param name
	 *            ^O
	 * @param loopSuffix
	 *            [vTtBbNX
	 * @param optionMap
	 *            }bv
	 * @param windowBaseData
	 *            EChEx[Xf[^
	 * @param isSuffix
	 *            TbtBbNXtO
	 * @return ϊꂽ
	 */
	protected String createOptionString(String type, String name, String loopSuffix, Map<String, String> optionMap, WindowBaseData windowBaseData, boolean isSuffix) {
		EntryPointIF entryPoint = PirkaThreadMap.getEntryPointObjct();
		StringBuilder sb = new StringBuilder();

		if (type != null && type.length() > 0) {
			sb.append(" type=\"");
			sb.append(type);
			sb.append("\"");
		}

		if (name != null && name.length() > 0) {
			sb.append(" name=\"");
			sb.append(name);
			sb.append("\"");
		}

		sb.append(" href=\"");
		sb.append(entryPoint.getUrlAlias());
		sb.append('?');
		sb.append(EntryPoint.REQ_PIRKA_MARK);
		sb.append('=');
		sb.append(EntryPoint.REQ_LINK);
		sb.append('&');
		sb.append(name);
		sb.append('=');
		sb.append(EntryPoint.REQ_LINK);
		sb.append('&');
		sb.append(EntryPoint.REQ_INSTANCE);
		sb.append('=');
		sb.append(windowBaseData.getInstanceNo());
		sb.append('&');
		sb.append(EntryPoint.REQ_SERIALNO);
		sb.append('=');
		sb.append(windowBaseData.getSerialNo());
		sb.append("\"");

		for (String key : optionMap.keySet()) {
			if (!key.equalsIgnoreCase("type") && !key.equalsIgnoreCase("name") && !key.equalsIgnoreCase("href")) {
				addOption(sb, optionMap, key, isSuffix, loopSuffix);
			}
		}

		return sb.toString();
	}

}
