/* -*- Mode: c; c-basic-offset: 8; Coding: utf-8-unix -*- ;; */
/* $Id: piranham.c 2 2008-05-27 07:44:27Z mtaneda $	 */

/*
 * Copyright 2008 The piranha Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PIRANHA PROJECT ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE PIRANHA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the piranha Project.
 */

#include	<pthread.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<unistd.h>
#include	<arpa/inet.h>
#include	<sys/socket.h>
#include	<sys/types.h>
#include	"common.h"

ini_t          *ini = NULL;
log_t          *mlog = NULL;
int             listen_soc = -1;

ini_t          *init_piranham_ini(const char *path);
log_t          *init_piranham_log(void);
int             init_piranham_socket(void);

int 
main(int argc, char *argv[])
{
	pthread_t       sig_thread;

	mask_signal();

	ini = init_piranham_ini(PIRANHAM_INI_PATH);
	if (!ini)
	{
		goto ERROR;
	}
	mlog = init_piranham_log();
	if (!mlog)
	{
		goto ERROR;
	}
	listen_soc = init_piranham_socket();
	if (listen_soc == -1)
	{
		goto ERROR;
	}
	if (create_thread_pool())
	{
		goto ERROR;
	}
	if (create_commander())
	{
		goto ERROR;
	}
	sig_thread = create_signal_thread();
	if (sig_thread == 0)
	{
		goto ERROR;
	}
	pthread_join(sig_thread, NULL);

ERROR:
	finalize_all();
	return (0);
}

ini_t          *
init_piranham_ini(const char *path)
{
	return (ini_load(path, "\x0a", "=", '#'));
}

log_t          *
init_piranham_log(void)
{
	char           *path, *level;

	path = ini_refer_value_by_name(ini, NULL, "log_path");
	level = ini_refer_value_by_name(ini, NULL, "log_level");

	mlog = log_open(path);
	if (!mlog)
	{
		goto ERROR;
	}
	LOG_DEBUG("----> Start Server");

	return (mlog);
ERROR:
	return (NULL);
}

int 
init_piranham_socket(void)
{
	int             soc = -1, opt, err;
	char           *port;
	struct sockaddr_in sockaddr;

	port = ini_refer_value_by_name(ini, NULL, "server_port");
	if (!strtool_isdigit(port))
	{
		goto ERROR;
	}
	LOG_DEBUG("Initializing server socket ...");
	soc = socket(PF_INET, SOCK_STREAM, 0);
	if (soc == -1)
	{
		goto ERROR;
	}
	LOG_DEBUG("Setting socket options ...");
	opt = 1;
	err = setsockopt(soc, SOL_SOCKET, SO_REUSEADDR, (char *) &opt, sizeof(int));
	if (err)
	{
		goto ERROR;
	}
	LOG_DEBUG("Binding to port %s ...", port);
	memset((char *) &sockaddr, 0, sizeof(sockaddr));
	sockaddr.sin_family = AF_INET;
	sockaddr.sin_port = htons(atol(port));
	sockaddr.sin_addr.s_addr = htonl(INADDR_ANY);

	err = bind(soc, (struct sockaddr *) & sockaddr, sizeof(sockaddr));
	if (err)
	{
		goto ERROR;
	}
	LOG_DEBUG("Starting listener ...");
	err = listen(soc, SOMAXCONN);
	if (err)
	{
		goto ERROR;
	}
	return (soc);

ERROR:
	LOG_DEBUG("Failed");
	if (soc != -1)
	{
		close(soc);
	}
	return (-1);
}
