/* -*- Mode: c; c-basic-offset: 8; Coding: utf-8-unix -*- ;; */
/* $Id: proc.c 2 2008-05-27 07:44:27Z mtaneda $	 */

/*
 * Copyright 2008 The piranha Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PIRANHA PROJECT ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE PIRANHA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the piranha Project.
 */

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<unistd.h>
#include	<sys/types.h>
#include	<sys/wait.h>
#include	<sys/ptrace.h>
#include	<signal.h>
#include	"common.h"

#define	PS_CNT	20

struct procs
{
	pid_t           pid;
};

struct procs  **ps = NULL;
int             lastcmd = 0;

int             ps_calloc(const int count);
int             ps_free(void);

int 
ps_calloc(const int count)
{
	int             n;

	ps = (struct procs **) calloc(count + 1, sizeof(struct procs *));

	ps[count] = NULL;

	for (n = 0; n < count; n++)
	{
		ps[n] = (struct procs *) calloc(1, sizeof(struct procs));

		if (!ps[n])
		{
			goto ERROR;
		}
	}

	return (0);
ERROR:
	ps_free();
	return (1);
}

int 
ps_free(void)
{
	int             n;

	if (ps)
	{
		for (n = 0; ps[n]; n++)
		{
			free(ps[n]);
		}

		free(ps);

		ps = NULL;
	}
	return (0);
}

int 
proc_start(cmd_t * cmd)
{
	pid_t           pid = 0;
	int             n, err;

	if (!cmd || ps || (lastcmd && lastcmd != CMD_TYPE_STOP))
	{
		goto ERROR;
	}
	err = ps_calloc(PS_CNT);
	if (err)
	{
		goto ERROR;
	}
	lastcmd = CMD_TYPE_START;

	for (n = 0; n < PS_CNT; n++)
	{
		pid = fork();

		if (pid == 0)
		{
			child_process();

			exit(1);
		} else
		{
			ps[n]->pid = pid;
		}
	}

	return (0);
ERROR:
	return (1);
}

int 
proc_stop(cmd_t * cmd)
{
	int             n;
	int             stat;

	if (!cmd || !ps)
	{
		goto ERROR;
	}
	lastcmd = CMD_TYPE_STOP;

	for (n = 0; ps[n]; n++)
	{
		if (lastcmd == CMD_TYPE_PAUSE)
		{
			kill(ps[n]->pid, SIGCONT);
		}
		kill(ps[n]->pid, SIGINT);
		waitpid(ps[n]->pid, &stat, 0);
	}

	ps_free();

	return (0);
ERROR:
	return (1);
}

int 
proc_pause(cmd_t * cmd)
{
	int             n;

	if (!cmd || !ps ||
	(lastcmd && (lastcmd == CMD_TYPE_PAUSE || lastcmd == CMD_TYPE_STOP)))
	{
		goto ERROR;
	}
	lastcmd = CMD_TYPE_PAUSE;

	for (n = 0; ps[n]; n++)
	{
		kill(ps[n]->pid, SIGSTOP);
	}

	return (0);
ERROR:
	return (1);
}

int 
proc_resume(cmd_t * cmd)
{
	int             n;

	if (!cmd || !ps || lastcmd != CMD_TYPE_PAUSE)
	{
		goto ERROR;
	}
	lastcmd = CMD_TYPE_RESUME;

	for (n = 0; ps[n]; n++)
	{
		kill(ps[n]->pid, SIGCONT);
	}

	return (0);
ERROR:
	return (1);
}

int 
proc_data(cmd_t * cmd)
{
	if (!cmd)
	{
		goto ERROR;
	}
	return (0);
ERROR:
	return (1);
}

int 
proc_config(cmd_t * cmd)
{
	if (!cmd)
	{
		goto ERROR;
	}
	return (0);
ERROR:
	return (1);
}

int 
proc_scenario(cmd_t * cmd)
{
	if (!cmd)
	{
		goto ERROR;
	}
	return (0);
ERROR:
	return (1);
}
