/* -*- Mode: c; c-basic-offset: 8; Coding: utf-8-unix -*- ;; */
/* $Id: piranhad.h 2 2008-05-27 07:44:27Z mtaneda $	 */

/*
 * Copyright 2008 The piranha Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PIRANHA PROJECT ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE PIRANHA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the piranha Project.
 */

#ifndef	_inc_piranhad_h
#define	_inc_piranhad_h

#define	PIRANHAD_INI_PATH	"./piranhad.ini"

extern ini_t   *ini;
extern log_t   *dlog;
extern int      dsoc;
extern char   **environment;

#define	LOG_EMERG(...)		log_write(LOG_LVL_EMERG, dlog, __VA_ARGS__)
#define	LOG_ALERT(...)		log_write(LOG_LVL_ALERT, dlog, __VA_ARGS__)
#define	LOG_CRIT(...)		log_write(LOG_LVL_CRIT, dlog, __VA_ARGS__)
#define	LOG_ERR(...)		log_write(LOG_LVL_ERR, dlog, __VA_ARGS__)
#define	LOG_WARNING(...)	log_write(LOG_LVL_WARNING, dlog, __VA_ARGS__)
#define	LOG_NOTICE(...)		log_write(LOG_LVL_NOTICE, dlog, __VA_ARGS__)
#define	LOG_INFO(...)		log_write(LOG_LVL_INFO, dlog, __VA_ARGS__)
#define	LOG_DEBUG(...)		log_write(LOG_LVL_DEBUG, dlog, __VA_ARGS__)

#endif
