/* -*- Mode: c; c-basic-offset: 8; Coding: utf-8-unix -*- ;; */
/* $Id: strlist.h 2 2008-05-27 07:44:27Z mtaneda $	 */

/*
 * Copyright 2008 The piranha Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PIRANHA PROJECT ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE PIRANHA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the piranha Project.
 */

#ifndef	_inc_strlist_h
#define	_inc_strlist_h

typedef struct _str_array_ strlist_t;

extern strlist_t *strlist_create(void);
extern int      strlist_destroy(strlist_t * obj);

extern char    *strlist_pop(strlist_t * obj);
extern int      strlist_push(strlist_t * obj, const char *data);

extern char    *strlist_dequeue(strlist_t * obj);
extern int      strlist_queue(strlist_t * obj, const char *data);

extern int      strlist_add(strlist_t * obj, const char *data);
extern int      strlist_add_next(strlist_t * obj, const int offset, const char *data);
extern char    *strlist_get(const strlist_t * obj, const int offset);
extern char    *strlist_refer(const strlist_t * obj, const int offset);

extern strlist_t *strlist_dup(const strlist_t * obj);
extern strlist_t *strlist_ndup(const strlist_t * obj, const int len);

extern int      strlist_cat(strlist_t * dst, const strlist_t * src);
extern int      strlist_ncat(strlist_t * dst, const strlist_t * src, const int len);

extern char    *strlist_join_all(const strlist_t * obj, const char *sep);
extern char    *strlist_join(const strlist_t * obj, const char *sep, const int from, const int to);

extern int      strlist_is_exist(const strlist_t * obj, const char *data);
extern int      strlist_get_offset(const strlist_t * obj, const char *data);
extern int      strlist_len(const strlist_t * obj);

#endif
