/* -*- Mode: c; c-basic-offset: 8; Coding: utf-8-unix -*- ;; */
/* $Id: sem.c 2 2008-05-27 07:44:27Z mtaneda $	 */

/*
 * Copyright 2008 The piranha Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PIRANHA PROJECT ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE PIRANHA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the piranha Project.
 */

#include	<stdio.h>
#include	<stdlib.h>
#include	<unistd.h>
#include	<errno.h>
#include	<sys/types.h>
#include	<sys/sem.h>
#include	<sys/ipc.h>
#include	"sem.h"

#ifndef	Mac
union semun
{
	int             val;
	struct semid_ds *buf;
	unsigned short *array;
	struct seminfo *__buf;
};
#endif

struct semaphore
{
	int             sid;
};

sem_t          *
sem_create(const char *path)
{
	sem_t          *obj = NULL;
	union semun     arg;

	obj = (sem_t *) calloc(1, sizeof(sem_t));
	if (!obj)
	{
		goto ERROR;
	}
	obj->sid = semget(ftok(path, 0), 1, 0666 | IPC_CREAT | IPC_EXCL);
	if (obj->sid >= 0)
	{
		arg.val = 1;
		if (semctl(obj->sid, 0, SETVAL, arg) == -1)
		{
			goto ERROR;
		}
		sem_unlock(obj);
	} else if (errno == EEXIST)
	{
		obj->sid = semget(ftok(path, 0), 1, 0666);
		if (obj->sid < 0)
		{
			goto ERROR;
		}
	} else
	{
		goto ERROR;
	}

	return (obj);
ERROR:
	sem_destroy(obj);
	return (NULL);
}

void 
sem_destroy(sem_t * obj)
{
	if (obj)
	{
		free(obj);
	}
}

int 
sem_lock(sem_t * obj)
{
	struct sembuf   sb;

	if (!obj)
	{
		goto ERROR;
	}
	sb.sem_num = 0;
	sb.sem_op = -1;
	sb.sem_flg = SEM_UNDO;
	if (semop(obj->sid, &sb, 1) == -1)
	{
		goto ERROR;
	}
	return (0);
ERROR:
	return (1);
}

int 
sem_unlock(sem_t * obj)
{
	struct sembuf   sb;
	union semun     arg;

	if (!obj)
	{
		goto ERROR;
	}
	if (semctl(obj->sid, 0, GETVAL, arg) <= 0)
	{
		sb.sem_num = 0;
		sb.sem_op = 1;
		sb.sem_flg = SEM_UNDO;

		if (semop(obj->sid, &sb, 1) == -1)
		{
			goto ERROR;
		}
	}
	return (0);
ERROR:
	return (1);
}
