/* -*- Mode: c; c-basic-offset: 8; Coding: utf-8-unix -*- ;; */
/* $Id: pairlist.h 2 2008-05-27 07:44:27Z mtaneda $	 */

/*
 * Copyright 2008 The piranha Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PIRANHA PROJECT ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE PIRANHA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the piranha Project.
 */

#ifndef	_inc_pairlist_h
#define	_inc_pairlist_h

typedef struct pairlist pairlist_t;

extern pairlist_t *pairlist_create(void);
extern int      pairlist_destroy(pairlist_t * obj);

extern int
                pairlist_pop(pairlist_t * obj, char **name, char **value);
extern int
                pairlist_push(pairlist_t * obj, const char *name, const char *value);

extern int      pairlist_dequeue(pairlist_t * obj, char **name, char **value);
extern int      pairlist_queue(pairlist_t * obj, const char *name, const char *value);

extern int
                pairlist_add(pairlist_t * obj, const char *name, const char *value);

extern int
                pairlist_get(const pairlist_t * obj, const int offset, char **name, char **value);
extern char    *
                pairlist_get_value_by_name(const pairlist_t * obj, const char *name);
extern char    *
                pairlist_get_name_by_value(const pairlist_t * obj, const char *value);

extern int
                pairlist_refer(const pairlist_t * obj, const int offset, char **name, char **value);
extern char    *
                pairlist_refer_value_by_name(const pairlist_t * obj, const char *name);
extern char    *
                pairlist_refer_name_by_value(const pairlist_t * obj, const char *value);

extern pairlist_t *pairlist_dup(const pairlist_t * obj);
extern pairlist_t *pairlist_ndup(const pairlist_t * obj, const int len);

extern int      pairlist_cat(pairlist_t * dst, const pairlist_t * src);
extern int      pairlist_ncat(pairlist_t * dst, const pairlist_t * src, const int len);

extern int      pairlist_del_by_name(pairlist_t * obj, const char *name);

extern int
                pairlist_replace_value_by_name(pairlist_t * obj, const char *name, const char *value);

extern int      pairlist_is_exist(const pairlist_t * obj, const char *name);
extern int      pairlist_len(const pairlist_t * obj);

#endif
