/* -*- Mode: c; c-basic-offset: 8; Coding: utf-8-unix -*- ;; */
/* $Id: debug.c 2 2008-05-27 07:44:27Z mtaneda $	 */

/*
 * Copyright 2008 The piranha Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PIRANHA PROJECT ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE PIRANHA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the piranha Project.
 */

#include	<stdio.h>
#include	<ctype.h>

int 
debug_print_hex(FILE * fd, const char *data, const int len)
{
	int             cnt, n;
	int             width = 16;

	if (fd < 0 || !data || len < 1)
	{
		goto ERROR;
	}
	for (cnt = 0; cnt < len; cnt += width)
	{
		/* fprintf(fd, "%8p: ", (data+cnt)); */
		fprintf(fd, "0x%04x: ", cnt);
		/* fprintf(fd, "%04d: ", cnt); */

		for (n = 0; n < width; n++)
		{
			if (cnt + n >= len)
			{
				fprintf(fd, "  ");
			} else
			{
				fprintf(fd, "%02x", 0xFF & *(data + cnt + n));
			}

			if (n && !((n + 1) % 4))
			{
				fprintf(fd, " ");
			}
		}

		fprintf(fd, "\t");

		for (n = 0; n < width; n++)
		{
			if (cnt + n >= len)
			{
				fprintf(fd, " ");
			}
			/*
			 * else if(isprint(*(data+cnt+n)) &&
			 * !isspace(*(data+cnt+n)))
			 */
			else if (isprint(*(data + cnt + n)) && *(data + cnt + n) != '\t')
			{
				fprintf(fd, "%c", *(data + cnt + n));
			} else
			{
				fprintf(fd, ".");
			}
		}

		fprintf(fd, "\n");
	}

	return (0);
ERROR:
	return (1);
}
