/* -*- Mode: c; c-basic-offset: 8; Coding: utf-8-unix -*- ;; */
/* $Id: cmdlist.c 2 2008-05-27 07:44:27Z mtaneda $	 */

/*
 * Copyright 2008 The piranha Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PIRANHA PROJECT ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE PIRANHA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the piranha Project.
 */

#include	<stdio.h>
#include	<stdlib.h>
#include	"dlist.h"
#include	"cmd.h"
#include	"cmdlist.h"

struct cmdlist
{
	dlist_t        *dlist;
};

void            cmd_free(void *data);

cmdlist_t      *
cmdlist_create(void)
{
	cmdlist_t      *obj = NULL;

	obj = (cmdlist_t *) calloc(1, sizeof(cmdlist_t));
	if (!obj)
	{
		goto ERROR;
	}
	obj->dlist = dlist_create();
	if (!obj->dlist)
	{
		goto ERROR;
	}
	return (obj);
ERROR:
	cmdlist_destroy(obj);
	return (NULL);
}

int 
cmdlist_destroy(cmdlist_t * obj)
{
	if (!obj)
	{
		goto ERROR;
	}
	dlist_destroy(obj->dlist, cmd_free);

	free(obj);

	return (0);
ERROR:
	return (1);
}

void 
cmd_free(void *data)
{
	struct cmd     *obj = (struct cmd *) data;

	cmd_destroy(obj);
}

int 
cmdlist_queue(cmdlist_t * obj, const cmd_t * cmd)
{
	cmd_t          *tmp = NULL;
	int             err;

	if (!obj || !cmd)
	{
		goto ERROR;
	}
	tmp = cmd_dup(cmd);
	if (!tmp)
	{
		goto ERROR;
	}
	err = dlist_queue(obj->dlist, (void *) tmp);
	if (err)
	{
		goto ERROR;
	}
	return (0);
ERROR:
	cmd_destroy(tmp);
	return (1);
}

cmd_t          *
cmdlist_dequeue(cmdlist_t * obj)
{
	if (!obj)
	{
		goto ERROR;
	}
	return ((cmd_t *) dlist_dequeue(obj->dlist));
ERROR:
	return (NULL);
}
