/* -*- Mode: c; c-basic-offset: 8; Coding: utf-8-unix -*- ;; */
/* $Id: cmd.h 2 2008-05-27 07:44:27Z mtaneda $	 */

/*
 * Copyright 2008 The piranha Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PIRANHA PROJECT ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE PIRANHA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the piranha Project.
 */

#ifndef	_inc_cmd_h
#define	_inc_cmd_h

typedef struct cmd cmd_t;

#define	CMD_TYPE_START		0x01
#define	CMD_TYPE_STOP		0x02
#define	CMD_TYPE_PAUSE		0x03
#define	CMD_TYPE_RESUME		0x04
#define	CMD_TYPE_DATA		0x05
#define	CMD_TYPE_CONFIG		0x06
#define	CMD_TYPE_SCENARIO	0x07

extern cmd_t   *
                cmd_create(void);
extern int
                cmd_destroy(cmd_t * obj);

extern int
                cmd_set_type(cmd_t * obj, const int type);
extern int
                cmd_set_header(cmd_t * obj, const char *name, const char *value);
extern int
                cmd_set_body(cmd_t * obj, const char *body, const int size);

extern int
                cmd_get_type(const cmd_t * obj);
extern char    *
                cmd_refer_header_value_by_name(const cmd_t * obj, const char *name);
extern char    *
                cmd_get_header_value_by_name(const cmd_t * obj, const char *name);
extern int
                cmd_refer_body(const cmd_t * obj, char **body);
extern int
                cmd_get_body(const cmd_t * obj, char **body);

extern char    *
                cmd_to_str_type(const cmd_t * obj);
extern char    *
                cmd_to_str_header(const cmd_t * obj);

extern cmd_t   *
                cmd_dup(const cmd_t * obj);

extern int
                cmd_write(int fd, const cmd_t * obj);
extern cmd_t   *
                cmd_read(int fd);

#endif
