# 汎用関数
require 'pathname'
require 'cgisup'


module PinkyBlog
	HTML_ESC = {
		'&' => '&amp;',
		'"' => '&quot;',
		'<' => '&lt;',
		'>' => '&gt;'
	}
	
  # from http://jp.rubyist.net/magazine/?0010-CodeReview#l28
	def self.escape_html(str)
		table = HTML_ESC   # optimize
		str.gsub(/[&"<>]/n) {|s| table[s] }
	end
	
	def self.unescape_html(html)
		CGI.unescapeHTML(html)
	end

	
	def self.encode_url(url)
		CGI.escape(url)
	end
	
	def self.decode_url(encoded_url)
		CGI.unescape(encoded_url)
	end

	
	TAG_ENCODING_TABLE = ['+/=', '-._']
	# Base64エンコード＋URIに使える記号に置換
	def self.encode_tag(str)
		return [str].pack('m*').gsub(/\r|\n/, '').tr(TAG_ENCODING_TABLE[0], TAG_ENCODING_TABLE[1])
	end
	
	# ref:: encode_tag
 	def self.decode_tag(encoded)
		return encoded.tr(TAG_ENCODING_TABLE[1], TAG_ENCODING_TABLE[0]).unpack('m*')[0]
	end
	
	# to HTTP query_string (return: String or nil)
	def self.tags_to_query(tags)
		if tags.empty? then
			return nil
		else
			buf = []
			tags.each_with_index do |tag, i|
				buf << "tags_#{i}=#{self.encode_tag(tag)}"
			end
			return buf.join('&')
		end
	end

	
	BOM_PATTERN = /^\xef\xbb\xbf/
	# UTF-8文字列の先頭にBOMがあった場合、これを削除
	def self.slice_bom(utf8str)
		return utf8str.sub(BOM_PATTERN, '')
	end
	
	# 指定したファイルをテキストモードで読み込む（BOMも削除）
	# 何らかの原因で読み込めない場合にはnilを返す
	def self.read_text(path)
		path = Pathname.new(path.to_s) unless path.is_a?(Pathname)
		
		if path.readable? then
			return self.slice_bom(path.read.gsub(/\r\n/, "\n"))
		else
			return nil
		end
	end

 	# 指定したファイルに、文字列をテキストモードで書き込もうと試みる
	# ロックやエラーのハンドリングは行わない（エラーはそのまま外に投げる）
	def self.write_text(path, text, mode =  File::WRONLY|File::CREAT|File::TRUNC, permission = 0666)
		path = Pathname.new(path.to_s) unless path.is_a?(Pathname)
		
		open(path, mode, permission){|f|
			f.write text.gsub(/\r\n/, "\n")
		}
	end

	STATIC_ENTRY_PATTERN = /\A[^0-9]/
	def self.static_entry_id?(id)
		id =~ STATIC_ENTRY_PATTERN
	end
	
	# メールアドレスやURLを実体参照に変換（自動収集プログラムへの対策）
	def self.get_html_entity(text)
		forced = ':@/'
		entity = ""
		text.each_byte do |c|
			# 強制変換文字以外は、3/4の確率で変換
			if forced.include?(c) || rand(4) >= 1 then
				entity << "&##{c.to_i};"
			else
				entity << c
			end
		end
		return(entity)
	end
	

	
	
end



