# HTML Generator!
# $Id: html-gen.rb,v 1.9 2002/05/17 04:54:14 izawa Exp $

module HTML
  class Tag
    include Enumerable
    attr :name, true
    attr :contents
    attr :attribs

    def initialize(name = nil, *attrs)
      @name = name if name
      @contents = []
      @index = {}
      @attribs = {}
      unless attrs.empty?
				attrs.each do |at|
					self << at
				end
      end

      wrap { yield } if iterator?
    end

    def <<(other)
      case other
      when Hash
				other.each do |k,v|
					@attribs[k] = v
				end

      else
				@contents << other
      end

      self
    end

    alias add <<

    def wrap
      self.add yield
    end

    def [](key)
			@attribs[key]
    end

    def []=(key, val)
			@attribs[key] = val
    end

    def to_s
      s = ""
      if @name
				s = "<#{@name}"
				@attribs.each do |k,v|
					if v == true
						s << " #{k}"
					else
						s << " #{k}=\"#{v}\""
					end
				end
				s << ">"
      end

      @contents.each do |c|
				if c.respond_to? "to_html"
					s << c.to_html
				elsif c.is_a? String
					s << c
				else
					s << c.to_s
				end
      end
      
      s << "</#{@name}>" if @name
      return s
    end

    alias to_str to_s
      
    def each
      @contents.each do |c|
				yield c
      end
    end

    def each_attribute
      @attribs.each do |k,v|
				yield k,v
      end
    end

    def inspect
      self.to_s.inspect
    end

    alias tags contents
  end
end

#
# Generate <HTML>
#

module HTML
  class HTML < Tag
    attr :title
    attr :head
    attr :body

    def initialize(title = nil)
      @head = Tag.new("HEAD", "")
      @body = Tag.new("BODY", "")
      super("HTML")
      @contents = [@head, @body]
			if title
	  		@title = Tag.new("TITLE", title)
	  		@head << @title
			end
    end

    def <<(other)
      @body << other
    end

    def []=(key, val)
      @body[key] = val
    end

    def [](key)
      @body[key]
    end
    
    alias generate! to_s
  end
end
