require 'amrita/template'

require 'pinkyblog/config'
require 'pinkyblog/request'

module PinkyBlog
	class MenuItem
		attr_reader :context, :path, :caption_key, :title
		def initialize(context, path, caption_key, title = caption_key)
			@context = context
			@path = path
			@caption_key = caption_key
			@title = title
		end
		
		def caption
			@context.config.menu_captions[@caption_key]
		end
		
		
		
		def to_model(index, current_item = false)
			model = {}
			model[:a] = Amrita.a({:href => @context.route_to(@path), :title => @title}){caption}
			model[:class] = 'menu-on' if current_item
			model[:id] = sprintf("MENU%02d", index + 1)
			return model
		end
		
		def to_pan
			[@context.route_to(@path), @title]
		end
		
		def current_menu?(req = @context.request)
			current = "/#{req.path_items.join('/')}"
			if @path == '/' then
				current == '/'
			else
				@path_pattern ||= Regexp.new("^#{Regexp.escape(@path)}")
				return (current =~ @path_pattern ? true : false) 
			end
			
		end
	end
	
end
