# コンフィグ
require 'pathname'
require 'anjson'

require 'pinkyblog/function'

module PinkyBlog
	class Config
		attr_accessor :home_url, :site_title
		attr_accessor :about_visible, :recent_entries_visible, :news_feed_visible
		attr_accessor :default_translator
		attr_accessor :master_password, :http_server_port
		attr_accessor :writer_name, :writer_address, :headline_title
		attr_accessor :referer_visible
		attr_accessor :commentator_name_required, :commentator_address_required
		attr_accessor :message_form_visible, :message_form_title, :message_form_guide
		attr_accessor :use_path_info
		attr_accessor :auto_login
		attr_accessor :menu_captions
		attr_accessor :comment_length_limit, :message_length_limit
		attr_accessor :block_http, :block_ascii, :ng_words

		attr_accessor :demo
		
		
		alias about_visible? about_visible
		alias recent_entries_visible? recent_entries_visible
		alias news_feed_visible? news_feed_visible 
		alias referer_visible? referer_visible
		alias commentator_name_required? commentator_name_required
		alias commentator_address_required? commentator_address_required
		alias message_form_visible? message_form_visible
		alias default_format default_translator
		alias use_path_info? use_path_info
		alias auto_login? auto_login
		alias demo? demo

		def initialize
			@master_password = 'test'
		
			@data_dir_path = './data/'
			@mod_dir_path = './mod/'
			@lib_dir_path = './lib/'
			@res_dir_path = './res/'
			@feed_dir_path = './feed/'
			@cdp_dir_path = './csstemplate/'
			
			@http_server_port = 8888

			@default_translator = 'markdown'
			
			@home_url = nil
			@site_title = 'no title blog'
			@about_visible = true
			@recent_entries_visible = true
			@news_feed_visible = true
			@referer_visible = true
			@writer_name = "no name writer"
			@writer_address = nil
			
			@headline_title = '最近の更新'
			
			@auto_login = true
			
			@use_path_info = true
			
			@demo = false

			@commentator_name_required = false
			@commentator_address_required = false
			
			@message_form_visible = true
			@message_form_title = "執筆者にひとことメッセージを送る"
			@message_form_guide = "ご意見・質問・突っ込みなど、ご自由にどうぞ。"
			
			@menu_captions = {}
			MENU_KEYS.each do |key|
				@menu_captions[key] = key.tr('_', ' ')
			end
			
			@comment_length_limit = 'loose'
			@message_length_limit = 'loose'
			@block_http = true
			@block_ascii = true
			@ng_words = []
		end
		
		def transform_for_spec
			@lib_dir_path = './'
		end
		
		def lib_dir_path
			Pathname.new(@lib_dir_path)
		end

		def data_dir_path
			Pathname.new(@data_dir_path)
		end
		
		def mod_dir_path
			Pathname.new(@mod_dir_path)
		end
		
		def res_dir_path
			Pathname.new(@res_dir_path)
		end

		def feed_dir_path
			Pathname.new(@feed_dir_path)
		end
		
		def cdp_dir_path
			Pathname.new(@cdp_dir_path)
		end
		
		def cdp_file_path
			cdp_dir_path + 'style.css'
		end
		
		def real_message_length_limit
			LIMIT_TABLE[:message_length][@message_length_limit]
		end
		
		def real_comment_length_limit
			LIMIT_TABLE[:comment_length][@comment_length_limit]
		end

		# obsolete
		def get_menu_caption(key)
			@menu_captions[key]
		end
		
		def check_spam(text)
			if @block_http then
				count = 0
				text.gsub(/http[s]?\:\/\//) do
					count += 1
					return true if count >= 5
				end
			end
			
			if @block_ascii then
				ascii_count = text.each_char.find_all{|c| c.length == 1}.size
				return true if (ascii_count.to_f / text.jlength) > 0.9
			end
			
			@ng_words.each do |word|
				return true if text =~ Regexp.new(Regexp.escape(word))
			end
			
			return false
		end


		
		def extend_json(path)
			if path.readable? then
				text = PinkyBlog.slice_bom(path.read)
				data = AnJSON.parse(text)
				data.each_pair do |key, value|
					instance_variable_set("@#{key}", value)
				end
				return true
			else
				return false
			end
			
			
		end
		

		
		
		
		def Config.load(path = './pinkyblog_conf.rb')
			config = Config.new
			script = File.read(path)
			script.untaint
			config.instance_eval(PinkyBlog.slice_bom(script))
			return config
		end
	end
	
	
	
end
