/*
 * This software can be used under the license of GPL v2
 *              scratched by Hiroaki Hata
 */
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using System.IO;

namespace Pingo
{ 
    public partial class Pingo : Form
    {
        const UInt16 sqMax = 0x7FFF;
        const int level_max = 100;
        const int RECV_NORMAL   =0;
        const int TIME_OUT=1;
        const int LOSS=2;

        delegate void DelegateUpdateControl(int sq, uint delay);
        delegate void DelegateLogMessage(string message);
        HPing ping;
        Thread send_thread=null;
        Thread recv_thread=null;

        UInt16 rcpt_sq = 0;
        int Status = RECV_NORMAL;


        private void UpdateControl(int sq, uint delay)
        {
            int level = sq % level_max;
            progressBar1.Value = level;
            textBox4.Text = sq.ToString();
            textBox5.Text = ""+((float)delay)/1000.0;
        }

        private void StatusLogMessage(string mes)
        {

            if (textBox3.InvokeRequired == true)
            {
                //Child thread
                DelegateLogMessage dele = new DelegateLogMessage(StatusLogMessage);
                DateTime now = DateTime.Now;
                if (mes != null)
                {
                    object[] param = { now.ToString() + "  " + mes };
                    Invoke(dele, param);
                }
                else
                {
                    object[] param = { null };
                    Invoke(dele, param);
                }
                
            }
            else
            {
                //MainThread
                if (mes == null)
                {
                    textBox6.Text = "";
                }
                else
                {
                    textBox6.Text += mes + "\r\n";
                }
            }
        }

        private void FailLogMessage(string mes)
        {

            if (textBox3.InvokeRequired == true)
            {
                //Child thread
                DelegateLogMessage dele = new DelegateLogMessage(FailLogMessage);
                DateTime now = DateTime.Now;
                object[] param = { now.ToString() +"  "+ mes };
                Invoke(dele, param);
            }
            else
            {
                //MainThread
                textBox3.Text += mes + "\r\n";
                textBox3.SelectionStart = textBox3.Text.Length;
                textBox3.Focus();
                textBox3.ScrollToCaret();
            }
        }
        private void SendSequence(string mes)
        {

            if (textBox7.InvokeRequired == true)
            {
                //Child thread
                DelegateLogMessage dele = new DelegateLogMessage(SendSequence);
                object[] param = {mes};
                Invoke(dele, param);
            }
            else
            {
                //MainThread
                textBox7.Text=mes;
            }
        }

        private void UpdateFF(Stat st){
            StatusLogMessage(null);
            StatusLogMessage("Recv:" + st.packet + "packets");
            StatusLogMessage("Lost:" + st.lost+"packets");
            if (st.lost != 0)
            {
                StatusLogMessage("LossRate:" + ToRoundDown((100.0 * st.lost / st.packet),2) + "%");
            }
            if (st.ave_delay != 0)
            {
                StatusLogMessage("Delay(max/ave/min):" + st.max_delay + "/" + st.ave_delay + "/" + st.min_delay);
            }
        }



        private void PingRecv()
        {

            uint[] delay_array = new uint[level_max];
            int     stat_block = -1;
            UInt16  sq=0;
            uint    delay=0;
            int     ret_code;
            Stat stat = new Stat() ;

            FailLogMessage("=====StartTest====");
            FailLogMessage(""+ping.GetTargetAddress());
            DelegateUpdateControl dele = new DelegateUpdateControl(UpdateControl);
            for (; ; )
            {
                ret_code=ping.Recv(ref sq, ref delay);
                //ret_code check
                if (ret_code != 0)
                {
                    //Time out
                    if (Status != TIME_OUT)
                    {
                        FailLogMessage("Recv Time out");
                        Status = TIME_OUT;
                    }
                    //Recv Error
                    continue;
                }
                //sq=0 means initial packet, counter reset
                if (ret_code == 0 && sq == 0)
                {
                    rcpt_sq = 0;
                    continue;
                }
                if (Status == TIME_OUT)
                {
                    FailLogMessage("***Recover (sq:" + sq + " from:" + rcpt_sq + ")");
                    Status = RECV_NORMAL;
                }
                //stat block renew
                if (sq / level_max != stat_block)
                {
                    uint ave;
                    uint dmax;
                    uint dmin;
                    uint n;
                    stat_block = sq / level_max;
                    dmax=ave=0;
                    dmin=3000000;
                    n = 0;
                    for (int i = 0; i < level_max; i++)
                    {
                        if (delay_array[i] != 0)
                        {
                            n++;
                            ave += delay_array[i];
                            if (delay_array[i] < dmin)
                            {
                                dmin = delay_array[i];
                            }
                            if (dmax < delay_array[i])
                            {
                                dmax = delay_array[i];
                            }
                            delay_array[i] = 0;
                        }
                    }
                    if (n != 0)
                    {
                        stat.ave_delay = ToRoundDown(((double)ave / 1000.0 / n), 2);
                        stat.min_delay = ToRoundDown(dmin / 1000.0 ,2);
                        stat.max_delay = ToRoundDown(dmax / 1000.0, 2);
                        UpdateFF(stat);
                    }
                    stat = new Stat();
                }
                stat.packet++;
                delay_array[sq % level_max] = delay;
                //Packet Drop Check
                if (rcpt_sq + 1 != sq)
                {
                    int lost;
                    if (rcpt_sq < sq)
                    {
                        lost = sq - rcpt_sq - 1;
                    }
                    else
                    {
                        lost = sqMax - rcpt_sq + sq - 1;
                    }
                    stat.lost += lost;
                    FailLogMessage("Lost " + lost + "(sq:" + sq + " from:" + rcpt_sq + ")");
                }

                //Reset
                if (sq == sqMax)
                {
                    rcpt_sq = 0;

                }
                else
                {
                    rcpt_sq = sq;
                }
                object[] param = { sq, delay };
                Invoke(dele, param);
                
            }
        }
        public Pingo()
        {
            InitializeComponent();
        }
        
        private void start_button2_Click(object sender, EventArgs e)
        {
            StatusLogMessage(null);
            if (ping == null) return;
            start_button2.Enabled = false;
            stop_button3.Enabled = true;
            set_button1.Enabled = false;
            textBox1.Enabled = false;
            send_thread = new Thread(this.PingSend);
            recv_thread = new Thread(this.PingRecv);
            recv_thread.Start();
            send_thread.Start();
        }
        private void set_button1_Click(object sender, EventArgs e)
        {
            string hostname = textBox1.Text;
            ping = HPing.ObjectFactory(textBox1.Text);
            if (ping != null)
            {
                textBox2.Text = ping.GetTargetAddress();
                start_button2.Enabled = true;
            }
            else
            {
                textBox2.Text = "";
            }
        }
        private void PingSend()
        {
            for (UInt16 sq=0;;sq++)
            {
                if (sq > sqMax) sq = 1;
                ping.Send(24,sq);
                SendSequence("" + sq);
                System.Threading.Thread.Sleep(93);
            }
        }


        private void StopThread()
        {

            if (send_thread != null)
            {
                send_thread.Abort();
                send_thread.Join();
                send_thread = null;
            }
            if (recv_thread != null)
            {
                recv_thread.Abort();
                recv_thread.Join();
                recv_thread = null;
            }
        }

        private void stop_button3_Click(object sender, EventArgs e)
        {
            StopThread();
            start_button2.Enabled = true;
            stop_button3.Enabled = false;
            set_button1.Enabled = true;
            textBox1.Enabled = true;
        }

        

        public static double ToRoundDown(double dValue, int iDigits)
        {
            double dCoef = System.Math.Pow(10, iDigits);

            return dValue > 0 ? System.Math.Floor(dValue * dCoef) / dCoef :
                                System.Math.Ceiling(dValue * dCoef) / dCoef;
        }

        private void FlushFailureLog(){

            try
            {
                string filename;
                string timename="";

                if (textBox3.Text == null || textBox3.Text.Length == 0) return;
                DateTime d = DateTime.Now;
                timename += (d.Year*10000+d.Month*100+d.Day);
                timename += "-";
                timename += (d.Hour * 10000 + d.Minute * 100 + d.Second);
                filename = "pingo" +timename+ ".log";
                FileStream fs = new FileStream(filename, FileMode.Create);
                StreamWriter sw = new StreamWriter(fs);
                sw.Write(textBox3.Text);
                textBox3.Text = "Flushed into " + filename + "\r\n";
                textBox3.Text += "----------------------------\r\n";
                sw.Close();
                fs.Close();
            }
            catch (Exception )
            {
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            FlushFailureLog();
        }
    }

    class Stat
    {
        public int packet;
        public int lost;
        public double ave_delay;
        public double max_delay;
        public double min_delay;

        public Stat()
        {
            packet = 0;
            lost = 0;
            ave_delay = max_delay = min_delay = 0;
        }
    }

    static class Program
    {
        /// <summary>
        /// AvP[ṼC Gg |CgłB
        /// </summary>
        [STAThread]
        static void Main()
        {
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);
            Application.Run(new Pingo());
        }
    }
    

}