/*
 * Decompiled with CFR 0.152.
 */
package jdd.des.automata;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import jdd.des.automata.Automata;
import jdd.des.automata.Automaton;
import jdd.des.automata.AutomatonException;
import jdd.des.automata.Event;
import jdd.des.automata.State;
import jdd.des.automata.Transition;
import jdd.util.Test;

public class AutomataOperations {
    public static void distinguishMarkedAndInitial(Automaton automaton) throws AutomatonException {
        if (automaton.numOfNodes() <= 1) {
            return;
        }
        State state = AutomataOperations.getInitialState(automaton);
        if (!state.isMarked()) {
            return;
        }
        String string = AutomataOperations.safeStateName(automaton, state.getLabel() + "_distinguished");
        State state2 = automaton.addState(string);
        Transition transition = (Transition)state.firstOut;
        while (transition != null) {
            Transition transition2 = transition.n2 == transition.n1 ? automaton.addTransition(state2, state2, transition.event) : automaton.addTransition(state2, (State)transition.n2, transition.event);
            transition2.copyAttributesFrom(transition);
            transition = (Transition)transition.next;
        }
        state2.copyAttributesFrom(state);
        state2.setInitial(true);
        state2.setMarked(false);
        state.setInitial(false);
    }

    public static String safeStateName(Automaton automaton, String string) {
        int n = 1;
        while (true) {
            String string2;
            String string3 = string2 = n == 1 ? string : string + "_" + n;
            if (automaton.findState(string2) == null) {
                return string2;
            }
            ++n;
        }
    }

    public static State getInitialState(Automaton automaton) throws AutomatonException {
        State state = null;
        int n = 0;
        Enumeration enumeration = automaton.getNodes().elements();
        while (enumeration.hasMoreElements()) {
            State state2 = (State)enumeration.nextElement();
            if (!state2.isInitial()) continue;
            state = state2;
            ++n;
        }
        if (n == 0) {
            throw new AutomatonException("No initial state found");
        }
        if (n != 1) {
            throw new AutomatonException("Multiple (" + n + ") initial states found");
        }
        return state;
    }

    public static int countMarked(Automaton automaton) {
        int n = 0;
        Enumeration enumeration = automaton.getNodes().elements();
        while (enumeration.hasMoreElements()) {
            State state = (State)enumeration.nextElement();
            if (!state.isMarked()) continue;
            ++n;
        }
        return n;
    }

    public static Automaton[] asArray(Automata automata) {
        Automaton[] automatonArray = new Automaton[automata.size()];
        int n = 0;
        Enumeration enumeration = automata.elements();
        while (enumeration.hasMoreElements()) {
            automatonArray[n] = (Automaton)enumeration.nextElement();
            ++n;
        }
        return automatonArray;
    }

    public static String getSafeName(Automata automata, String string) {
        HashSet<String> hashSet = new HashSet<String>();
        Enumeration enumeration = automata.elements();
        while (enumeration.hasMoreElements()) {
            hashSet.add(((Automaton)enumeration.nextElement()).getName());
        }
        int n = 1;
        while (true) {
            String string2;
            String string3 = string2 = n == 1 ? string : string + n;
            if (!hashSet.contains(string2)) {
                return string2;
            }
            ++n;
        }
    }

    public static Set getUnionAlphabet(Automaton[] automatonArray) {
        HashSet<Event> hashSet = new HashSet<Event>();
        for (int i = 0; i < automatonArray.length; ++i) {
            Event event = automatonArray[i].getAlphabet().head();
            while (event != null) {
                hashSet.add(event.parent);
                event = event.next;
            }
        }
        return hashSet;
    }

    public static void internal_test() {
        Test.start("AutomataOperations");
        try {
            Automata automata = new Automata();
            Automaton automaton = automata.add("test");
            Event event = automaton.addEvent("a");
            Event event2 = automaton.addEvent("b");
            State state = automaton.addState("0");
            State state2 = automaton.addState("1");
            State state3 = automaton.addState("2");
            Transition transition = automaton.addTransition(state, state2, event);
            Transition transition2 = automaton.addTransition(state, state3, event2);
            state.setInitial(true);
            state.setMarked(true);
            Test.checkEquality(1, AutomataOperations.countMarked(automaton), "count marked");
            Test.check(state == AutomataOperations.getInitialState(automaton), "getInitialState");
            AutomataOperations.distinguishMarkedAndInitial(automaton);
            State state4 = AutomataOperations.getInitialState(automaton);
            Test.check(state != state4, "distinguishMarkedAndInitial (1)");
            Test.check(!state.isInitial(), "distinguishMarkedAndInitial (2)");
            Test.checkEquality(4, automaton.numOfNodes(), "distinguishMarkedAndInitial (3)");
            Test.checkEquality(4, automaton.numOfEdges(), "distinguishMarkedAndInitial (4)");
        }
        catch (Exception exception) {
            Test.check(false, exception.toString());
        }
        Test.end();
    }
}

