/*
 * Decompiled with CFR 0.152.
 */
package jdd.bdd;

import java.util.Collection;
import java.util.LinkedList;
import jdd.bdd.debug.BDDDebuger;
import jdd.util.Allocator;
import jdd.util.Array;
import jdd.util.Configuration;
import jdd.util.JDDConsole;
import jdd.util.Options;
import jdd.util.Test;
import jdd.util.math.HashFunctions;
import jdd.util.zip.MemoryInputStream;
import jdd.util.zip.ZipArray;

public class NodeTable {
    public static final int NODE_MARK = Integer.MIN_VALUE;
    public static final int NODE_UNMARK = Integer.MAX_VALUE;
    private static final short MAX_REFCOUNT = Short.MAX_VALUE;
    private static final int NODE_WIDTH = 3;
    private static final int OFFSET_VAR = 1;
    private static final int OFFSET_LOW = 0;
    private static final int OFFSET_HIGH = 2;
    private static final int LIST_WIDTH = 2;
    private static final int OFFSET_NEXT = 0;
    private static final int OFFSET_PREV = 1;
    private Collection debugers = new LinkedList();
    protected int table_size;
    protected int stat_nt_grow;
    protected int dead_nodes;
    protected int nodesminfree;
    private int[] t_nodes;
    private int[] t_list;
    private short[] t_ref;
    private int first_free_node;
    private int free_nodes_count;
    private boolean stack_marking_enabled;
    protected int stat_gc_count;
    protected int stat_lookup_count;
    protected long stat_gc_freed;
    protected long stat_gc_time;
    protected long stat_grow_time;
    protected long stat_notify_time;
    protected int[] work_stack;
    protected int[] mark_stack;
    protected int work_stack_tos;
    protected long ht_chain;
    private String check_say = null;

    public NodeTable(int n) {
        if (n < 100) {
            n = 100;
        }
        this.table_size = n;
        this.t_ref = Allocator.allocateShortArray(this.table_size);
        this.t_nodes = Allocator.allocateIntArray(this.table_size * 3);
        this.t_list = Allocator.allocateIntArray(this.table_size * 2);
        this.first_free_node = 2;
        this.free_nodes_count = n - 2;
        for (int i = 0; i < n; ++i) {
            this.invalidate(i);
            this.setPrev(i, 0);
            this.setNext(i, i + 1);
        }
        this.setNext(n - 1, 0);
        this.setAll(0, -1, 0, 0, (short)Short.MAX_VALUE);
        this.setAll(1, -1, 1, 1, (short)Short.MAX_VALUE);
        this.update_grow_parameters();
        this.stat_nt_grow = 0;
        this.dead_nodes = 0;
        this.stat_lookup_count = 0;
        this.stat_gc_count = 0;
        this.stat_notify_time = 0L;
        this.stat_grow_time = 0L;
        this.stat_gc_time = 0L;
        this.stat_gc_freed = 0L;
        this.ht_chain = 0L;
        this.work_stack = Allocator.allocateIntArray(32);
        this.mark_stack = Allocator.allocateIntArray(this.work_stack.length);
        this.work_stack_tos = 0;
        this.stack_marking_enabled = false;
    }

    public void cleanup() {
        this.stopDebuggers();
        this.t_ref = null;
        this.t_nodes = null;
        this.t_list = null;
        this.work_stack = null;
        this.mark_stack = null;
    }

    protected void tree_depth_changed(int n) {
        int n2 = n * 4 + 3;
        if (this.mark_stack.length < n2) {
            this.mark_stack = Allocator.allocateIntArray(n2 * 2);
        }
    }

    private final int compute_hash(int n, int n2, int n3) {
        return (HashFunctions.hash_prime(n, n2, n3) & Integer.MAX_VALUE) % this.table_size;
    }

    private final int compute_increase_limit(int n) {
        if (Configuration.nodetableSmallSize <= 0 || Configuration.nodetableLargeSize <= 0) {
            return n;
        }
        if (n <= Configuration.nodetableSmallSize) {
            return Configuration.nodetableGrowMax;
        }
        if (n >= Configuration.nodetableLargeSize) {
            return Configuration.nodetableGrowMin;
        }
        if (Configuration.nodetableLargeSize == Configuration.nodetableSmallSize) {
            return (Configuration.nodetableGrowMax + Configuration.nodetableGrowMin) / 2;
        }
        return Configuration.nodetableGrowMax - (n - Configuration.nodetableSmallSize) * (Configuration.nodetableGrowMax - Configuration.nodetableGrowMin) / (Configuration.nodetableLargeSize - Configuration.nodetableSmallSize);
    }

    protected void post_removal_callbak() {
    }

    protected final void signal_removed() {
        long l = System.currentTimeMillis();
        this.post_removal_callbak();
        this.stat_notify_time += System.currentTimeMillis() - l;
    }

    public int gc() {
        return this.gc(true);
    }

    private int gc(boolean bl) {
        long l = System.currentTimeMillis();
        ++this.stat_gc_count;
        this.mark_nodes_in_use();
        int n = this.free_nodes_count;
        this.free_nodes_count = 0;
        this.first_free_node = 0;
        int n2 = this.table_size;
        while (n2 > 2) {
            if (this.isValid(--n2) && this.isNodeMarked(n2)) {
                this.unmark_node(n2);
                int n3 = this.compute_hash(this.getVar(n2), this.getLow(n2), this.getHigh(n2));
                this.connect_list(n2, n3);
                continue;
            }
            this.invalidate(n2);
            this.setNext(n2, this.first_free_node);
            this.first_free_node = n2;
            ++this.free_nodes_count;
        }
        if (bl) {
            this.signal_removed();
        }
        this.stat_gc_time += System.currentTimeMillis() - l;
        n2 = this.free_nodes_count - n;
        this.stat_gc_freed += (long)n2;
        if (Options.verbose) {
            JDDConsole.out.println("Garbage collection #" + this.stat_gc_count + ": " + this.table_size + " nodes, " + n2 + " freed, time " + this.stat_gc_time + "+" + this.stat_notify_time);
        }
        return n2;
    }

    private final void mark_nodes_in_use() {
        int n;
        for (n = 0; n < this.work_stack_tos; ++n) {
            this.mark_tree(this.work_stack[n]);
        }
        n = this.table_size;
        while (n != 0) {
            if (this.isValid(--n) && this.getRefPlain(n) > 0) {
                this.mark_tree(n);
            }
            this.setPrev(n, 0);
        }
    }

    protected void grow() {
        if (this.dead_nodes > 0 || this.table_size > Configuration.nodetableSimpleDeadcountThreshold) {
            int n = this.gc(false);
            this.dead_nodes = 0;
            if (n >= this.nodesminfree) {
                this.signal_removed();
                return;
            }
        }
        long l = System.currentTimeMillis();
        ++this.stat_nt_grow;
        int n = this.table_size + this.compute_increase_limit(this.nodesminfree);
        int n2 = this.table_size;
        this.safe_resize(n);
        this.table_size = n;
        this.free_nodes_count = 0;
        this.first_free_node = 0;
        int n3 = n;
        while (n3 > n2) {
            this.invalidate(--n3);
            this.setPrev(n3, 0);
            this.setNext(n3, this.first_free_node);
            this.first_free_node = n3;
            ++this.free_nodes_count;
        }
        this.clearPrev(0, n2);
        n3 = n2;
        while (n3 > 2) {
            if (this.isValid(--n3)) {
                int n4 = this.compute_hash(this.getVar(n3), this.getLow(n3), this.getHigh(n3));
                this.connect_list(n3, n4);
                continue;
            }
            this.setNext(n3, this.first_free_node);
            this.first_free_node = n3;
            ++this.free_nodes_count;
        }
        this.update_grow_parameters();
        this.signal_removed();
        l = System.currentTimeMillis() - l;
        this.stat_grow_time += l;
        if (Options.verbose) {
            JDDConsole.out.println("Node-table grown #" + this.stat_nt_grow + ": " + n2 + " -> " + n + " nodes, time " + this.stat_grow_time);
        }
    }

    public int add(int n, int n2, int n3) {
        int n4 = this.compute_hash(n, n2, n3);
        int n5 = this.getPrev(n4);
        ++this.stat_lookup_count;
        while (n5 != 0) {
            if (this.match_table(n5, n, n2, n3)) {
                return n5;
            }
            n5 = this.getNext(n5);
            ++this.ht_chain;
        }
        if (this.free_nodes_count < 2) {
            this.grow();
            n4 = this.compute_hash(n, n2, n3);
        }
        n5 = this.first_free_node;
        this.first_free_node = this.getNext(this.first_free_node);
        --this.free_nodes_count;
        this.setAll(n5, n, n2, n3, (short)-1);
        this.connect_list(n5, n4);
        return n5;
    }

    public Collection addDebugger(BDDDebuger bDDDebuger) {
        this.debugers.add(bDDDebuger);
        LinkedList linkedList = new LinkedList();
        return linkedList;
    }

    private void stopDebuggers() {
        for (BDDDebuger bDDDebuger : this.debugers) {
            bDDDebuger.stop();
        }
    }

    protected void update_grow_parameters() {
        this.nodesminfree = Math.min(this.table_size * Configuration.minFreeNodesProcent / 100, Configuration.maxNodeFree - 1);
    }

    private void safe_resize(int n) {
        this.t_ref = Array.resize(this.t_ref, this.table_size, n);
        try {
            this.t_nodes = Array.resize(this.t_nodes, 3 * this.table_size, 3 * n);
            this.t_list = Array.resize(this.t_list, 2 * this.table_size, 2 * n);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            if (Options.verbose) {
                JDDConsole.out.println("NodeTable.safe_resize failed. trying the compressed method...");
            }
            this.compressed_resize(n);
        }
    }

    private void compressed_resize(int n) {
        MemoryInputStream memoryInputStream;
        if (this.t_nodes.length != 3 * n) {
            memoryInputStream = ZipArray.compressArray(this.t_nodes);
            this.t_nodes = null;
            this.t_nodes = new int[3 * n];
            ZipArray.decompressArray(memoryInputStream, this.t_nodes);
            memoryInputStream.free();
            memoryInputStream = null;
        }
        if (this.t_list.length != 2 * n) {
            memoryInputStream = ZipArray.compressArray(this.t_list);
            this.t_list = null;
            this.t_list = new int[2 * n];
            ZipArray.decompressArray(memoryInputStream, this.t_list);
            memoryInputStream.free();
            memoryInputStream = null;
        }
    }

    public final int ref(int n) {
        short s = this.getRefPlain(n);
        if (s == -1) {
            s = 1;
        } else if (s == 0) {
            s = 1;
            --this.dead_nodes;
        } else if (s != Short.MAX_VALUE) {
            s = (short)(s + 1);
        }
        this.setRef(n, s);
        return n;
    }

    public final int deref(int n) {
        short s = this.getRefPlain(n);
        if (s == 1) {
            s = 0;
            ++this.dead_nodes;
        } else if (s != Short.MAX_VALUE && s > 0) {
            s = (short)(s - 1);
        }
        this.setRef(n, s);
        return n;
    }

    public final void saturate(int n) {
        this.setRef(n, (short)Short.MAX_VALUE);
    }

    private final short getRefPlain(int n) {
        return this.t_ref[n];
    }

    private final void setRef(int n, short s) {
        this.t_ref[n] = s;
    }

    public final short getRef(int n) {
        if (this.t_ref[n] == -1) {
            return 0;
        }
        return this.t_ref[n];
    }

    private final void setVar(int n, int n2) {
        this.t_nodes[1 + 3 * n] = n2;
    }

    private final void setLow(int n, int n2) {
        this.t_nodes[0 + 3 * n] = n2;
    }

    private final void setHigh(int n, int n2) {
        this.t_nodes[2 + 3 * n] = n2;
    }

    public final int getVar(int n) {
        return this.t_nodes[1 + 3 * n];
    }

    public final int getLow(int n) {
        return this.t_nodes[0 + 3 * n];
    }

    public final int getHigh(int n) {
        return this.t_nodes[2 + 3 * n];
    }

    protected final int getVarUnmasked(int n) {
        return this.t_nodes[1 + 3 * n] & Integer.MAX_VALUE;
    }

    public final boolean isValid(int n) {
        return this.t_nodes[1 + 3 * n] != -1;
    }

    protected final void invalidate(int n) {
        this.t_nodes[1 + 3 * n] = -1;
    }

    protected final void setAll(int n, int n2, int n3, int n4, short s) {
        this.t_nodes[3 * n + 1] = n2;
        this.t_nodes[3 * n + 0] = n3;
        this.t_nodes[3 * n + 2] = n4;
        this.t_ref[n] = s;
    }

    protected final void setAll(int n, int n2, int n3, int n4) {
        this.t_nodes[3 * n + 1] = n2;
        this.t_nodes[3 * n + 0] = n3;
        this.t_nodes[3 * n + 2] = n4;
    }

    protected final boolean match_table(int n, int n2, int n3, int n4) {
        int n5 = n * 3;
        return this.t_nodes[n5 + 1] == n2 && this.t_nodes[n5 + 0] == n3 && this.t_nodes[n5 + 2] == n4;
    }

    private final void setNext(int n, int n2) {
        this.t_list[0 + 2 * n] = n2;
    }

    private final void setPrev(int n, int n2) {
        this.t_list[1 + 2 * n] = n2;
    }

    private final int getNext(int n) {
        return this.t_list[0 + 2 * n];
    }

    private final int getPrev(int n) {
        return this.t_list[1 + 2 * n];
    }

    private final void clearPrev(int n, int n2) {
        n2 = n2 * 2 + 1;
        for (n = n * 2 + 1; n < n2; n += 2) {
            this.t_list[n] = 0;
        }
    }

    private final void connect_list(int n, int n2) {
        int n3 = n * 2;
        int n4 = n2 * 2;
        this.t_list[n3 + 0] = this.t_list[n4 + 1];
        this.t_list[n4 + 1] = n;
    }

    public void enableStackMarking() {
        this.stack_marking_enabled = true;
    }

    public final void mark_tree(int n) {
        if (this.stack_marking_enabled) {
            this.mark_tree_stack(n);
        } else {
            this.mark_tree_rec(n);
        }
    }

    private final void mark_tree_rec(int n) {
        if (n < 2) {
            return;
        }
        if (this.isNodeMarked(n)) {
            return;
        }
        this.mark_node(n);
        this.mark_tree(this.getLow(n));
        this.mark_tree_rec(this.getHigh(n));
    }

    private final void mark_tree_stack(int n) {
        if (n < 2) {
            return;
        }
        int n2 = 0;
        this.mark_stack[n2++] = n;
        this.mark_node(n);
        while (n2 > 0) {
            int n3;
            int n4;
            if ((n4 = this.getLow(n3 = this.mark_stack[--n2])) > 1 && !this.isNodeMarked(n4)) {
                this.mark_node(n4);
                this.mark_stack[n2++] = n4;
            }
            if ((n4 = this.getHigh(n3)) <= 1 || this.isNodeMarked(n4)) continue;
            this.mark_node(n4);
            this.mark_stack[n2++] = n4;
        }
    }

    public final void unmark_tree(int n) {
        if (n < 2) {
            return;
        }
        if (!this.isNodeMarked(n)) {
            return;
        }
        this.unmark_node(n);
        this.unmark_tree(this.getLow(n));
        this.unmark_tree(this.getHigh(n));
    }

    public final void mark_node(int n) {
        int n2 = 1 + 3 * n;
        this.t_nodes[n2] = this.t_nodes[n2] | Integer.MIN_VALUE;
    }

    public final void unmark_node(int n) {
        int n2 = 1 + 3 * n;
        this.t_nodes[n2] = this.t_nodes[n2] & Integer.MAX_VALUE;
    }

    public final boolean isNodeMarked(int n) {
        return (this.t_nodes[1 + 3 * n] & Integer.MIN_VALUE) != 0;
    }

    public long getMemoryUsage() {
        long l = 0L;
        if (this.t_nodes != null) {
            l += (long)(this.t_nodes.length * 4);
        }
        if (this.t_list != null) {
            l += (long)(this.t_list.length * 4);
        }
        if (this.t_ref != null) {
            l += (long)(this.t_ref.length * 2);
        }
        if (this.work_stack != null) {
            l += (long)(this.work_stack.length * 4);
        }
        if (this.mark_stack != null) {
            l += (long)(this.mark_stack.length * 4);
        }
        return l;
    }

    public int countRootNodes() {
        int n = 0;
        for (int i = 0; i < this.table_size; ++i) {
            if (!this.isValid(i) || this.getRef(i) <= 0 || this.getRef(i) == Short.MAX_VALUE) continue;
            ++n;
        }
        return n;
    }

    protected void show_tuple(int n) {
        JDDConsole.out.println("" + n + "\t" + this.getVar(n) + "\t" + this.getLow(n) + "\t" + this.getHigh(n) + "\t: " + this.getRef(n));
    }

    protected void show_table() {
        JDDConsole.out.println("Node-table:");
        for (int i = 0; i < this.table_size; ++i) {
            if (!this.isValid(i)) continue;
            this.show_tuple(i);
        }
    }

    protected void show_table_all() {
        JDDConsole.out.println("Node-table (complete):");
        for (int i = 0; i < this.table_size; ++i) {
            this.show_tuple(i);
        }
    }

    void check() {
        int n;
        int n2 = 2;
        int n3 = 0;
        for (n = 2; n < this.table_size; ++n) {
            if (this.isValid(n)) {
                ++n2;
                continue;
            }
            ++n3;
        }
        Test.check(n2 == this.table_size - this.free_nodes_count, "Invalid # of free nodes: #live= " + n2 + ", table_size=" + this.table_size + ", free_nodes_count=" + this.free_nodes_count);
        for (n = 0; n < this.table_size; ++n) {
            if (!this.isValid(n)) continue;
            if (this.getLow(n) < 0 || this.getHigh(n) < 0) {
                this.show_tuple(n);
                Test.check(false, "Invalied node entry");
            }
            if ((this.getLow(n) <= 1 || this.isValid(this.getLow(n))) && (this.getHigh(n) <= 1 || this.isValid(this.getHigh(n)))) continue;
            System.err.println();
            this.show_tuple(n);
            this.show_tuple(this.getLow(n));
            this.show_tuple(this.getHigh(n));
            Test.check(false);
        }
        if (this.table_size > 100) {
            return;
        }
        for (n = 0; n < this.table_size; ++n) {
            if (!this.isValid(n)) continue;
            for (int i = n + 1; i < this.table_size; ++i) {
                if (this.getVar(n) != this.getVar(i) || this.getLow(n) != this.getLow(i) || this.getHigh(n) != this.getHigh(i)) continue;
                JDDConsole.out.println("Duplicate entries in NodeTable (" + n + " and " + i + "): ");
                this.show_tuple(n);
                this.show_tuple(i);
                System.exit(20);
            }
        }
    }

    public void showStats() {
        JDDConsole.out.println("NT nodes/free/#grow/grow-time/dead/root: " + this.table_size + "/" + this.free_nodes_count + "/" + this.stat_nt_grow + "/" + this.stat_grow_time + "/" + this.dead_nodes + "/" + this.countRootNodes());
        JDDConsole.out.println("HT chain/access: " + this.ht_chain + "/" + this.stat_lookup_count);
        JDDConsole.out.println("GC #times/#freed/signal-time/gc-time: " + this.stat_gc_count + "/" + this.stat_gc_freed + "/" + this.stat_notify_time + "/" + this.stat_gc_time);
    }

    public void check_all_nodes() {
        int n;
        for (n = 0; n < this.work_stack_tos; ++n) {
            this.check_node(this.work_stack[n]);
        }
        for (n = 0; n < this.table_size; ++n) {
            if (!this.isValid(n) || this.getRefPlain(n) <= 0) continue;
            this.check_node(n);
        }
    }

    public void check_node(int n, String string) {
        this.check_say = string;
        this.check_node(n);
    }

    private void check_node(int n) {
        if (n < 2) {
            return;
        }
        if (!this.isValid(n)) {
            this.show_tuple(n);
            Test.check(false, "Node " + n + " invalid " + (this.check_say != null ? this.check_say : ""));
        }
    }

    private int count_free_nodes() {
        int n = 0;
        int n2 = this.first_free_node;
        while (n2 != 0) {
            ++n;
            n2 = this.getNext(n2);
        }
        return n;
    }

    public static void internal_test() {
        int n;
        Test.start("NodeTable");
        NodeTable nodeTable = new NodeTable(10);
        nodeTable.add(4, 0, 1);
        Test.check(nodeTable.table_size == nodeTable.free_nodes_count + 3, "Table ok after grow");
        nodeTable.check();
        int n2 = 15;
        nodeTable = new NodeTable(n2);
        int n3 = 0;
        for (n = 2; n < n2; ++n) {
            n3 = nodeTable.add(n, n3, n3);
        }
        nodeTable.check();
        nodeTable.grow();
        nodeTable.check();
        nodeTable.grow();
        nodeTable.check();
        nodeTable.grow();
        nodeTable.check();
        nodeTable = new NodeTable(10);
        nodeTable.work_stack[0] = n = nodeTable.add(4, 0, 1);
        ++nodeTable.work_stack_tos;
        int n4 = nodeTable.add(4, 1, 0);
        nodeTable.ref(n4);
        int n5 = nodeTable.add(3, 0, 1);
        Test.checkEquality(nodeTable.count_free_nodes(), nodeTable.free_nodes_count, "free node count correct (1)");
        nodeTable.gc();
        Test.check(nodeTable.isValid(n), "saved by work_stack");
        Test.check(nodeTable.isValid(n4), "saved by ref");
        Test.check(!nodeTable.isValid(n5), "should have been removed");
        Test.checkEquality(nodeTable.count_free_nodes(), nodeTable.free_nodes_count, "free node count correct (2)");
        nodeTable.grow();
        Test.check(nodeTable.isValid(n), "saved by work_stack");
        Test.check(nodeTable.isValid(n4), "saved by ref");
        Test.check(!nodeTable.isValid(n5), "should have been removed");
        Test.checkEquality(nodeTable.count_free_nodes(), nodeTable.free_nodes_count, "free node count correct (3)");
        Test.end();
    }
}

