/*
 * Decompiled with CFR 0.152.
 */
package jdd.util.math;

import jdd.util.Test;
import jdd.util.math.Chi2Test;
import jdd.util.math.FastRandom;

public final class HashFunctions {
    private static final int DD_P1 = 0xC00005;
    private static final int DD_P2 = 4256249;
    private static final int DD_P3 = 741457;
    private static final int DD_P4 = 1618033999;
    private static final int FNV_PRIME = 16777619;
    private static final int FNV_OFFSET = -2128830935;

    public static final int mix(int n) {
        return n ^ n >>> 8;
    }

    public static final int mix_wang(int n) {
        n += ~(n << 15);
        n ^= n >>> 10;
        n += ~(n << 3);
        n ^= n >>> 6;
        n += ~(n << 11);
        n ^= n >>> 16;
        return n;
    }

    public static final int mix_jenkins(int n) {
        n += n << 12;
        n ^= n >> 22;
        n += n << 4;
        n ^= n >> 9;
        n += n << 10;
        n ^= n >> 2;
        n += n << 7;
        n ^= n >> 12;
        return n;
    }

    private static final long pair(long l, long l2) {
        return ((l + l2) * (l + l2 + 1L) >>> 1) + 1L;
    }

    public static final int hash_pair(int n, int n2) {
        return (int)HashFunctions.pair(n, n2);
    }

    public static final int hash_pair(int n, int n2, int n3) {
        return (int)HashFunctions.pair(n, HashFunctions.pair(n2, n3));
    }

    public static final int hash_prime(int n, int n2) {
        return n * 0xC00005 + n2 * 4256249;
    }

    public static final int hash_prime(int n, int n2, int n3) {
        return n * 0xC00005 + n2 * 4256249 + n3 * 741457;
    }

    public static final int hash_jenkins(int n, int n2, int n3) {
        n -= n2;
        n -= n3;
        n2 -= n3;
        n2 -= (n ^= n3 >>> 13);
        n3 -= n;
        n3 -= (n2 ^= n << 8);
        n -= n2;
        n -= (n3 ^= n2 >>> 13);
        n2 -= n3;
        n2 -= (n ^= n3 >>> 12);
        n3 -= n;
        n3 -= (n2 ^= n << 16);
        n -= n2;
        n -= (n3 ^= n2 >>> 5);
        n2 -= n3;
        n2 -= (n ^= n3 >>> 3);
        n3 -= n;
        n3 -= (n2 ^= n << 10);
        return n3 ^= n2 >>> 15;
    }

    private static final int hash_FNV_round(int n, int n2) {
        n = n * 16777619 ^ n2 & 0xFF;
        n = n * 16777619 ^ n2 >> 8 & 0xFF;
        n = n * 16777619 ^ n2 >> 16 & 0xFF;
        n = n * 16777619 ^ n2 >> 24 & 0xFF;
        return n;
    }

    public static final int hash_FNV(int n, int n2, int n3) {
        int n4 = -2128830935;
        n4 = HashFunctions.hash_FNV_round(n4, n);
        n4 = HashFunctions.hash_FNV_round(n4, n2);
        n4 = HashFunctions.hash_FNV_round(n4, n3);
        return n4;
    }

    public static final int hash_FNV(int[] nArray, int n, int n2) {
        int n3 = -2128830935;
        for (int i = 0; i < n2; ++i) {
            n3 = HashFunctions.hash_FNV_round(n3, nArray[n + i]);
        }
        return n3;
    }

    public static void internal_test() {
        int n;
        int n2;
        Test.start("HashFunctions");
        int n3 = 10000;
        Chi2Test[] chi2TestArray = new Chi2Test[7];
        for (n2 = 0; n2 < chi2TestArray.length; ++n2) {
            chi2TestArray[n2] = new Chi2Test(n3);
        }
        do {
            n2 = FastRandom.mtrand() % n3;
            int n4 = FastRandom.mtrand() % n3;
            n = FastRandom.mtrand() % n3;
            chi2TestArray[0].add(n);
            int n5 = HashFunctions.hash_pair(n, n4);
            int n6 = HashFunctions.hash_pair(n, n4, n2);
            chi2TestArray[1].add((Integer.MAX_VALUE & HashFunctions.mix(n5)) % n3);
            chi2TestArray[2].add((Integer.MAX_VALUE & HashFunctions.mix(n6)) % n3);
            int n7 = HashFunctions.hash_prime(n, n4);
            int n8 = HashFunctions.hash_prime(n, n4, n2);
            chi2TestArray[3].add((Integer.MAX_VALUE & HashFunctions.mix(n7)) % n3);
            chi2TestArray[4].add((Integer.MAX_VALUE & HashFunctions.mix(n8)) % n3);
            int n9 = HashFunctions.hash_jenkins(n, n4, n2);
            chi2TestArray[5].add((Integer.MAX_VALUE & HashFunctions.mix(n9)) % n3);
            int n10 = HashFunctions.hash_FNV(n, n4, n2);
            chi2TestArray[6].add((Integer.MAX_VALUE & HashFunctions.mix(n10)) % n3);
        } while (chi2TestArray[0].more());
        Test.check(chi2TestArray[0].isStandardDeviationAcceptable(), "FastRandom.mtrand() has an unacceptable standard deviation");
        for (n = 5; n < chi2TestArray.length; ++n) {
            Test.check(Math.abs(chi2TestArray[n].getStandardDeviation()) < 5.0, "Standard Deviation not acceptable for hash " + n);
        }
        Test.end();
    }
}

