/*
 * Decompiled with CFR 0.152.
 */
package jdd.des.automata.bdd;

import jdd.bdd.Permutation;
import jdd.des.automata.Automata;
import jdd.des.automata.AutomataIO;
import jdd.des.automata.bdd.BDDAutomata;
import jdd.des.automata.bdd.BDDAutomataHelper;
import jdd.des.automata.bdd.SymbolicAutomataSearch;
import jdd.util.Options;

public class MonolithicSearch
implements SymbolicAutomataSearch {
    private BDDAutomata manager;
    private int mono_t;

    public MonolithicSearch(BDDAutomata bDDAutomata) {
        this.manager = bDDAutomata;
        this.mono_t = 0;
        this.mono_t = BDDAutomataHelper.getT(bDDAutomata);
    }

    @Override
    public void cleanup() {
        this.manager.deref(this.mono_t);
    }

    @Override
    public int forward(int n) {
        int n2;
        int n3 = this.manager.ref(n);
        int n4 = this.manager.getBDDCubeS();
        Permutation permutation = this.manager.getPermSp2S();
        do {
            n2 = n3;
            int n5 = this.manager.ref(this.manager.relProd(n3, this.mono_t, n4));
            int n6 = this.manager.ref(this.manager.replace(n5, permutation));
            this.manager.deref(n5);
            n3 = this.manager.orTo(n3, n6);
            this.manager.deref(n6);
        } while (n2 != n3);
        return n3;
    }

    public static void main(String[] stringArray) {
        try {
            Options.verbose = true;
            for (int i = 0; i < stringArray.length; ++i) {
                Automata automata = AutomataIO.loadXML(stringArray[i]);
                long l = System.currentTimeMillis();
                BDDAutomata bDDAutomata = new BDDAutomata(automata);
                MonolithicSearch monolithicSearch = new MonolithicSearch(bDDAutomata);
                int n = BDDAutomataHelper.getI(bDDAutomata);
                int n2 = monolithicSearch.forward(n);
                double d = BDDAutomataHelper.countStates(bDDAutomata, n2);
                bDDAutomata.cleanup();
                l = System.currentTimeMillis() - l;
                System.out.println("Found " + d + " states in " + stringArray[i] + " in " + l + "ms.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

