/*
 * Decompiled with CFR 0.152.
 */
package jdd.util;

import jdd.util.Test;

public class Flags {
    private int flags;

    public Flags(int n) {
        this.flags = n;
    }

    public Flags() {
        this(0);
    }

    protected void setAll(int n) {
        this.flags = n;
    }

    public int getAll() {
        return this.flags;
    }

    public void copyFlags(Flags flags) {
        this.flags = flags.flags;
    }

    private void set(int n) {
        this.flags |= 1 << n;
    }

    private void reset(int n) {
        this.flags &= ~(1 << n);
    }

    public void set(int n, boolean bl) {
        if (bl) {
            this.set(n);
        } else {
            this.reset(n);
        }
    }

    public boolean get(int n) {
        return (this.flags & 1 << n) != 0;
    }

    public static void internal_test() {
        int n;
        Test.start("Flags");
        Flags flags = new Flags();
        flags.set(0, true);
        flags.set(1, true);
        flags.set(1, false);
        flags.set(2, true);
        Test.checkEquality(flags.get(0), true, "get (1)");
        Test.checkEquality(flags.get(1), false, "get (2)");
        Test.checkEquality(flags.get(2), true, "get (3)");
        flags.setAll(0);
        for (n = 0; n < 32; ++n) {
            Test.checkEquality(flags.get(n), false, "get FALSE (i)");
        }
        flags.setAll(-1);
        for (n = 0; n < 32; ++n) {
            Test.checkEquality(flags.get(n), true, "get TRUE (i)");
        }
        Test.end();
    }
}

