/*
 * Decompiled with CFR 0.152.
 */
package jdd.applet;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import jdd.util.Array;

public class QueensBoard
extends Frame
implements WindowListener {
    private int n;
    private boolean[] board;

    public QueensBoard(boolean[] blArray) {
        this.board = Array.clone(blArray);
        this.n = (int)Math.sqrt(this.board.length);
        int n = Math.min(400, this.n * 50);
        BoardCanvas boardCanvas = new BoardCanvas();
        boardCanvas.setSize(new Dimension(n, n));
        this.add((Component)boardCanvas, "Center");
        this.pack();
        this.setTitle("" + this.n + "x" + this.n + " chessboard");
        this.setVisible(true);
        this.addWindowListener(this);
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    class BoardCanvas
    extends Canvas {
        BoardCanvas() {
        }

        @Override
        public void paint(Graphics graphics) {
            int n;
            int n2;
            Dimension dimension = this.getSize();
            int n3 = 1 + dimension.height;
            int n4 = 1 + dimension.width;
            int n5 = Math.max(20, Math.min(n3 / QueensBoard.this.n, n4 / QueensBoard.this.n));
            int n6 = n4 - n5 * QueensBoard.this.n;
            int n7 = n3 - n5 * QueensBoard.this.n;
            graphics.translate(n6 / 2, n7 / 2);
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, QueensBoard.this.n * n5, QueensBoard.this.n * n5);
            for (n2 = 0; n2 < QueensBoard.this.n; ++n2) {
                for (n = 0; n < QueensBoard.this.n; ++n) {
                    if ((n2 + n) % 2 != 0) continue;
                    graphics.fillRect(n2 * n5, n * n5, n5, n5);
                }
            }
            graphics.setColor(Color.red);
            n2 = n5 / 8;
            n = n5 - 2 * n2;
            for (int i = 0; i < QueensBoard.this.n; ++i) {
                for (int j = 0; j < QueensBoard.this.n; ++j) {
                    if (!QueensBoard.this.board[i + QueensBoard.this.n * j]) continue;
                    graphics.fillOval(n2 + i * n5, n2 + j * n5, n, n);
                }
            }
        }
    }
}

