/*
 * Decompiled with CFR 0.152.
 */
package jdd.sat.gsat;

import java.io.IOException;
import java.util.Enumeration;
import jdd.sat.Clause;
import jdd.sat.DimacsReader;
import jdd.sat.Var;
import jdd.sat.gsat.GSATSolver;
import jdd.util.JDDConsole;

public class WalkSATSKCSolver
extends GSATSolver {
    private int[] stack2 = null;
    private double p;

    public WalkSATSKCSolver(long l, double d) {
        super(l);
        this.p = d;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.stack2 = null;
    }

    @Override
    public int[] solve() {
        int n = 0;
        int n2 = this.cnf.num_lits;
        long l = System.currentTimeMillis();
        long l2 = l + this.maxtime;
        int n3 = Math.min(1000, 3 * n2);
        boolean[] blArray = new boolean[n2];
        if (this.stack2 == null) {
            this.stack2 = new int[this.cnf.curr];
        }
        this.randomize(blArray);
        while (l2 > System.currentTimeMillis()) {
            ++n;
            if (this.cnf.satisfies(blArray)) {
                JDDConsole.out.println("SAT/" + (System.currentTimeMillis() - l) + "ms");
                return this.toIntVector(blArray);
            }
            if (n % n3 == 0) {
                this.randomize(blArray);
                continue;
            }
            Clause clause = this.cnf.clauses[this.random(this.cnf.curr)];
            int n4 = this.findLiteral(clause, blArray);
            if (n4 == -1) {
                n4 = Math.random() < this.p ? this.random(n2) : this.findLiteral2(blArray);
            }
            blArray[n4] = !blArray[n4];
        }
        JDDConsole.out.println("UNKNOWN(" + n + " rounds)/" + (System.currentTimeMillis() - l) + "ms");
        return null;
    }

    private int findLiteral(Clause clause, boolean[] blArray) {
        int n = clause.curr;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!this.canBeChanged(clause.lits[i].var, blArray)) continue;
            this.stack[n2++] = clause.lits[i].var.index;
        }
        return n2 == 0 ? -1 : this.stack[this.random(n2)];
    }

    private boolean canBeChanged(Var var, boolean[] blArray) {
        int n = var.index;
        Enumeration enumeration = var.occurs.elements();
        while (enumeration.hasMoreElements()) {
            Clause clause = (Clause)enumeration.nextElement();
            if (!clause.satisfies(blArray)) continue;
            blArray[n] = !blArray[n];
            boolean bl = clause.satisfies(blArray);
            boolean bl2 = blArray[n] = !blArray[n];
            if (bl) continue;
            return false;
        }
        return true;
    }

    private int findLiteral2(boolean[] blArray) {
        int n;
        int n2 = -2147483647;
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < this.cnf.curr; ++n) {
            if (!this.cnf.clauses[n].satisfies(blArray)) continue;
            this.stack2[n4++] = n;
        }
        if (n4 == 0) {
            return this.random(this.cnf.num_lits);
        }
        for (n = 0; n < this.cnf.num_lits; ++n) {
            blArray[n] = !blArray[n];
            int n5 = this.subsetOfClausesStisfied(blArray, this.stack2, n4);
            boolean bl = blArray[n] = !blArray[n];
            if (n5 > n2) {
                n2 = n5;
                n3 = 0;
            }
            if (n5 != n2) continue;
            this.stack[n3++] = n;
        }
        return this.stack[this.random(n3)];
    }

    private int subsetOfClausesStisfied(boolean[] blArray, int[] nArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!this.cnf.clauses[nArray[i]].satisfies(blArray)) continue;
            ++n2;
        }
        return n2;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Need DIMACS file as argument");
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    System.out.print("Solving " + stringArray[i] + "\t\t");
                    DimacsReader dimacsReader = new DimacsReader(stringArray[i], true);
                    WalkSATSKCSolver walkSATSKCSolver = new WalkSATSKCSolver(2000L, 0.02);
                    walkSATSKCSolver.setFormula(dimacsReader.getFormula());
                    dimacsReader = null;
                    walkSATSKCSolver.solve();
                    walkSATSKCSolver.cleanup();
                    continue;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

