/*
 * Decompiled with CFR 0.152.
 */
package jdd.sat.dpll;

import java.io.IOException;
import java.util.Enumeration;
import jdd.sat.CNF;
import jdd.sat.Clause;
import jdd.sat.DimacsReader;
import jdd.sat.Lit;
import jdd.sat.Solver;
import jdd.sat.Var;
import jdd.util.JDDConsole;
import jdd.util.Test;

public class DPLLSolver
implements Solver {
    protected CNF cnf = null;
    protected int top;
    protected int max;
    protected int var_top;
    protected int assign_top;
    protected Clause[] cs;
    protected Clause[] org;
    protected Lit[] assign_stack;
    protected int[] var_stack;
    protected int[] assignment;
    protected int[] choice_stack;
    protected int[] choice_stack2;
    protected int[][] occurs;
    protected long maxtime;
    protected long endtime;
    protected long branches;
    protected int choice_tos;

    public DPLLSolver() {
        this(5000L);
    }

    public DPLLSolver(long l) {
        this.maxtime = l;
    }

    @Override
    public void setFormula(CNF cNF) {
        this.cnf = cNF;
        this.assignment = new int[cNF.num_lits];
    }

    @Override
    public void cleanup() {
        this.cnf = null;
        this.cs = null;
        this.assignment = null;
    }

    private void copy_cnf() {
        int n;
        this.top = this.max = this.cnf.curr;
        this.org = this.cnf.clauses;
        this.cs = new Clause[this.max];
        for (n = 0; n < this.top; ++n) {
            this.cs[n] = this.cnf.clauses[n];
            this.cs[n].offset = n;
            this.cs[n].top = this.cs[n].curr;
        }
        this.var_top = this.cnf.num_lits;
        this.var_stack = new int[this.var_top];
        for (n = 0; n < this.var_top; ++n) {
            this.var_stack[n] = n;
            this.cnf.vars[n].offset = n;
        }
        this.assign_top = 0;
        this.assign_stack = new Lit[this.cnf.num_lits];
        this.choice_stack = new int[Math.max(this.cnf.curr, this.cnf.num_lits)];
        this.choice_stack2 = new int[Math.max(this.cnf.curr, this.cnf.num_lits)];
        this.occurs = new int[this.var_top][];
        for (n = 0; n < this.var_top; ++n) {
            Var var = this.cnf.vars[n];
            Test.checkEquality(var.index, n, "Var.index must be from 0..num_lits-1, otherwise this wont work!");
            this.occurs[n] = new int[var.occurs.size()];
            int n2 = 0;
            Enumeration enumeration = var.occurs.elements();
            while (enumeration.hasMoreElements()) {
                Clause clause = (Clause)enumeration.nextElement();
                this.occurs[n][n2] = clause.index;
                ++n2;
            }
        }
    }

    @Override
    public int[] solve() {
        long l = System.currentTimeMillis();
        this.endtime = l + this.maxtime;
        this.branches = 0L;
        this.copy_cnf();
        try {
            boolean bl = this.dpll();
            l = System.currentTimeMillis() - l;
            if (!bl) {
                JDDConsole.out.println("UNSAT/" + l + "ms");
                return null;
            }
            boolean[] blArray = new boolean[this.assignment.length];
            for (int i = 0; i < this.assignment.length; ++i) {
                blArray[i] = this.assignment[i] == 1;
            }
            if (!this.cnf.satisfies(blArray)) {
                JDDConsole.out.println("MINTERM _NOT_ VALID!!!");
            }
            JDDConsole.out.println("SAT/" + l + "ms");
            return this.assignment;
        }
        catch (InterruptedException interruptedException) {
            l = System.currentTimeMillis() - l;
            JDDConsole.out.println("UNKNOWN(" + this.branches + " branches)/" + l + "ms");
            return null;
        }
    }

    protected Clause getUnitClause() {
        if (this.choice_tos == 0) {
            return null;
        }
        return this.cs[this.choice_stack[(int)(Math.random() * (double)this.choice_tos)]];
    }

    protected boolean searchClauses() {
        this.choice_tos = 0;
        for (int i = 0; i < this.top; ++i) {
            if (this.cs[i].isNull()) {
                return false;
            }
            if (!this.cs[i].isUnit()) continue;
            this.choice_stack[this.choice_tos++] = i;
        }
        return true;
    }

    protected Var varToBranch() {
        if (this.var_top == 0) {
            return null;
        }
        return this.cnf.vars[this.var_stack[(int)(Math.random() * (double)this.var_top)]];
    }

    protected boolean dpll() throws InterruptedException {
        block3: {
            Clause clause;
            Lit lit;
            do {
                if (!this.searchClauses()) {
                    return false;
                }
                if (this.allAssigned()) {
                    return true;
                }
                clause = this.getUnitClause();
                if (clause == null) break block3;
            } while (this.prop(lit = clause.first()));
            return false;
        }
        return this.dpll_prop();
    }

    protected final boolean dpll_prop() throws InterruptedException {
        if (System.currentTimeMillis() > this.endtime) {
            throw new InterruptedException("");
        }
        if (!this.searchClauses()) {
            return false;
        }
        if (this.allAssigned()) {
            return true;
        }
        boolean bl = false;
        Clause clause = this.getUnitClause();
        if (clause != null) {
            Lit lit = clause.first();
            bl = this.prop(lit);
            if (bl) {
                bl = this.dpll_prop();
            }
            this.unprop(lit);
        } else {
            ++this.branches;
            Var var = this.varToBranch();
            Lit lit = var.var;
            bl = this.prop(lit);
            if (bl) {
                bl = this.dpll_prop();
            }
            this.unprop(lit);
            if (!bl) {
                bl = this.prop(lit = lit.negate());
                if (bl) {
                    bl = this.dpll_prop();
                }
                this.unprop(lit);
            }
        }
        return bl;
    }

    protected void showC(int n) {
        int n2;
        Clause clause = this.cs[n];
        System.out.print("" + (1 + clause.index) + "\t:");
        for (n2 = 0; n2 < clause.top; ++n2) {
            clause.lits[n2].showDIMACS();
        }
        if (clause.top != clause.curr) {
            System.out.print(" | ");
            for (n2 = clause.top; n2 < clause.curr; ++n2) {
                clause.lits[n2].showDIMACS();
            }
        }
        System.out.println();
    }

    protected void showAssignments() {
        System.out.print("Assigned vars:");
        for (int i = this.var_top; i < this.cnf.num_lits; ++i) {
            Var var = this.cnf.vars[this.var_stack[i]];
            boolean bl = this.assignment[var.index] != 0;
            System.out.print(" " + (bl ? "" : "-") + (var.index + 1));
        }
        System.out.println();
    }

    protected final boolean isSatisfied(Clause clause) {
        for (int i = 0; i < clause.curr; ++i) {
            boolean bl;
            Lit lit = clause.lits[i];
            Var var = lit.var;
            if (!this.isRemoved(var)) continue;
            boolean bl2 = bl = this.assignment[lit.index] != 0;
            if (lit.neg == bl) continue;
            return true;
        }
        return false;
    }

    protected final boolean isRemoved(Clause clause) {
        return clause.offset >= this.top;
    }

    protected final boolean isRemoved(Var var) {
        return var.offset >= this.var_top;
    }

    protected final void remove(Clause clause) {
        if (clause.offset < this.top) {
            this.swap(clause, this.cs[--this.top]);
        }
    }

    protected final void reinsert(Clause clause) {
        if (clause.offset >= this.top) {
            this.swap(clause, this.cs[this.top++]);
        }
    }

    protected final void swap(Clause clause, Clause clause2) {
        if (clause.offset != clause2.offset) {
            int n = clause.offset;
            clause.offset = clause2.offset;
            clause2.offset = n;
            this.cs[clause.offset] = clause;
            this.cs[clause2.offset] = clause2;
        }
    }

    protected final boolean allAssigned() {
        return this.var_top == 0;
    }

    protected final void remove(Var var) {
        if (var.offset < this.var_top) {
            this.swap(var.offset, --this.var_top);
        }
    }

    protected final void reinsert(Var var) {
        if (var.offset >= this.var_top) {
            this.swap(var.offset, this.var_top++);
        }
    }

    protected final void swap(int n, int n2) {
        if (n != n2) {
            int n3 = this.var_stack[n];
            this.var_stack[n] = this.var_stack[n2];
            this.var_stack[n2] = n3;
            this.cnf.vars[this.var_stack[n2]].offset = n2;
            this.cnf.vars[this.var_stack[n]].offset = n;
        }
    }

    protected final boolean prop(Lit lit) {
        this.assign_stack[this.assign_top++] = lit;
        Var var = lit.var;
        this.remove(var);
        this.assignment[lit.index] = lit.neg ? 0 : 1;
        boolean bl = true;
        int[] nArray = this.occurs[var.index];
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Clause clause = this.org[nArray[i]];
            if (clause.remove(var) == lit.neg) {
                this.remove(clause);
                continue;
            }
            if (this.isRemoved(clause) || !clause.isNull()) continue;
            bl = false;
        }
        return bl;
    }

    protected final void unprop(Lit lit) {
        --this.assign_top;
        Var var = lit.var;
        this.reinsert(var);
        int[] nArray = this.occurs[var.index];
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Clause clause = this.org[nArray[i]];
            if (clause.reinsert(var) != lit.neg || !this.isRemoved(clause) || this.isSatisfied(clause)) continue;
            this.reinsert(clause);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Need DIMACS file as argument");
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    System.out.print("Solving " + stringArray[i] + "\t\t");
                    DimacsReader dimacsReader = new DimacsReader(stringArray[i], true);
                    DPLLSolver dPLLSolver = new DPLLSolver();
                    dPLLSolver.setFormula(dimacsReader.getFormula());
                    dimacsReader = null;
                    int[] nArray = dPLLSolver.solve();
                    dPLLSolver.cleanup();
                    continue;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

