/*
 * Decompiled with CFR 0.152.
 */
package v1;

import java.util.Arrays;
import v1.ParameterModel;
import v1.ParameterValuePair;
import v1.ParameterValuePairComparator;
import v1.TripleList;
import v1.TupleTable;

class TripleTable
extends TupleTable {
    TripleList[][][] table;
    ParameterModel parametermodel;

    TripleTable(ParameterModel parametermodel) {
        this.parametermodel = parametermodel;
        int n = parametermodel.size;
        this.table = new TripleList[n][n][n];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                int k = 0;
                while (k < n) {
                    if (i < j && j < k) {
                        this.table[i][j][k] = new TripleList(parametermodel.range[i], parametermodel.range[j], parametermodel.range[k]);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    boolean get(int p1, byte v1, int p2, byte v2, int p3, byte v3) {
        ParameterValuePair[] pv = new ParameterValuePair[]{new ParameterValuePair(p1, v1), new ParameterValuePair(p2, v2), new ParameterValuePair(p3, v3)};
        Arrays.sort(pv, new ParameterValuePairComparator());
        return this.table[pv[0].p][pv[1].p][pv[2].p].list[this.getOffset(pv)];
    }

    void set(int p1, byte v1, int p2, byte v2, int p3, byte v3) {
        ParameterValuePair[] pv = new ParameterValuePair[]{new ParameterValuePair(p1, v1), new ParameterValuePair(p2, v2), new ParameterValuePair(p3, v3)};
        Arrays.sort(pv, new ParameterValuePairComparator());
        this.table[pv[0].p][pv[1].p][pv[2].p].list[this.getOffset((ParameterValuePair[])pv)] = true;
    }

    private int getOffset(ParameterValuePair[] pv) {
        int offset = pv[0].v;
        int i = 1;
        while (i < pv.length) {
            int width = 1;
            int j = 0;
            while (j < i) {
                width *= this.parametermodel.range[pv[j].p];
                ++j;
            }
            offset += pv[i].v * width;
            ++i;
        }
        return offset;
    }
}

