/*
 * Decompiled with CFR 0.152.
 */
package jdd.util.zip;

import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import jdd.util.JDDConsole;
import jdd.util.Options;
import jdd.util.Test;
import jdd.util.zip.ArrayOutputStream;
import jdd.util.zip.MemoryInputStream;
import jdd.util.zip.MemoryOutputStream;

public class ZipArray {
    private static byte[] buff = new byte[4];

    public static MemoryInputStream compressArray(int[] nArray) {
        return ZipArray.compressArray(nArray, nArray.length);
    }

    public static MemoryInputStream compressArray(int[] nArray, int n) {
        MemoryOutputStream memoryOutputStream = new MemoryOutputStream();
        try {
            int n2;
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(memoryOutputStream);
            int n3 = 0;
            while (n3 < n) {
                n2 = nArray[n3];
                ZipArray.buff[0] = (byte)(n2 & 0xFF);
                ZipArray.buff[1] = (byte)(n2 >>> 8);
                ZipArray.buff[2] = (byte)(n2 >>> 16);
                ZipArray.buff[3] = (byte)(n2 >>> 24);
                gZIPOutputStream.write(buff, 0, 4);
                ++n3;
            }
            gZIPOutputStream.close();
            MemoryInputStream memoryInputStream = memoryOutputStream.convert();
            if (Options.verbose) {
                n2 = memoryInputStream.available();
                int n4 = n * 4;
                JDDConsole.out.println("Array size after compression: " + 100 * n2 / n4 + '%');
            }
            return memoryInputStream;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static int decompressArray(MemoryInputStream memoryInputStream, int[] nArray) {
        return ZipArray.decompressArray(memoryInputStream, nArray, nArray.length);
    }

    public static int decompressArray(MemoryInputStream memoryInputStream, int[] nArray, int n) {
        int n2 = 0;
        try {
            int n3;
            memoryInputStream.reset();
            GZIPInputStream gZIPInputStream = new GZIPInputStream(memoryInputStream);
            ArrayOutputStream arrayOutputStream = new ArrayOutputStream(nArray);
            while ((n3 = gZIPInputStream.read()) != -1) {
                arrayOutputStream.write(n3);
                n2 = arrayOutputStream.size();
                if (n2 != n) continue;
                return n2;
            }
            arrayOutputStream.free();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -1;
        }
        int n4 = n2;
        while (n4 < n) {
            nArray[n4] = 0;
            ++n4;
        }
        return n2;
    }

    public static void internal_test() {
        Test.start("ZipArray");
        int n = 10000;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = (int)(Math.random() * 1234.0);
            ++n2;
        }
        MemoryInputStream memoryInputStream = ZipArray.compressArray(nArray);
        ZipArray.decompressArray(memoryInputStream, nArray2);
        boolean bl = false;
        int n3 = 0;
        while (!bl && n3 < nArray.length) {
            if (nArray[n3] != nArray2[n3]) {
                bl = true;
            }
            ++n3;
        }
        Test.check(bl ^ true, "a1[i] == a2[i], i = " + n3);
        Test.end();
    }
}

