/*
 * Decompiled with CFR 0.152.
 */
package jdd.util.zip;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import jdd.util.Test;
import jdd.util.zip.MemoryChunk;
import jdd.util.zip.MemoryInputStream;

public class MemoryOutputStream
extends OutputStream {
    private MemoryChunk root;
    private MemoryChunk curr_write;

    public void write(int n) {
        if (this.curr_write.full()) {
            this.curr_write = this.curr_write.next = new MemoryChunk();
        }
        this.curr_write.insert((byte)(n & 0xFF));
    }

    public MemoryInputStream convert() {
        MemoryInputStream memoryInputStream = new MemoryInputStream(this.root);
        this.curr_write = null;
        this.root = null;
        return memoryInputStream;
    }

    public boolean load(String string) {
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(string);
            byte[] byArray = new byte[1024];
            while ((n = fileInputStream.read(byArray)) >= 0) {
                this.write(byArray, 0, n);
            }
            fileInputStream.close();
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public boolean save(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            MemoryChunk memoryChunk = this.root;
            do {
                fileOutputStream.write(memoryChunk.data, 0, memoryChunk.curr);
            } while ((memoryChunk = memoryChunk.next) != null);
            fileOutputStream.close();
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public static void internal_test() {
        int n;
        Test.start("MemoryOutputStream");
        MemoryOutputStream memoryOutputStream = new MemoryOutputStream();
        int n2 = 16384;
        int n3 = 0;
        while (n3 < n2) {
            memoryOutputStream.write(n3);
            ++n3;
        }
        MemoryInputStream memoryInputStream = memoryOutputStream.convert();
        Test.checkEquality(memoryInputStream.available(), n2, "correct byte in buffer");
        int n4 = 0;
        boolean bl = false;
        do {
            if ((n = memoryInputStream.read()) != -1 && n != (n4 & 0xFF)) {
                bl = true;
            }
            ++n4;
        } while (n != -1 && !bl);
        Test.check(bl ^ true, "x = (byte)c");
        Test.checkEquality(n4, n2 + 1, "correct number of reads");
        Test.end();
    }

    MemoryOutputStream() {
        this.root = this.curr_write = new MemoryChunk();
    }
}

